﻿---
title: Elastic Distribution of OpenTelemetry Python
description: The Elastic Distribution of OpenTelemetry Python (EDOT Python) is a customized version of OpenTelemetry Python.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Python
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Python: Generally available
---

# Elastic Distribution of OpenTelemetry Python
The [Elastic Distribution of OpenTelemetry (EDOT) Python](https://github.com/elastic/elastic-otel-python) is a customized version of [OpenTelemetry Python](https://opentelemetry.io/docs/languages/python), configured for the best experience with Elastic Observability.
Use EDOT Python to start the OpenTelemetry SDK with your Python application, and automatically capture tracing data, performance metrics, and logs. Traces, metrics, and logs can be sent to any OpenTelemetry Protocol (OTLP) Collector you choose.
A goal of this distribution is to avoid introducing proprietary concepts in addition to those defined by the wider OpenTelemetry community. For any additional features introduced, Elastic aims at contributing them back to the OpenTelemetry project.

## Features

In addition to all the features of the OpenTelemetry Python agent, with EDOT Python you have access to the following:
- Improvements and bug fixes contributed by the Elastic team before the changes are available in OpenTelemetry repositories.
- Optional features that can enhance OpenTelemetry data that is being sent to Elastic.
- Elastic-specific processors that ensure optimal compatibility when exporting OpenTelemetry signal data to an Elastic backend like an Elastic Observability deployment.
- Preconfigured collection of tracing and metrics signals, applying some opinionated defaults, such as which sources are collected by default.
- Compatibility with APM Agent Central Configuration to modify the settings of the EDOT Python agent without having to restart the application.

Follow the step-by-step instructions in [Setup](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup) to get started.

## Release notes

For the latest release notes, including known issues, deprecations, and breaking changes, refer to [EDOT Python release notes](https://www.elastic.co/docs/release-notes/edot/sdks/python)