﻿---
title: Configure the EDOT Node.js SDK
description: How to configure the Elastic Distribution of OpenTelemetry Node.js (EDOT Node.js) using environment variables.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Node
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Node.js: Generally available
---

# Configure the EDOT Node.js SDK
The Elastic Distribution of OpenTelemetry Node.js (EDOT Node.js) is configured with environment variables beginning with `OTEL_` or `ELASTIC_OTEL_`. Any `OTEL_*` environment variables behave the same as with the OpenTelemetry SDK. For example, all the OpenTelemetry [General SDK Configuration env vars](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) are supported. If EDOT Node.js provides a configuration setting specific to the Elastic distribution, it will begin with `ELASTIC_OTEL_`.

## Basic configuration

If not configured, EDOT Node.js will send telemetry data to `http://localhost:4318` with no authentication information, and identify the running service as `unknown_service:node`. Typically a minimal configuration will include
- `OTEL_EXPORTER_OTLP_ENDPOINT`: The full URL of an OpenTelemetry Collector where data will be sent.
- `OTEL_EXPORTER_OTLP_HEADERS`: A comma-separated list of HTTP headers used for exporting data, typically used to set the `Authorization` header with auth information.
- `OTEL_SERVICE_NAME`: The name of your service, used to distinguish telemetry data from other services in your system.

For example, when using an Elastic Cloud Serverless deployment this might be:
```bash
export OTEL_EXPORTER_OTLP_ENDPOINT="https://my-deployment-abc123.ingest.us-west-2.aws.elastic.cloud"
export OTEL_EXPORTER_OTLP_HEADERS="Authorization=ApiKey Zm9vO...mJhcg=="
export OTEL_SERVICE_NAME=my-app
```


## Configuration reference

This section attempts to list all environment variables that can be used to configure EDOT Node.js. Some settings also have a section below discussing behavior that is interesting and/or specific to EDOT Node.js.
<warning>
  The behavior of `OTEL_` environment variables are typically defined by OpenTelemetry dependencies of EDOT Node.js. In some cases, these dependencies have a "development" status (`0.x` versions). This means that their behavior can be broken in a minor release of EDOT Node.js.
</warning>

The 🔹 symbol denotes settings with a default value or behavior that differs between EDOT Node.js and OTel JS, or that only exists in EDOT Node.js.

| Name                                                   | Notes                                                                                                                                                                                                                                                                                                                    |
|--------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `OTEL_SDK_DISABLED`                                    | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Turn off the SDK.                                                                                                                                                                                   |
| `OTEL_RESOURCE_ATTRIBUTES`                             | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Key-value pairs to be used as resource attributes.                                                                                                                                                  |
| `OTEL_SERVICE_NAME`                                    | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Set the `service.name` resource attribute.                                                                                                                                                          |
| `OTEL_LOG_LEVEL`                                       | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Log level used by the SDK internal logger. The default value is `info`. Use `export OTEL_LOG_LEVEL=verbose` for troubleshooting. One of `all`, `verbose`, `debug`, `info`, `warn`, `error`, `none`. |
| `OTEL_PROPAGATORS`                                     | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Propagators to use for distributed tracing. The default value is `tracecontent,baggage`.                                                                                                            |
| `OTEL_TRACES_SAMPLER`                                  | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Sampler to use for traces. The default value is `parentbased_always_on`.                                                                                                                            |
| `OTEL_TRACES_SAMPLER_ARG`                              | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) Meaning depends on `OTEL_TRACES_SAMPLER`.                                                                                                                                                           |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_EXPORTER_OTLP_ENDPOINT`                          | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) URL to which to send spans, metrics, or logs. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_ENDPOINT`.                                                                                                                                 |
| `OTEL_EXPORTER_OTLP_HEADERS`                           | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) Key-value pairs for headers to be used in HTTP or gRPC requests. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_HEADERS`.                                                                                                               |
| `OTEL_EXPORTER_OTLP_PROTOCOL`                          | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) OTLP transport protocol. The default value is `http/protobuf`. One of `http/protobuf`, `grpc`, `http/json`. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_PROTOCOL`.                                                                   |
| `OTEL_EXPORTER_OTLP_TIMEOUT`                           | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) Maximum time, in milliseconds, exporter will wait for a batch export. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_TIMEOUT`.                                                                                                          |
| `OTEL_EXPORTER_OTLP_COMPRESSION`                       | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) The default value is `gzip`. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_COMPRESSION`.                                                                                                                                               |
| `OTEL_EXPORTER_OTLP_INSECURE`                          | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) Whether to turn off client transport security for gRPC connections. The default value is `false`. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_INSECURE`.                                                                             |
| `OTEL_EXPORTER_OTLP_CLIENT_KEY`                        | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) Client private key for mTLS communication. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_CLIENT_KEY`.                                                                                                                                  |
| `OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE`                | [(Ref)](https://opentelemetry.io/docs/specs/otel/protocol/exporter/) The trusted certificate to use when verifying a server's TLS credentials. Also supports signal-specific `OTEL_EXPORTER_OTLP_{signal}_CLIENT_CERTIFICATE`.                                                                                           |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_NODE_RESOURCE_DETECTORS`                         | [(EDOT Ref)](#otel_node_resource_detectors-details) Comma-separated list of resource detectors to use.                                                                                                                                                                                                                   |
| `OTEL_NODE_ENABLED_INSTRUMENTATIONS` 🔹                | [(EDOT Ref)](#otel_node_disabledenabled_instrumentations-details) Comma-separated list of instrumentations to turn on.                                                                                                                                                                                                   |
| `OTEL_NODE_DISABLED_INSTRUMENTATIONS` 🔹               | [(EDOT Ref)](#otel_node_disabledenabled_instrumentations-details) Comma-separated list of instrumentations to turn off.                                                                                                                                                                                                  |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `ELASTIC_OTEL_HOST_METRICS_DISABLED` 🔹                | [(EDOT Ref)](#elastic_otel_host_metrics_disabled-details) Turn off collection of metrics done by `@opentelemetry/host-metrics` package.                                                                                                                                                                                  |
| `OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE` 🔹 | [(EDOT Ref)](#otel_exporter_otlp_metrics_temporality_preference-details) The metrics exporter's default aggregation `temporality`. The default value is `delta`. The OTel default is `cumulative`.                                                                                                                       |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_SEMCONV_STABILITY_OPT_IN` 🔹                     | [(EDOT Ref)](#otel_semconv_stability_opt_in-details) Control which HTTP semantic conventions are used by `@opentelemetry/instrumentation-http`. The default value is `http`. The OTel default is an empty value.                                                                                                         |
| `ELASTIC_OTEL_CONTEXT_PROPAGATION_ONLY` 🔹             | [(EDOT Ref)](#elastic_otel_context_propagation_only-details) Set to `true` to turn on trace-context propagation in outgoing requests and log correlation. This turns off the sending of spans.                                                                                                                           |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_INSTRUMENTATION_GENAI_CAPTURE_MESSAGE_CONTENT`   | [(EDOT Ref)](#otel_instrumentation_genai_capture_message_content-details) A boolean to control whether message content should be included in GenAI-related telemetry.                                                                                                                                                    |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_BSP_SCHEDULE_DELAY`                              | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-span-processor) Duration, in milliseconds, between consecutive BatchSpanProcessor exports. The default value is `5000`.                                                                                                  |
| `OTEL_BSP_EXPORT_TIMEOUT`                              | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-span-processor) Maximum allowed time, in milliseconds, for BatchSpanProcessor to export. The default value is `30000`.                                                                                                   |
| `OTEL_BSP_MAX_QUEUE_SIZE`                              | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-span-processor) Maximum BatchSpanProcessor queue size. The default value is `2048`.                                                                                                                                      |
| `OTEL_BSP_MAX_EXPORT_BATCH_SIZE`                       | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-span-processor) Maximum BatchSpanProcessor batch size. The default value is `512`.                                                                                                                                       |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_BLRP_SCHEDULE_DELAY`                             | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-logrecord-processor) Duration, in milliseconds, between consecutive BatchLogRecordProcessor exports. The default value is `1000`.                                                                                        |
| `OTEL_BLRP_EXPORT_TIMEOUT`                             | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-logrecord-processor) Maximum allowed time, in milliseconds, for BatchLogRecordProcessor to export. The default value is `30000`.                                                                                         |
| `OTEL_BLRP_MAX_QUEUE_SIZE`                             | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-logrecord-processor) Maximum BatchLogRecordProcessor queue size. The default value is `2048`.                                                                                                                            |
| `OTEL_BLRP_MAX_EXPORT_BATCH_SIZE`                      | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#batch-logrecord-processor) Maximum BatchLogRecordProcessor batch size. The default value is `512`.                                                                                                                             |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_ATTRIBUTE_VALUE_LENGTH_LIMIT`                    | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#attribute-limits) Maximum allowed attribute value size. The default is no limit.                                                                                                                                               |
| `OTEL_ATTRIBUTE_COUNT_LIMIT`                           | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#attribute-limits) Maximum allowed attribute count. The default value is `128`.                                                                                                                                                 |
| `OTEL_SPAN_ATTRIBUTE_VALUE_LENGTH_LIMIT`               | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#span-limits) Maximum allowed span attribute value size. The default is no limit.                                                                                                                                               |
| `OTEL_SPAN_ATTRIBUTE_COUNT_LIMIT`                      | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#span-limits) Maximum allowed span attribute count. The default value is `128`.                                                                                                                                                 |
| `OTEL_SPAN_EVENT_COUNT_LIMIT`                          | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#span-limits) Maximum allowed span event count. The default value is `128`.                                                                                                                                                     |
| `OTEL_SPAN_LINK_COUNT_LIMIT`                           | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#span-limits) Maximum allowed span link count. The default value is `128`.                                                                                                                                                      |
| `OTEL_EVENT_ATTRIBUTE_COUNT_LIMIT`                     | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#span-limits) Maximum allowed attribute count per span event. The default value is `128`.                                                                                                                                       |
| `OTEL_LINK_ATTRIBUTE_COUNT_LIMIT`                      | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#span-limits) Maximum allowed attribute count per span link. The default value is `128`.                                                                                                                                        |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_LOGRECORD_ATTRIBUTE_VALUE_LENGTH_LIMIT`          | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#logrecord-limits) Maximum allowed log record attribute value size. The default is no limit.                                                                                                                                    |
| `OTEL_LOGRECORD_ATTRIBUTE_COUNT_LIMIT`                 | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#logrecord-limits) Maximum allowed log record attribute count. The default value is `128`.                                                                                                                                      |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_EXPORTER_PROMETHEUS_HOST`                        | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#prometheus-exporter) Host used by the Prometheus exporter. The default value is `localhost`.                                                                                                                                   |
| `OTEL_EXPORTER_PROMETHEUS_PORT`                        | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#prometheus-exporter) Port used by the Prometheus exporter. The default value is `9464`.                                                                                                                                        |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_TRACES_EXPORTER`                                 | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#exporter-selection) Trace exporters to use. The default value is `otlp`. Supports: `otlp`, `console`, `zipkin`, `none`.                                                                                                        |
| `OTEL_METRICS_EXPORTER`                                | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#exporter-selection) Metrics exporters to use. The default value is `otlp`. Supports: `otlp`, `console`, `prometheus`, `none`.                                                                                                  |
| `OTEL_LOGS_EXPORTER`                                   | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#exporter-selection) Logs exporters to use. The default value is `otlp`. Supports: `otlp`, `console`, `none`.                                                                                                                   |
|                                                        |                                                                                                                                                                                                                                                                                                                          |
| `OTEL_METRICS_EXEMPLAR_FILTER`                         | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#metrics-sdk-configuration) Filter for which measurements can become Exemplars. The default value is `trace_based`. One of `always_on`, `always_off`, `trace_based`.                                                            |
| `OTEL_METRIC_EXPORT_INTERVAL`                          | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#metrics-sdk-configuration) Interval, in milliseconds, between consecutive PeriodicExportingMetricReader exports. The default value is `60000`.                                                                                 |
| `OTEL_METRIC_EXPORT_TIMEOUT`                           | [(Ref)](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#metrics-sdk-configuration) Maximum allowed time, in milliseconds, for PeriodicExportingMetricReader to export data. The default value is `30000`.                                                                              |

The following settings are deprecated:

| Name                               | Notes                                                                                                                                                                           |
|------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ELASTIC_OTEL_METRICS_DISABLED` 🔹 | [(EDOT Ref)](#deprecated-elastic_otel_metrics_disabled-details) Turn off metrics export and some metrics collection by the SDK. <applies-to>: Deprecated since 1.1</applies-to> |


## Central configuration

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Preview since 9.1
  - Elastic Distribution of OpenTelemetry Node.js: Preview since 1.2
</applies-to>

APM Agent Central Configuration lets you configure EDOT Node.js instances remotely, see [Central configuration docs](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) for more details.

### Configure central configuration

To activate central configuration, set the `ELASTIC_OTEL_OPAMP_ENDPOINT` environment variable to the OpAMP server endpoint.
```sh
export ELASTIC_OTEL_OPAMP_ENDPOINT=http://localhost:4320/v1/opamp
```

To deactivate central configuration, remove the `ELASTIC_OTEL_OPAMP_ENDPOINT` environment variable and restart the instrumented application.
The following environment variable can be used to configure requests send to the OpAMP endpoint:
- `ELASTIC_OTEL_OPAMP_HEADERS`: This is a comma-separated list of `header=value` strings to include in requests to the OpAMP endpoint. This can be used to set authorization, for example `ELASTIC_OTEL_OPAMP_HEADERS="Authorization=ApiKey sekrit"`.
- `ELASTIC_OTEL_OPAMP_CERTIFICATE`: Path to a file, in PEM format, to override the built-in Node.js trusted CA certificates.
- `ELASTIC_OTEL_OPAMP_CLIENT_CERTIFICATE`: Path to a file with a client certificate or certificate chain, in PEM format, to use for mTLS.
- `ELASTIC_OTEL_OPAMP_CLIENT_KEY`: Path to file with the private key used for the Certificate Signing Request (CSR) to create the client certificate. Used for mTLS.


### Central configuration settings

You can modify the following settings for EDOT Node.js through APM Agent Central Configuration:

| Setting                         | Central configuration name        | Type                                                 |
|---------------------------------|-----------------------------------|------------------------------------------------------|
| Logging level                   | `logging_level`                   | Dynamic                                              |
| Turn off instrumentations       | `deactivate_instrumentations`     | Dynamic                                              |
| Turn off all instrumentations   | `deactivate_all_instrumentations` | Dynamic                                              |
| Send traces                     | `send_traces`                     | Dynamic <applies-to>: Preview since 1.3</applies-to> |
| Send metrics                    | `send_metrics`                    | Dynamic <applies-to>: Preview since 1.3</applies-to> |
| Send logs                       | `send_logs`                       | Dynamic <applies-to>: Preview since 1.3</applies-to> |
| Sampling rate                   | `sampling_rate`                   | Dynamic <applies-to>: Preview since 1.6</applies-to> |
| Central config polling interval | `opamp_polling_interval`          | Dynamic <applies-to>: Preview since 1.7</applies-to> |

Dynamic settings can be changed without having to restart the application.

## EDOT configuration details

This section includes additional details on some configuration settings that merit more explanation, or that have behavior that differs in EDOT Node.js when compared to OpenTelemetry JS.

### `OTEL_NODE_RESOURCE_DETECTORS` details

A comma-separated list of named resource detectors to use. EDOT Node.js supports the same set as the [`@opentelemetry/auto-instrumentations-node`](https://github.com/open-telemetry/opentelemetry-js-contrib/blob/main/packages/auto-instrumentations-node/README.md#usage-auto-instrumentation):
- `env`
- `host`
- `os`
- `process`
- `serviceinstance`
- `container`
- `alibaba`
- `aws`
- `azure`
- `gcp`
- `all` - enable all resource detectors (the default)
- `none` - disable resource detection

The "cloud" resource detectors (`alibaba`, `aws`, `azure`, `gcp`) typically make HTTP requests to local metadata services to gather [`cloud.*`](https://opentelemetry.io/docs/specs/semconv/attributes-registry/cloud/) and related resource attributes. If it is important to your application to *not* attempt to gather cloud data on startup, use the following or similar:
```bash
export OTEL_NODE_RESOURCE_DETECTORS=env,host,os,process,serviceinstance,container
```

In addition, EDOT Node.js always includes the [`telemetry.distro.*` resource attributes](https://opentelemetry.io/docs/specs/semconv/attributes-registry/telemetry/).
<note>
  Kibana relies on the `service.instance.id` resource attribute to query and break down data to be shown in [service metrics](https://www.elastic.co/docs/solutions/observability/apm/metrics-ui). If you turn off the `serviceinstance` resource detector, the dashboard won't display any data.
</note>


### `OTEL_NODE_{DISABLED,ENABLED}_INSTRUMENTATIONS` details

`OTEL_NODE_DISABLED_INSTRUMENTATIONS` is a comma-separated list of instrumentation names to disable, from the default set.
`OTEL_NODE_ENABLED_INSTRUMENTATIONS` is a comma-separated list of instrumentation names to enable. Specifying this results in *only* those instrumentations being enabled.
The default set of enabled instrumentations is [the set of included instrumentations](/docs/reference/opentelemetry/edot-sdks/node/supported-technologies#instrumentations), minus any that are noted as ["disabled by default"](/docs/reference/opentelemetry/edot-sdks/node/supported-technologies#disabled-instrumentations).
EDOT Node.js handles these settings the same as the [`@opentelemetry/auto-instrumentations-node`](https://github.com/open-telemetry/opentelemetry-js-contrib/blob/main/packages/auto-instrumentations-node/README.md#usage-auto-instrumentation), with one addition. In `@opentelemetry/auto-instrumentations-node`, the name of an instrumentation is the name of the package with the `@opentelemetry/instrumentation-` prefix removed -- `cassandra-driver` refers to the instrumentation provided by `@opentelemetry/instrumentation-cassandra`. EDOT Node.js can include instrumentations that do not have this prefix, for example `@elastic/opentelemetry-instrumentation-SOMETHING`, if/when Elastic includes additional instrumentations that do not match `@opentelemetry/instrumentation-*`. In these cases, the "name" for the instrumentation is the full package name.

### `ELASTIC_OTEL_METRICS_DISABLED` details

<applies-to>
  - Elastic Distribution of OpenTelemetry Node.js: Deprecated since 1.1
</applies-to>

Setting `ELASTIC_OTEL_METRICS_DISABLED` to `true` turns off metrics export by the SDK and some metrics collection.  This configuration setting is deprecated as of v1.1.0 in favor of using the following settings for finer control:
- To turn off the export of all metrics, set the `OTEL_METRICS_EXPORTER` environment variable to `none`.
- To turn off collection by the `@opentelemetry/instrumentation-runtime-node` package, set the `OTEL_NODE_{DISABLED,ENABLED}_INSTRUMENTATIONS` environment variable to exclude that instrumentation. For example, `OTEL_NODE_DISABLED_INSTRUMENTATIONS=runtime-node`. [(EDOT Ref)](#otel_node_disabledenabled_instrumentations-details)
- To turn off metrics collection by the `@opentelemetry/host-metrics` package, set the `ELASTIC_OTEL_HOST_METRICS_DISABLED` environment variable to `false`.


### `ELASTIC_OTEL_HOST_METRICS_DISABLED` details

EDOT Node.js collects and exports [host metrics](/docs/reference/opentelemetry/edot-sdks/node/metrics#process-and-runtime-metrics) by default, using the `@opentelemetry/host-metrics` package. To turn off host metrics collection, set the `ELASTIC_HOST_OTEL_METRICS_DISABLED` environment variable to `true`.

### `OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE` details

Elasticsearch and Kibana work best with metrics provided in delta-temporality.
Therefore, the EDOT Node.js changes the default value of `OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE` to `delta`.
You can override this default if needed, note though that some provided Kibana dashboards will not work correctly in this case.
OpenTelemetry defaults the temporality preference to `cumulative`. See [https://opentelemetry.io/docs/specs/otel/metrics/sdk_exporters/otlp/#additional-environment-variable-configuration](https://opentelemetry.io/docs/specs/otel/metrics/sdk_exporters/otlp/#additional-environment-variable-configuration)

### `OTEL_SEMCONV_STABILITY_OPT_IN` details

The `OTEL_SEMCONV_STABILITY_OPT_IN` environment variable is defined by OpenTelemetry as the mechanism for user-controlled migration from experimental to stable semantic conventions. Currently it only applies to HTTP semantic conventions. See [the OpenTelemetry HTTP semconv stability migration doc](https://opentelemetry.io/docs/specs/semconv/non-normative/http-migration/) for an introduction.
For Node.js usage, the following instrumentations produce telemetry using HTTP semantic conventions:
- `@opentelemetry/instrumentation-http`: Currently transitioning from old to stable HTTP semantic conventions, through the `OTEL_SEMCONV_STABILITY_OPT_IN` setting.
- `@opentelemetry/instrumentation-undici`: Uses the stable HTTP semantic conventions, because this instrumentation was created after HTTP semconv had stabilized.

EDOT Node.js differs from current OTel JS in that it *defaults `OTEL_SEMCONV_STABILITY_OPT_IN` to `http`*. This means that, by default, all HTTP-related telemetry from EDOT Node.js will use the newer, stable HTTP semantic conventions. (This difference from contrib is expected to be temporary, as `@opentelemetry/instrumentation-http` switches to producing only stable HTTP semantic conventions after its transition period.)

### `ELASTIC_OTEL_CONTEXT_PROPAGATION_ONLY` details

<applies-to>
  - Elastic Distribution of OpenTelemetry Node.js: Preview since 1.3
</applies-to>

Set the `ELASTIC_OTEL_CONTEXT_PROPAGATION_ONLY` environment variable to `true` to turn on trace-context propagation in outgoing requests and log correlation. This turns off the sending of spans. Setting `OTEL_TRACES_EXPORTER` to `none` overrides this setting, deactivating trace-context propagation.
Refer to the [migration guide](/docs/reference/opentelemetry/edot-sdks/node/migration#contextpropagationonly) for details on how this relates to the similar `contextPropagationOnly` setting from the non-OTel Elastic Node.js APM agent.

### `OTEL_INSTRUMENTATION_GENAI_CAPTURE_MESSAGE_CONTENT` details

Set `OTEL_INSTRUMENTATION_GENAI_CAPTURE_MESSAGE_CONTENT` to `true` to
enable capture of content data, such as prompt and completion content, in GenAI telemetry. Currently this applies to the `@opentelemetry/instrumentation-openai` instrumentation.
The `OTEL_INSTRUMENTATION_GENAI_CAPTURE_MESSAGE_CONTENT` boolean environment variable is a convention established by the OpenTelemetry GenAI SIG. It is referenced in .

### `OTEL_LOGS_EXPORTER` details

To prevent logs from being exported, set `OTEL_LOGS_EXPORTER` to `none`. However, application logs might still be gathered and exported by the Collector through the `filelog` receiver.
To prevent application logs from being collected and exported by the Collector, refer to [Exclude paths from logs collection](https://www.elastic.co/docs/reference/edot-collector/config/configure-logs-collection#exclude-logs-paths).