﻿---
title: Features of the EDOT Java Agent
description: Explore the features of the Elastic Distribution of OpenTelemetry (EDOT) Java Agent, including inherited OpenTelemetry features and exclusive Elastic enhancements like inferred spans and universal profiling integration.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/features
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Java
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Java: Generally available
---

# Features of the EDOT Java Agent
The EDOT Java agent is a [distribution](https://opentelemetry.io/docs/concepts/distributions/) of [OpenTelemetry Java Instrumentation](https://github.com/open-telemetry/opentelemetry-java-instrumentation) agent. It inherits all the features of the OpenTelemetry Java Instrumentation to capture logs, metrics, and traces.
The EDOT Java agent also provides:
- Exclusive features that are not available in the [OpenTelemetry Java Instrumentation](https://github.com/open-telemetry/opentelemetry-java-instrumentation).
- Features of [OpenTelemetry Java Instrumentation](https://github.com/open-telemetry/opentelemetry-java-instrumentation) with [different default configuration](/docs/reference/opentelemetry/edot-sdks/java/configuration#configuration-options).

In addition to the features listed, refer to [Supported technologies](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/supported-technologies).

## Resource attributes

The EDOT Java agent includes the following resource attributes providers from [opentelemetry-java-contrib](https://github.com/open-telemetry/opentelemetry-java-contrib/):
- AWS: [aws-resources](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/aws-resources). Turned on by default.
- GCP: [gcp-resources](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/gcp-resources). Turned on by default.
- Application server service name detection: [resource-providers](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/resource-providers).


## Inferred spans

The EDOT Java agent includes the [Inferred Spans Extension](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/inferred-spans) from [opentelemetry-java-contrib](https://github.com/open-telemetry/opentelemetry-java-contrib/). This extension provides the ability to enhance the traces by creating spans from [async-profiler](https://github.com/async-profiler/async-profiler) data without the need of explicit instrumentation of corresponding spans.
This feature is turned off by default and can be activated by setting `OTEL_INFERRED_SPANS_ENABLED` to `true`. Refer to [Inferred-spans](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/inferred-spans) documentation for configuration options.

## Span stacktrace

The EDOT Java agent includes the [Span Stacktrace Extension](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/span-stacktrace) from [opentelemetry-java-contrib](https://github.com/open-telemetry/opentelemetry-java-contrib/).
This feature is activated by default and allows to capture a stacktrace for spans that have a duration above a threshold. The `OTEL_JAVA_EXPERIMENTAL_SPAN_STACKTRACE_MIN_DURATION` configuration option, which defaults to `5ms`, allows to configure the minimal duration threshold. A negative value turns off the feature.
Refer to [span-stacktrace](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/span-stacktrace) for configuration options.

## Runtime metrics

Experimental runtime metrics are turned on by default.
Set `OTEL_INSTRUMENTATION_RUNTIME_TELEMETRY_EMIT_EXPERIMENTAL_TELEMETRY` to `false` to turn them off.

## Metric temporality

Elasticsearch and Kibana work best with metrics provided in delta-temporality. Therefore, the EDOT Java changes the default value of `OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE` to `DELTA`. You can override this default if needed, though some provided Kibana dashboards will not work correctly if you do it.

## Central configuration

You can manage EDOT Java configurations through the [APM Agent Central Configuration feature](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration) in the Applications UI.
Refer to [Central configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) for more information.

## Elastic Universal Profiling integration

[Universal Profiling](https://www.elastic.co/observability/universal-profiling) integration provides the ability to correlate traces with profiling data from the Elastic universal profiler. This feature is off by default.
Refer to [universal-profiling-integration](https://github.com/elastic/elastic-otel-java/tree/main/universal-profiling-integration) for details and configuration options.

## Baggage

[Baggage](https://opentelemetry.io/docs/concepts/signals/baggage/) provides a key-value store that allows to store
and propagate contextual information to traces, metrics, and logs across services.
This feature requires minimal code changes for creating and accessing the baggage using the [OpenTelemetry Java API](https://github.com/open-telemetry/opentelemetry-java). Baggage entries can be automatically added to spans and logs through these [configuration](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/baggage-processor#usage-with-sdk-auto-configuration) settings:
- `OTEL_JAVA_EXPERIMENTAL_SPAN_ATTRIBUTES_COPY_FROM_BAGGAGE_INCLUDE`
- `OTEL_JAVA_EXPERIMENTAL_LOG_ATTRIBUTES_COPY_FROM_BAGGAGE_INCLUDE`

Refer to [baggage-processor](https://github.com/open-telemetry/opentelemetry-java-contrib/tree/main/baggage-processor) and the [baggage example](https://github.com/elastic/elastic-otel-java/tree/main/examples/baggage) for more details.