﻿---
title: Configure the EDOT Java agent
description: Learn how to configure the Elastic Distribution of OpenTelemetry (EDOT) Java Agent, including minimal setup, configuration options, and methods like environment variables and system properties.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/configuration
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Java
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Java: Generally available
---

# Configure the EDOT Java agent
The [minimal configuration](#minimal-configuration) section provides a recommended starting point for EDOT Java configuration.
See [configuration options](#configuration-options) for details on the supported configuration options and [configuration methods](#configuration-methods) for how to provide them.
<note>
  [Declarative configuration](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#declarative-configuration) is not supported. Using it deactivates many agent features.
</note>


## Minimal configuration

This configuration is provided using [environment variables](#environment-variables), other [configuration methods](#configuration-methods) are also supported.
```sh
# service name: mandatory for integration in UI and correlation
OTEL_SERVICE_NAME=my-service

# resource attributes: recommended for integration in UI and correlation, can also include service.name
OTEL_RESOURCE_ATTRIBUTES='service.version=1.0,deployment.environment.name=production'

# exporter endpoint: mandatory if not using a local Collector accessible on http://localhost:4317
OTEL_EXPORTER_OTLP_ENDPOINT=https://my-otel-collector

# exporter authentication: mandatory if endpoint requires authentication
OTEL_EXPORTER_OTLP_HEADERS='Authorization=ApiKey mySecretApiKey'
```

For authentication, the `OTEL_EXPORTER_OTLP_HEADERS` can also be used with an APM secret token:
```sh
OTEL_EXPORTER_OTLP_HEADERS='Authorization=Bearer mySecretToken'
```


## Configuration options

EDOT Java instrumentation agent is based on OpenTelemetry Java [SDK](https://github.com/open-telemetry/opentelemetry-java) and [Instrumentation](https://github.com/open-telemetry/opentelemetry-java-instrumentation), and thus supports the following
configuration options:
- [OpenTelemetry Java instrumentation configuration options](https://opentelemetry.io/docs/zero-code/java/agent/configuration/)
- [OpenTelemetry Java SDK configuration options](https://opentelemetry.io/docs/languages/java/configuration/)

EDOT Java uses different defaults than the OpenTelemetry Java instrumentation for the following configuration options:

| Option                                                               | EDOT Java default | OpenTelemetry Java agent default                                                                                                             | EDOT Java version |
|----------------------------------------------------------------------|-------------------|----------------------------------------------------------------------------------------------------------------------------------------------|-------------------|
| `OTEL_RESOURCE_PROVIDERS_AWS_ENABLED`                                | `true`            | `false` ([docs](https://opentelemetry.io/docs/zero-code/java/agent/configuration/#enable-resource-providers-that-are-disabled-by-default))   | 1.0.0+            |
| `OTEL_RESOURCE_PROVIDERS_GCP_ENABLED`                                | `true`            | `false` ([docs](https://opentelemetry.io/docs/zero-code/java/agent/configuration/#enable-resource-providers-that-are-disabled-by-default))   | 1.0.0+            |
| `OTEL_RESOURCE_PROVIDERS_AZURE_ENABLED`                              | `true`            | `false` ([docs](https://opentelemetry.io/docs/zero-code/java/agent/configuration/#enable-resource-providers-that-are-disabled-by-default))   | 1.4.0+            |
| `OTEL_INSTRUMENTATION_RUNTIME-TELEMETRY_EMIT-EXPERIMENTAL-TELEMETRY` | `true`            | `false` ([docs](https://github.com/open-telemetry/opentelemetry-java-instrumentation/blob/main/instrumentation/runtime-telemetry/README.md)) | 1.4.0+            |
| `OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE`                  | `delta` (*)       | `cumulative` ([docs](https://opentelemetry.io/docs/specs/otel/metrics/sdk_exporters/otlp/#additional-environment-variable-configuration))    | 1.0.0+            |

(*) default value set to `delta` only if not already explicitly set.
The EDOT Java instrumentation agent also provides configuration options for each of the [supported features](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/features).
This table only contains minimal configuration, see each respective feature for exhaustive configuration options documentation.

| Option                                                 | Default | Feature                                                                                                                                  | EDOT Java version |
|--------------------------------------------------------|---------|------------------------------------------------------------------------------------------------------------------------------------------|-------------------|
| `OTEL_INFERRED_SPANS_ENABLED`                          | `false` | [Inferred spans](/docs/reference/opentelemetry/edot-sdks/java/features#inferred-spans)                                                   | 1.0.0+            |
| `OTEL_JAVA_EXPERIMENTAL_SPAN_STACKTRACE_MIN_DURATION`  | `5ms`   | [Span stacktrace](/docs/reference/opentelemetry/edot-sdks/java/features#span-stacktrace)                                                 | 1.0.0+            |
| `ELASTIC_OTEL_UNIVERSAL_PROFILING_INTEGRATION_ENABLED` | `false` | [Elastic Universal profiling integration](/docs/reference/opentelemetry/edot-sdks/java/features#elastic-universal-profiling-integration) | 1.0.0+            |
| `ELASTIC_OTEL_JAVAAGENT_LOG_LEVEL`                     | `INFO`  | [Agent logging](#agent-logging)                                                                                                          | 1.5.0+            |
| `ELASTIC_OTEL_VERIFY_SERVER_CERT`                      | `true`  | [Exporter certificate verification](#exporter-certificate-verification)                                                                  | 1.5.0+            |


## Elasticsearch Java client: Capturing search request bodies

<applies-to>
  - Elastic Stack: Generally available since 9.0
</applies-to>

When using the Elasticsearch Java API client, spans for Elasticsearch operations are generated directly by the client’s built-in OpenTelemetry instrumentation.
Because the client owns the instrumentation, certain fields, such as the search request body reported as `span.db.statement`, are only captured when the Elasticsearch client’s OpenTelemetry options are turned on.
For more details on instrumentation settings in the Elasticsearch Java API client, refer to the [Elasticsearch Java client documentation](https://www.elastic.co/docs/reference/elasticsearch/clients/java).

### When this applies

You might need this configuration if you notice that `span.db.statement` is missing for Elasticsearch search operations and you use:
- Elasticsearch Java API client 8.x or 9.x
- EDOT Java SDK or another OpenTelemetry Java SDK
- The APM Java Agent


### Turn on search query capture

Set either one of the following Elasticsearch client instrumentation options:

#### JVM system property

```bash
-Dotel.instrumentation.elasticsearch.capture-search-query=true
```


#### Environment variable

```bash
OTEL_INSTRUMENTATION_ELASTICSEARCH_CAPTURE_SEARCH_QUERY=true
```

The flag `otel.instrumentation.elasticsearch.enabled` is turned on by default, so you typically only need to activate `capture-search-query`.
When activated, the Elasticsearch client includes the search request body in the generated spans, and EDOT or OTel exports this value as `span.db.statement`.

## Central configuration

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Preview since 9.1
  - Elastic Distribution of OpenTelemetry Java: Preview since 1.5
</applies-to>

APM Agent Central Configuration lets you configure EDOT Java instances remotely, see [Central configuration docs](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) for more details.

### Turn on central configuration

To activate central configuration, set the `ELASTIC_OTEL_OPAMP_ENDPOINT` environment variable to the OpAMP server endpoint.
```sh
export ELASTIC_OTEL_OPAMP_ENDPOINT=http://localhost:4320/v1/opamp
```

To deactivate central configuration, remove the `ELASTIC_OTEL_OPAMP_ENDPOINT` environment variable and restart the instrumented application.

### Central configuration settings

You can modify the following settings for EDOT Java through APM Agent Central Configuration:

| Setting                       | Central configuration name        | Type                                                                                           |
|-------------------------------|-----------------------------------|------------------------------------------------------------------------------------------------|
| Logging level                 | `logging_level`                   | Dynamic                                                                                        |
| Turn off instrumentations     | `deactivate_instrumentations`     | Dynamic                                                                                        |
| Turn off all instrumentations | `deactivate_all_instrumentations` | Dynamic                                                                                        |
| Send traces                   | `send_traces`                     | Dynamic                                                                                        |
| Send metrics                  | `send_metrics`                    | Dynamic                                                                                        |
| Send logs                     | `send_logs`                       | Dynamic                                                                                        |
| OpAMP polling interval        | `opamp_polling_interval`          | Dynamic <applies-to>Elastic Distribution of OpenTelemetry Java: Preview since 1.6</applies-to> |
| Sampling rate                 | `sampling_rate`                   | Dynamic <applies-to>Elastic Distribution of OpenTelemetry Java: Preview since 1.6</applies-to> |
| Turn on/off inferred spans    | `infer_spans`                     | Dynamic <applies-to>Elastic Distribution of OpenTelemetry Java: Preview since 1.7</applies-to> |

Dynamic settings can be changed without having to restart the application.

## Configuration methods

Configuration can be provided through multiple [configuration methods](#configuration-methods):
- [Environment variables](#environment-variables)
- [System properties](#system-properties)
- [Properties configuration file](#properties-configuration-file)

Configuration options are applied with the following priorities:
- [environment variables](#system-properties) take precedence over [system properties](#system-properties) and [properties configuration file](#properties-configuration-file).
- [system properties](#system-properties) take precedence on [properties configuration file](#properties-configuration-file).

<important>
  [Declarative configuration](https://opentelemetry.io/docs/specs/otel/configuration/#declarative-configuration) is not supported.
</important>


### Environment variables

Environment variables provide a cross-platform way to configure EDOT Java and is especially useful in containerized environments.
Define environment variables before starting the JVM:
```sh
export OTEL_SERVICE_NAME=my-service
java ...
```


### System properties

These configuration options can be seen by anything that can see the executed command-line.
Define system properties at the JVM start, usually on the command-line:
```sh
java -Dotel.service.name=my-service ...
```

When modifying the JVM command line options is not possible, using the `JAVA_TOOL_OPTIONS` environment variable could
be used to provide the system properties, for example:
```sh
export JAVA_TOOL_OPTIONS='-Dotel.service.name=my-service'
```


### Properties configuration file

EDOT Java can be configured using a java properties configuration file.
Before starting the JVM, create and populate the configuration file and specify where to find it:
```sh
echo otel.service.name=my-service > my.properties
java -Dotel.javaagent.configuration-file=my.properties ...
```


## Agent logging

The EDOT Java agent provides the ability to control the agent log verbosity by setting the log level with the `ELASTIC_OTEL_JAVAAGENT_LOG_LEVEL` configuration option (`INFO` by default).
The following log levels are supported: `TRACE`, `DEBUG`, `INFO`, `WARN`, `ERROR`, `FATAL` and `OFF`.
For [troubleshooting](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/java#agent-debug-logging), the `ELASTIC_OTEL_JAVAAGENT_LOG_LEVEL=DEBUG` is a recommended alternative to `OTEL_JAVAAGENT_DEBUG=true` as it provides span information in JSON format.
This feature relies on the `OTEL_JAVAAGENT_LOGGING` configuration option to be set to `elastic` (default), the `simple` value from contrib is not supported.
Setting `OTEL_JAVAAGENT_LOGGING=none` or `ELASTIC_OTEL_JAVAAGENT_LOG_LEVEL=OFF` disables agent logging feature.
Setting `OTEL_JAVAAGENT_LOGGING=application` will disable EDOT agent logging feature and attempt to use the application logger.
As [documented here in the contrib documentation](https://opentelemetry.io/docs/zero-code/java/agent/configuration/#java-agent-logging-output),
support for this depends on the application and logging libraries used.

## Exporter certificate verification

The EDOT Java agent provides the ability to toggle the exporter endpoint certificate verification with the `ELASTIC_OTEL_VERIFY_SERVER_CERT` configuration option (`true` by default).
When the endpoint certificate is not trusted by the JVM where the agent runs, the common symptom is security-related exceptions with the following message: `unable to find valid certification path to requested target`.
This is common in the following scenarios:
- When endpoint uses a self-signed certificate not trusted by the JVM
- When the certificate authority used by the endpoint certificate is not trusted by the JVM

One solution is to add the certificate or certificate authority to the JVM trust store, which requires modifying the JVM trust store.
If trust store modification is not possible or not practical, for example when troubleshooting or working with a local deployment, certificate verification can be disabled by setting `ELASTIC_OTEL_VERIFY_SERVER_CERT` to `false`. This however need to be evaluated carefully as it lowers the communication security and could allow for man-in-the-middle attacks where the data could be intercepted between the agent and the collector endpoint.

### TLS configuration for OTLP endpoint

To secure the connection to the OTLP endpoint using TLS, you can configure the following environment variables as documented in the [OpenTelemetry OTLP Exporter specification](https://opentelemetry.io/docs/specs/otel/protocol/exporter/):

| Option                                  | Description                                                                                              |
|-----------------------------------------|----------------------------------------------------------------------------------------------------------|
| `OTEL_EXPORTER_OTLP_CERTIFICATE`        | Path to a PEM-encoded file containing the trusted certificate(s) to verify the server's TLS credentials. |
| `OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE` | Path to a PEM-encoded file containing the client certificate for mTLS.                                   |
| `OTEL_EXPORTER_OTLP_CLIENT_KEY`         | Path to a PEM-encoded file containing the client's private key for mTLS.                                 |

Signal-specific variants are also supported: `OTEL_EXPORTER_OTLP_{signal}_CERTIFICATE`, `OTEL_EXPORTER_OTLP_{signal}_CLIENT_CERTIFICATE`, and `OTEL_EXPORTER_OTLP_{signal}_CLIENT_KEY` where `{signal}` is one of `TRACES`, `METRICS` or `LOGS`.
<note>
  TLS configuration for OpAMP endpoint (central configuration) is not yet supported in EDOT Java.
</note>


## Prevent logs export

To prevent logs from being exported, set `OTEL_LOGS_EXPORTER` to `none`. However, application logs might still be gathered and exported by the Collector through the `filelog` receiver.
To prevent application logs from being collected and exported by the Collector, refer to [Exclude paths from logs collection](https://www.elastic.co/docs/reference/edot-collector/config/configure-logs-collection#exclude-logs-paths).