﻿---
title: Get started with EDOT Android
description: Set up the Elastic Distribution of OpenTelemetry Android (EDOT Android) to send data to Elastic.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/getting-started
products:
  - APM Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Android
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Android: Generally available
---

# Get started with EDOT Android
Set up the Elastic Distribution of OpenTelemetry Android (EDOT Android) in your app and explore your app's data in Kibana.

## Requirements


| Requirement                                           | Minimum version                                                                                           |
|-------------------------------------------------------|-----------------------------------------------------------------------------------------------------------|
| [Elastic Stack](https://www.elastic.co/elastic-stack) | 8.18                                                                                                      |
| Android API level                                     | 26 (or 21 with [desugaring](https://developer.android.com/studio/write/java8-support#library-desugaring)) |

<important>
  - If your application's [minSdk](https://developer.android.com/studio/publish/versioning#minsdk) value is lower than 26, you must add [Java 8 desugaring support](https://developer.android.com/studio/write/java8-support#library-desugaring). Refer to [Troubleshooting](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/android#why-desugaring) for more information.
  - EDOT Android is meant to be used in Android projects only. Hybrid frameworks, such as React Native and Flutter, are not supported.
</important>


## Gradle setup

Add the [EDOT Android agent plugin](https://plugins.gradle.org/plugin/co.elastic.otel.android.agent) to your application’s `build.gradle[.kts]` file:
```kotlin
plugins {
    id("com.android.application")
    id("co.elastic.otel.android.agent") version "[latest_version]"
}
```


## Agent setup

After you've configured Gradle, initialize the agent within your app's code:
```kotlin
val agent = ElasticApmAgent.builder(application)
    .setServiceName("My app name")
    .setExportUrl("http://10.0.2.2:4318")
    .setExportAuthentication(Authentication.ApiKey("my-api-key"))
    .build()
```

<tip>
  If you'd like to provide these values from outside of your code, using an environment variable or a properties file for example, refer to [Provide config values outside of your code](/docs/reference/opentelemetry/edot-sdks/android/configuration#provide-config-values-from-outside-of-your-code).
</tip>


## Start sending telemetry

With EDOT Android fully initialized, you can start sending telemetry to your Elastic Stack.

### Generate telemetry

The following snippet shows how to generate telemetry through [manual instrumentation](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/manual-instrumentation):
```kotlin
val agent = ElasticApmAgent.builder(application)
    .setServiceName("My app name")
    //...
    .build()


agent.span("My Span") {
    Thread.sleep(500)
    agent.span("My nested Span") {
        Thread.sleep(500)
    }
}
```


### Visualize telemetry

After your app has sent telemetry data, either [manually](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/manual-instrumentation) or [automatically](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/automatic-instrumentation), view it in Kibana by navigating to **Applications**, **Service Inventory**, or by searching for `Service Inventory` in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). You should find your application listed there.
![Services](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/images/span-visualization/1.png)

When you open it, go to the **Transactions** tab, where you should see your app's "outermost" spans listed.
![Transactions tab](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/images/span-visualization/2.png)

After clicking on the span, you should see it in detail.
![Trace sample](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/images/span-visualization/3.png)


## What’s next?

- This guide uses the minimum configuration options needed to initialize EDOT Android. If you'd like to explore what else you can customize, take a look at the [configuration page](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/configuration).
- In the example, you've manually sent a span, so you've created some [manual instrumentation](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/manual-instrumentation) for your app. While this is helpful and flexible, EDOT Android can also create automatic instrumentations. This means that by simply initializing EDOT Android, it will start sending telemetry data on your behalf without you having to write code. For more details, refer to [Automatic instrumentation](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/automatic-instrumentation).
- [Spans](https://opentelemetry.io/docs/concepts/signals/traces/#spans) are a great way to measure how long some method, part of a method, or even some broader transaction that involves multiple methods takes to complete. However, spans aren't the only type of [signal](https://opentelemetry.io/docs/concepts/signals/) that you can send using the agent. You can send [logs](https://opentelemetry.io/docs/concepts/signals/logs/) and [metrics](https://opentelemetry.io/docs/concepts/signals/metrics/) too! For more details, refer to [Manual instrumentation](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/manual-instrumentation).