﻿---
title: EDOT Cloud Forwarder for Azure
description: Set up the EDOT Cloud Forwarder for Azure to bring your Azure telemetry data to Elastic Observability.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/azure
products:
  - EDOT Cloud Forwarder
  - EDOT Cloud Forwarder for Azure
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Preview
  - Elastic Distribution of OpenTelemetry Cloud Forwarder for Azure: Preview
---

# EDOT Cloud Forwarder for Azure
EDOT Cloud Forwarder (CF) for Azure allows you to stream telemetry data from Azure services to an Elasticsearch cluster. EDOT CF for Azure supports the following sources:

| Source       | Description                     |
|--------------|---------------------------------|
| Activity log | Logs generated by Azure Monitor |

Read on to learn how to set up EDOT Cloud Forwarder for Azure.
<note>
  We are working to support other sources. Get in touch to let us know of any specific requirements that might influence our plans.
</note>


## Prerequisites

<important>
  EDOT Cloud Forwarder for Azure requires a Managed OTLP endpoint and an API key. Managed OTLP is available for Elastic Cloud Serverless and will soon be available for Elastic Cloud Hosted.For self-managed deployments, set up an EDOT Collector in [Gateway mode](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone#gateway-mode) that ingests OTel data from the edge setup into the self-managed Elastic Stack.
</important>

To collect telemetry data using EDOT Cloud Forwarder for Azure, you need:
- An Azure subscription
- Azure CLI
- Bicep extension for Azure CLI


### Azure subscription

To use EDOT Cloud Forwarder for Azure, you need an Azure subscription with permissions to create resources.
The Bicep template for EDOT Cloud Forwarder creates the following resources:
- Function App
- App Service plan
- Event Hubs Namespace with two Event Hubs (logs and metrics)
- Storage account
- Application Insights workspace


### Azure CLI

You can use the Azure CLI to deploy and manage resources required for EDOT Cloud Forwarder.
To install Azure CLI, refer to the [official documentation](https://learn.microsoft.com/en-us/cli/azure/install-azure-cli).

### Bicep extension

EDOT Cloud Forwarder for Azure uses Bicep to define all the necessary resources and their dependencies.
After you've installed Azure CLI, install Bicep by running the following command:
```bash
az bicep install
```


## Deployment considerations

Before deploying EDOT Cloud Forwarder for Azure, take the following into consideration:
- The logs event hub supports Azure resource logs.
- Support for additional encoding extensions for logs and metrics will be added in future releases.


## Deploy EDOT CF for Azure

Follow these steps to deploy EDOT Cloud Forwarder for Azure in a resource group to send telemetry data to the Elastic Cloud Managed OTLP Endpoint endpoint.
<stepper>
  <step title="Retrieve the OTLP endpoint and API key">
    To find out the URL of the managed OTLP endpoint and the API key for authentication, follow these steps:
    <dropdown title="Steps to retrieve the OTLP endpoint and API key">
      To retrieve your Elastic Cloud Managed OTLP Endpoint endpoint address and API key, follow these steps:
      <applies-switch>
        <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
          1. In Elastic Cloud, create an Observability project or open an existing one.
          2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
          3. Copy the endpoint and authentication headers values.
          Alternatively, you can retrieve the endpoint from the **Manage project** page and create an API key manually from the **API keys** page.
        </applies-item>

        <applies-item title="ess: preview" applies-to="Elastic Cloud Hosted: Preview">
          You need an Elastic Cloud Hosted deployment version 9.2 or later.
          1. In Elastic Cloud, create an Elastic Cloud Hosted deployment or open an existing one.
          2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
          3. Copy the endpoint and authentication headers values.
        </applies-item>
      </applies-switch>
      In the Bicep templates, the OTLP endpoint is set as `elasticsearchOtlpEndpoint`, and the API key is set as `elasticsearchApiKey`.
      <important>
        Trim the API key from `Authorization=ApiKey MYKEYVALUE...` to just `MYKEYVALUE...` before using it as the argument to the `elasticsearchApiKey` parameter.
      </important>
    </dropdown>
  </step>

  <step title="Set the environment variables">
    Define the following environment variables:
    ```sh
    export AZURE_LOCATION="<your_region>"
    export RESOURCE_GROUP="<group_name>"
    export ELASTICSEARCH_OTLP_ENDPOINT="<your_otlp_endpoint>"
    export ELASTICSEARCH_API_KEY="<your_api_key>"
    ```
  </step>

  <step title="Create the resource group">
    Create the resource group that hosts all the resources for EDOT Cloud Forwarder for Azure.
    ```sh
    $ az group create --name $RESOURCE_GROUP --location $AZURE_LOCATION
    {
      "id": "/subscriptions/<subscription_id>/resourceGroups/<group_name>",
      "location": "<your_region>",
      "managedBy": null,
      "name": "<group_name>",
      "properties": {
        "provisioningState": "Succeeded"
      },
      "tags": null,
      "type": "Microsoft.Resources/resourceGroups"
    }
    ```
  </step>

  <step title="Download the Bicep template">
    Download the Bicep template to deploy EDOT Cloud Forwarder for Azure at the following URL: [https://ela.st/edot-cf-azure-template](https://ela.st/edot-cf-azure-template)
  </step>

  <step title="Deploy the Bicep template">
    Deploy the Bicep template using the following command:
    ```sh
    az deployment group create \
        --resource-group ${RESOURCE_GROUP} \
        --template-file ecf.bicep \
        --parameters \
            elasticsearchOtlpEndpoint=$ELASTICSEARCH_OTLP_ENDPOINT \
            elasticsearchApiKey=$ELASTICSEARCH_API_KEY \
            logsDecoder=ds \ 
            metricsDecoder=dcr \ 
            eventHubPartitionCount=8 \
            eventHubMessageRetentionInDays=1 \
    ```
    For a complete list of parameters, refer to [Configure the template](#configure-the-template).
  </step>

  <step title="Collect telemetry data">
    Follow these instructions to collect telemetry data depending on your use case.
    <tab-set>
      <tab-item title="Activity logs">
        Create a diagnostic setting to collect Activity logs from an Azure subscription.
        1. In the Azure portal, open **Subscriptions** from the search bar.
        2. Select the Azure subscription from which you want to collect Activity logs.
        3. Go to **Activity log** → **Export Activity Logs** → **Add diagnostic setting**.

        - In **Diagnostic setting name**, enter a name for the diagnostic setting.
        - Select all categories in **Logs > Administrative**.
        - In **Destination details**, select **Stream to an event hub**.
        - In **Event hub namespace**, select the namespace created by the EDOT Cloud Forwarder (ECF) for Azure.
        - In **Event hub name (optional)**, select the `logs` event hub created by the EDOT Cloud Forwarder (ECF) for Azure.

        1. Select **Save** to create the diagnostic setting.
        2. After a few minutes, the diagnostic setting starts streaming the Activity logs to the `logs` event hub.
        3. Go to **Discover** in your Elastic Cloud deployment or Serverless project, and select the `logs-*` data view.
        4. Filter the docs by `data_stream.dataset`, to browse the Activity logs streamed to Elasticsearch.
      </tab-item>
    </tab-set>
  </step>
</stepper>


## Configure the template

EDOT Cloud Forwarder for Azure uses a Bicep template to deploy the EDOT CF.
The following parameters are available in the Bicep template:

| Parameter                        | Default | Description                                      | Available options                                            |
|----------------------------------|---------|--------------------------------------------------|--------------------------------------------------------------|
| `elasticsearchOtlpEndpoint`      |         | OTLP service endpoint.                           |                                                              |
| `elasticsearchApiKey`            |         | Elasticsearch API key.                           |                                                              |
| `logsDecoder`                    | `ds`    | Decoder to decode the logs.                      | `ds` (diagnostic settings)                                   |
| `metricsDecoder`                 | `ds`    | Decoder to decode the metrics.                   | `ds` (diagnostic settings) and `dcr` (Data Collection Rules) |
| `eventHubPartitionCount`         | `4`     | Number of partition in the event hubs.           |                                                              |
| `eventHubMessageRetentionInDays` | `1`     | Number of days for the event hub data retention. |                                                              |


## Resource group resources

The Bicep template creates a number of resources to process logs from a specific log source.
This is the list of resources created by the Bicep template.

| Resource name         | Type                                      | Description                                                                                               |
|-----------------------|-------------------------------------------|-----------------------------------------------------------------------------------------------------------|
| `eventHubNamespace`   | `Microsoft.EventHub/namespaces`           | Event Hubs namespace to host the event hubs to stream logs and metrics.                                   |
| `logsEventHub`        | `Microsoft.EventHub/namespaces/eventhubs` | Event hub for the logs.                                                                                   |
| `metricsEventHub`     | `Microsoft.EventHub/namespaces/eventhubs` | Event hub for the metrics.                                                                                |
| `storageAccount`      | `Microsoft.Storage/storageAccounts`       | Storage Account container to store the Event Hubs trigger checkpoint information and the failed messages. |
| `hostingPlan`         | `Microsoft.Web/serverfarms`               | Hosting plan that runs the function app.                                                                  |
| `functionApp`         | `Microsoft.Web/sites`                     | The function app that runs the EDOT Collector.                                                            |
| `applicationInsights` | `Microsoft.Insights/components`           | Application Insights instance to monitor the application.                                                 |

Note the following:
- The `eventHubNamespace` hosts the two event hubs responsible for receiving logs and metrics from Azure services.
- The `storageAccount` stores the checkpoint information for the Event Hub triggers, and it also hosts the failed logs and metrics in the `logs-error-container` and `metrics-error-container` containers.
- The `functionApp` is the core component responsible for running the OTel collector inside the Azure Function.


## Remove the resource group

If you no longer need the resources and want to remove them, use the following command:
```sh
az group delete --name $RESOURCE_GROUP
```

This removes all the resources in the resource group.
<warning>
  If you remove the resource group, data that's still unprocessed will be lost.
</warning>