﻿---
title: EDOT Cloud Forwarder for AWS
description: Set up the EDOT Cloud Forwarder for AWS to bring your AWS logs to Elastic Observability.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws
products:
  - EDOT Cloud Forwarder
  - EDOT Cloud Forwarder for AWS
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Unavailable
  - Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Generally available since 1.0, Preview in 0.2
---

# EDOT Cloud Forwarder for AWS
EDOT Cloud Forwarder (CF) for AWS provides the EDOT Collector as a Lambda function that collects and forwards logs to Elastic Cloud Managed OTLP Endpoint.
EDOT Cloud Forwarder for AWS supports the following log sources:

| AWS service                 | Telemetry description                                                                                                                                 | Availability                                                                                                                                                                                         |
|-----------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Virtual Private Cloud (VPC) | [VPC Flow Logs](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html) to capture information about IP traffic.                             | <applies-to>Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Generally available since 1.0, Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Preview in 0.2</applies-to> |
| Elastic Load Balancer (ELB) | [Access logs](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html) for your Application Load Balancer. | <applies-to>Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Generally available since 1.0, Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Preview in 0.2</applies-to> |
| AWS CloudTrail              | [CloudTrail Logs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-log-file-examples.html) to record account activity.           | <applies-to>Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Preview since 0.2</applies-to>                                                                                            |
| AWS WAF                     | [WAF Logs](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) to capture web request details for security analysis.                  | <applies-to>Elastic Distribution of OpenTelemetry Cloud Forwarder for AWS: Preview since 1.3</applies-to>                                                                                            |


## Prerequisites

To collect logs using EDOT Cloud Forwarder for AWS, you need the following:
<tab-set>
  <tab-item title="VPC Flow">
    To collect VPC Flow logs, you need:
    - A Virtual Private Cloud (VPC)
    - An S3 bucket for storing flow logs
    - A flow log configured with the S3 bucket as the destination
    - An Elastic Managed OTLP endpoint and an API key. Refer to [Endpoint and API key](#endpoint-and-api-key).
  </tab-item>

  <tab-item title="ELB Access">
    To collect Elastic Load Balancer (ELB) Access logs, you need:
    - An ELB of any type (ALB, NLB, CLB)
    - An S3 bucket to store the access logs
    - Access logging enabled, with the bucket as the destination
    - An Elastic Managed OTLP endpoint and an API key. Refer to [Endpoint and API key](#endpoint-and-api-key).
  </tab-item>

  <tab-item title="CloudTrail">
    To collect AWS CloudTrail logs, you need:
    - A trail that delivers account events as log files to an Amazon S3 bucket
    - An S3 bucket to store the trail logs
    - An Elastic Managed OTLP endpoint and an API key. Refer to [Endpoint and API key](#endpoint-and-api-key).
  </tab-item>

  <tab-item title="WAF">
    To collect AWS WAF logs, you need:
    - AWS WAF with logging enabled to an S3 bucket
    - An S3 bucket to store the WAF logs
    - An Elastic Managed OTLP endpoint and an API key. Refer to [Endpoint and API key](#endpoint-and-api-key).
  </tab-item>
</tab-set>


### Endpoint and API key

To retrieve your Elastic Cloud Managed OTLP Endpoint endpoint address and API key, follow these steps:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. In Elastic Cloud, create an Observability project or open an existing one.
    2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
    3. Copy the endpoint and authentication headers values.
    Alternatively, you can retrieve the endpoint from the **Manage project** page and create an API key manually from the **API keys** page.
  </applies-item>

  <applies-item title="ess: preview" applies-to="Elastic Cloud Hosted: Preview">
    You need an Elastic Cloud Hosted deployment version 9.2 or later.
    1. In Elastic Cloud, create an Elastic Cloud Hosted deployment or open an existing one.
    2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
    3. Copy the endpoint and authentication headers values.
  </applies-item>
</applies-switch>

<important>
  Trim the API key from `Authorization=ApiKey MYKEYVALUE...` to just `MYKEYVALUE...` before using it as the argument to the `ElasticAPIKey` parameter.
</important>


## Quick start

Deploy EDOT Cloud Forwarder for AWS with one click using the AWS CloudFormation console:
[![Launch Stack](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws/images/cloudformation-launch-stack.png)](https://console.aws.amazon.com/cloudformation/home?#/stacks/new?templateURL=https://edot-cloud-forwarder.s3.amazonaws.com/v1/latest/cloudformation/s3_logs-cloudformation.yaml)
After clicking the button:
1. Configure the required parameters:
   | Parameter                      | Description                                                                  |
   |--------------------------------|------------------------------------------------------------------------------|
   | `Stack name`                   | Name of the CloudFormation stack, for example `vpc-edot-cf`.                 |
   | `OTLPEndpoint`                 | The OTLP endpoint URL from Elastic Cloud Serverless or Elastic Cloud Hosted. |
   | `ElasticApiKey`                | API key for authentication with Elastic.                                     |
   | `SourceS3BucketARN`            | ARN of the S3 bucket where your logs are stored.                             |
   | `EdotCloudForwarderS3LogsType` | The log type: `vpcflow`, `elbaccess`, `cloudtrail`, or `waf`.                |
2. Select **Next** and check **Acknowledge IAM capabilities**.
3. Review your configuration and select **Submit** to deploy the stack.
4. Monitor the progress until the stack reaches the `CREATE_COMPLETE` state.

<tip>
  The CloudFormation stack deployment region must match the region of the S3 bucket where your logs are stored.
</tip>


## Deployment considerations

Before deploying EDOT Cloud Forwarder for AWS, consider the following:
- Deploy a separate CloudFormation stack for each log type, for example VPC Flow Logs or ELB Access Logs. Each CloudFormation stack can only process one log type and format at a time.
- Logs stored in S3 must be placed in separate buckets. Each log type should reside in its own dedicated bucket.


## Datastreams

Logs collected by EDOT Cloud Forwarder for AWS are stored in Elasticsearch datastreams in OpenTelemetry native format. The following table shows which datastreams are used for each log type:

| **AWS log type** | **Datastream dataset** | **Description**                        |
|------------------|------------------------|----------------------------------------|
| VPC Flow Logs    | `aws.vpcflow.otel`     | VPC Flow Log records                   |
| ELB Access Logs  | `aws.elbaccess.otel`   | ELB Access Log records (ALB, NLB, CLB) |
| WAF Logs         | `aws.waf.otel`         | AWS WAF web request log records        |

The logs are produced in OpenTelemetry native format. For detailed information about the field mappings and structure of each log type, refer to the following documentation:
- **VPC Flow Logs**: See [VPC Flow Log record fields](https://github.com/occamshub-dev/opentelemetry-collector-contrib/blob/main/extension/encoding/awslogsencodingextension/README.md#vpc-flow-log-record-fields) for the complete field mapping.
- **ELB Access Logs**: See [ELB Access Log fields](https://github.com/occamshub-dev/opentelemetry-collector-contrib/blob/main/extension/encoding/awslogsencodingextension/README.md#elb-access-log-fields) for the complete field mapping.
- **WAF Logs**: See [WAF Log fields](https://github.com/occamshub-dev/opentelemetry-collector-contrib/blob/main/extension/encoding/awslogsencodingextension/README.md#waf-log-fields) for the complete field mapping.


## Kibana integration setup

After EDOT Cloud Forwarder for AWS is successfully running and forwarding logs to Elastic Observability, install the Kibana integrations to visualize your data with out-of-the-box dashboards and visualizations.
To set up data visualization in Kibana:
1. Log into your Elastic Cloud deployment and open Kibana
2. Go to **Management** → **Integrations** in the Kibana navigation menu.
3. Search for the appropriate integration based on your log type and install it:
   | **AWS log type** | **Integration name**                         | **Description**                                              |
   |------------------|----------------------------------------------|--------------------------------------------------------------|
   | ELB Access Logs  | **AWS ELB OpenTelemetry Assets**             | Dashboards and visualizations for Elastic Load Balancer logs |
   | VPC Flow Logs    | **AWS VPC Flow Logs OpenTelemetry Assets**   | Dashboards and visualizations for VPC flow log data          |
   | CloudTrail Logs  | **AWS CloudTrail Logs OpenTelemetry Assets** | Dashboards and visualizations for CloudTrail log data        |
   | WAF Logs         | **AWS WAF Logs OpenTelemetry Assets**        | Dashboards and visualizations for WAF log data               |
4. Once installed, navigate to **Dashboard** to view the pre-built dashboards for your AWS log data.


## Limitations

EDOT Cloud Forwarder for AWS has the following limitations:

| Limitation                        | Description                                                                                                                                                                                            |
|-----------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **VPC/PrivateLink not supported** | EDOT Cloud Forwarder cannot be deployed inside a VPC or use AWS PrivateLink endpoints. The Lambda function requires public internet access to forward data to the OTLP endpoint.                       |
| **Managed OTLP Input only**       | EDOT Cloud Forwarder is tested exclusively with Elastic Cloud Managed OTLP Endpoint. Forwarding to a self-deployed EDOT Collector Gateway is not tested and forwarding to APM Server is not supported. |
| **Single log type per bucket**    | Each S3 bucket can only contain one log type. Mixed log formats in the same bucket are not supported yet.                                                                                              |


## Next steps

- [Configure the template](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws/configure): Learn about all configuration options, including optional settings and sizing recommendations.
- [Deployment methods](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws/deploy): Explore alternative deployment methods using AWS CLI or AWS Serverless Application Repository.
- [Troubleshooting](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws/troubleshooting): Diagnose and resolve issues with log forwarding.