﻿---
title: EDOT Cloud Forwarder
description: Introduction to the EDOT Cloud Forwarder, the Elastic Distribution of OpenTelemetry (EDOT) Collector for Cloud providers. Send your telemetry data to Elastic Stack from AWS, GCP, and Azure.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder
products:
  - EDOT Cloud Forwarder
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Preview
  - Elastic Cloud Hosted: Preview
---

# EDOT Cloud Forwarder
The Elastic Distribution of OpenTelemetry (EDOT) Cloud Forwarder provides the EDOT Collector as a function to collect and send your telemetry data to Elastic Observability from AWS, GCP, and Azure. EDOT Cloud Forwarder can collect telemetry data from object storage and cloud services.
EDOT Cloud Forwarder sends the data it collects directly to the [Managed OTLP endpoint](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-elastic-cloud-otel-endpoint) of Elastic Cloud Serverless.

## Supported cloud providers and services

EDOT Cloud Forwarder is available for the following cloud providers and services:

| Cloud provider | Cloud service           | Availability                                                                                                     |
|----------------|-------------------------|------------------------------------------------------------------------------------------------------------------|
| AWS            | S3, CloudWatch          | [EDOT Cloud Forwarder for AWS](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws)     |
| Azure          | Blob Storage, Event Hub | [EDOT Cloud Forwarder for Azure](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/azure) |
| GCP            | GCS, Operations         | [EDOT Cloud Forwarder for GCP](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/gcp)     |


## Get started

To get started with EDOT Cloud Forwarder, select the setup guide for your cloud provider:
- [AWS](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws)
- [Azure](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/azure)
- [GCP](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/gcp)