﻿---
title: EDOT compatibility and support for OTel SDKs
description: Compatibility and support information for EDOT SDK versions with EDOT Collector versions.
url: https://www.elastic.co/docs/reference/opentelemetry/compatibility/sdks
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# EDOT compatibility and support for OTel SDKs
The following table provides an overview of compatibility and support of EDOT SDKs with EDOT Collector versions:

| EDOT Collector version | **< 8.16**                                                                                      | **8.16 to 8.19**                                                                                | **9.x**                                                                                      |
|------------------------|-------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------|
| **Compatibility**      | [Incompatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| **Level of support**   | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  |

This applies to all EDOT SDKs:
- EDOT .NET
- EDOT Java
- EDOT Node.js
- EDOT PHP
- EDOT Python
- EDOT Android
- EDOT iOS

Refer to the [EDOT Collector compatibility table](https://www.elastic.co/docs/reference/opentelemetry/compatibility/collectors) for compatibility with Elastic Stack versions.
For the best experience, export data from EDOT SDKs using the [EDOT Collector](https://www.elastic.co/docs/reference/edot-collector).
<note>
  Ingesting data from EDOT SDKs through EDOT Collector into Elastic Stack versions 8.18 or higher is supported ([Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)).
</note>


## Support matrix for EDOT SDK ingestion


| Ingestion path                          | Supported     | Notes                                                                                   |
|-----------------------------------------|---------------|-----------------------------------------------------------------------------------------|
| **EDOT Collector (Gateway)**            | Yes           | Fully tested and recommended.                                                           |
| **Elastic Cloud Managed OTLP Endpoint** | Yes           | Fully supported for Elastic Cloud Serverless and Elastic Cloud Hosted.                  |
| **APM Server OTel intake**              | Not supported | Telemetry might ingest but mapping, enrichment, and troubleshooting are not guaranteed. |


## Supported technologies per EDOT SDK

For compatibility of language-specific technologies check out the following pages for corresponding EDOT SDKs:
- [Supported Technologies - .NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/supported-technologies)
- [Supported Technologies - Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/supported-technologies)
- [Supported Technologies - Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/supported-technologies)
- [Supported Technologies - PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/supported-technologies)
- [Supported Technologies - Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/supported-technologies)
- [Supported Technologies - iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios/supported-technologies)


## Other SDK distributions

OTel SDK distributions other than the ones listed above are technically compatible ([Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)) with Elastic but are not officially supported by Elastic ([Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)).