﻿---
title: Elastic features available with EDOT
description: Overview of Elastic features available with EDOT.
url: https://www.elastic.co/docs/reference/opentelemetry/compatibility/features
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic features available with EDOT
The following table shows Elastic features and their level of support and compatibility with Elastic Distributions of OpenTelemetry (EDOT). Refer to the [SDKs Overview](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) for SDK-specific features.

| Feature                                                                                                                           | Compatibility                                                                                   | Support level                                                                                   |
|-----------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|
| **APM**                                                                                                                           | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| [Service Maps](https://www.elastic.co/docs/solutions/observability/apm/service-map)                                               | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| [Distributed Tracing](https://www.elastic.co/docs/solutions/observability/apm/traces-ui)                                          | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| [Head-based Sampling (HBS)](https://www.elastic.co/docs/solutions/observability/apm/transaction-sampling#apm-head-based-sampling) | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| [Tail-based Sampling (TBS)](https://www.elastic.co/docs/solutions/observability/apm/transaction-sampling#apm-tail-based-sampling) | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)^4^ | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| [Self-managed, OTel Collector-based TBS](https://opentelemetry.io/blog/2022/tail-sampling/)                                       | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)^4^ | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| TBS managed / hosted in Elastic Cloud                                                                                             | [Incompatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| Runtime metrics                                                                                                                   | [See language-specific overview](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) | -                                                                                               |
| **Infrastructure Monitoring**                                                                                                     | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Host view^1^                                                                                                                      | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Kubernetes dashboard                                                                                                              | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| **Logs Collection**                                                                                                               | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| OTel-native, Collector-based logs parsing & processing                                                                            | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| OTel-native, Collector-based data routing                                                                                         | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Managed, centralized processing^2^                                                                                                | [Incompatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| **Metrics Collection**^3^                                                                                                         | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Automatic metrics mapping                                                                                                         | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Usage of [Time Series Data Streams](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| **Central Management**                                                                                                            | [Incompatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| Central management of OTel collectors                                                                                             | [Incompatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| Central management of OTel SDKs                                                                                                   | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |

^1^ Refer to [limitations on host metrics](/docs/reference/opentelemetry/compatibility/limitations#infrastructure-and-host-metrics)
^2^ Refer to [limitations on Ingest Pipelines](/docs/reference/opentelemetry/compatibility/limitations#centralized-parsing-and-processing-of-data)
^3^ Refer to [limitations on metrics ingestion](/docs/reference/opentelemetry/compatibility/limitations#metrics-data-ingestion)
^4^ While ingesting traces that have been sampled using TBS is technically possible, there are important limitations to consider. Refer to [Tail-based sampling (TBS) limitations](/docs/reference/opentelemetry/compatibility/limitations#tail-based-sampling-tbs) for more information.