﻿---
title: EDOT compatibility and support for OTel Collectors
description: Compatibility and support information for EDOT Collector versions with Elastic Stack versions and operating systems.
url: https://www.elastic.co/docs/reference/opentelemetry/compatibility/collectors
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# EDOT compatibility and support for OTel Collectors
The following table provides an overview of compatibility and support of Elastic Distribution of OpenTelemetry Collector versions with Elastic Stack (ELK) versions.

## EDOT Collector 9.x


| ELK stack version    | **ELK < 8.16**                                                                                  | **ELK 8.16 - 8.17**                                                                             | **ELK 8.18 - 8.19**                                                                          | **ELK 9.0 and later**                                                                        |
|----------------------|-------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------|
| **Compatibility**    | [Incompatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)    | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) | [Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| **Level of support** | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)  |

<note>
  If you're on Elastic Stack 8.18 or 8.19 and require Elastic support, use EDOT Collector version 9.x, as this combination is officially [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature).
</note>


### Configuration compatibility

If you upgrade to EDOT Collector 9.x while running Elastic Stack 8.18 or 8.19, continue using the configuration recommended for your Stack version, not the EDOT Collector 9.x default configuration. This ensures full compatibility with Kibana Observability applications.

## Operating systems

The following table provides an overview of compatibility and support of EDOT Collector versions with different operating systems.

### EDOT Collector 9.x

These operating systems and distributions are [compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) with EDOT Collector 9.x:

| OS Type | Architecture | Distribution or version                                  | Level of support                                                                                |
|---------|--------------|----------------------------------------------------------|-------------------------------------------------------------------------------------------------|
| Linux   | amd64        | Ubuntu 24.04, 22.04, 20.04                               | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Linux   | arm64        | Ubuntu 24.04, 22.04, 20.04                               | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| Linux   | amd64        | RHEL 8                                                   | [Supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)     |
| macOS   | amd64        | macOS 10.x and higher                                    | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| macOS   | arm64        | macOS 10.x and higher                                    | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |
| Windows | amd64        | Server 2022, 2022 Core, 2019, 2019 Core, 2016, 2016 Core | [Not supported](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) |

The following Kubernetes distributions are [compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature) with EDOT Collector 9.x:

| Kubernetes | Architecture | Version                                                 |
|------------|--------------|---------------------------------------------------------|
| Kubernetes | amd64, arm64 | 1.33.0, 1.32.0, 1.31.0, 1.30.2, 1.29.4, 1.28.9, 1.27.16 |

The EDOT Collector is compatible with GKE, EKS, and AKS. Refer to [Limitations on managed Kubernetes environments](/docs/reference/opentelemetry/compatibility/limitations#limitations-on-managed-kubernetes-environments) for more information.

### Platform-specific recommendations

For certain platforms, use platform-native OpenTelemetry distributions [at the edge](/docs/reference/opentelemetry/architecture#understanding-edge-deployment), as they provide the best native experience.
<important>
  Elastic does not provide support for distributions other than the Elastic Distribution of OpenTelemetry.
</important>


#### Red Hat OpenShift

Use the [Red Hat build of OpenTelemetry](https://docs.redhat.com/en/documentation/openshift_container_platform/4.20/html/red_hat_build_of_opentelemetry/index) [at the edge](/docs/reference/opentelemetry/architecture#understanding-edge-deployment) to collect and send telemetry data. For support of OpenTelemetry components in OpenShift, contact Red Hat.

#### AWS Lambda

Use the [AWS Distro for OpenTelemetry (ADOT)](https://aws-otel.github.io/docs/getting-started/lambda) [at the edge](/docs/reference/opentelemetry/architecture#understanding-edge-deployment) to collect and send telemetry data from AWS Lambda services. For support of ADOT components, contact AWS.
<tip>
  For AWS Lambda workloads that generate telemetry outside the function runtime, such as CloudWatch logs, use the [EDOT Cloud Forwarder](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws) instead.
</tip>


## EDOT Collector components

For information on the compatibility of each Collector component, refer to the [full list of Core and Extended components](https://www.elastic.co/docs/reference/edot-collector/components).

## Other Collector distributions

Non-EDOT distributions of the OTel Collector, such as custom Collector builds, contrib Collector distributions, and so on aren't officially supported through Elastic but are technically compatible ([Compatible](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature)) if they contain the [required OTel Collector components](https://www.elastic.co/docs/reference/edot-collector/custom-collector) and are configured like the EDOT Collector.
You can retrieve required components and configuration options from the [example configuration files](https://github.com/elastic/elastic-agent/tree/v<COLLECTOR_VERSION>/internal/pkg/otel/samples/linux) for the EDOT Collector.
For a comparison between EDOT and the contrib OTel Collector, refer to [EDOT compared to contrib Collector](https://www.elastic.co/docs/reference/opentelemetry/compatibility/edot-vs-upstream).