﻿---
title: Central configuration for EDOT SDKs
description: Reference documentation for the central configuration of EDOT SDKs.
url: https://www.elastic.co/docs/reference/opentelemetry/central-configuration
products:
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Preview since 9.1
---

# Central configuration for EDOT SDKs
Manage Elastic Distribution of OpenTelemetry (EDOT) SDKs through the APM Agent Central Configuration feature in the Applications UI. Changes are automatically propagated to the deployed EDOT SDKs. Refer to [APM Agent Central Configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration) for more information.
This feature implements the Open Agent Management Protocol (OpAMP). Refer to [Open Agent Management Protocol
](https://opentelemetry.io/docs/specs/opamp/) for more information.

## Architecture

The central configuration architecture for the Elastic Distribution of OpenTelemetry (EDOT) provides a robust and scalable mechanism for managing fleets of EDOT SDKs remotely. The data flow, illustrated in this diagram, ensures that configuration changes are efficiently propagated from a central management point to each individual agent.
![Diagram of Central config architecture](https://www.elastic.co/docs/reference/opentelemetry/images/central-config-edot.png)

The process starts within Kibana, where administrators create and manage settings for the EDOT SDKs. Once defined, settings are written to and persisted in Elasticsearch, which acts as the single source of truth. The EDOT Collector, when configured in Gateway mode, includes the Elastic APM Config Extension, which reads the SDK settings from Elasticsearch, making them available for distribution.
Each EDOT SDK contains an embedded OpAMP Client. Following the Open Agent Management Protocol (OpAMP), these clients periodically poll the OpAMP server, bundled with the Collector's APM Config Extension, over HTTP. This polling action allows the SDKs to retrieve the latest configuration updates, enabling dynamic and centralized control over their behavior without requiring manual intervention or redeployment.

## Prerequisites

To use APM Agent Central Configuration for EDOT SDKs, you need:
- An Elastic self-managed or Elastic Cloud deployment, version 9.1 or higher.
- A standalone [EDOT Collector](https://www.elastic.co/docs/reference/edot-collector), in either Agent or Collector mode.
- EDOT SDKs instrumenting your application.

The following versions of EDOT and Elastic Stack support central configuration:

| Component      | Minimum version     |
|----------------|---------------------|
| Kibana         | 9.1 or higher       |
| EDOT Collector | 8.19, 9.1 or higher |
| EDOT Android   | 1.2.0 or higher     |
| EDOT iOS       | 1.4.0 or higher     |
| EDOT Java      | 1.5.0 or higher     |
| EDOT Node.js   | 1.2.0 or higher     |
| EDOT PHP       | 1.1.1 or higher     |
| EDOT Python    | 1.4.0 or higher     |

<note>
  Serverless deployments are not currently supported.
</note>


## Activate central configuration

To activate APM Agent Central Configuration for EDOT SDKs, follow these steps.
<stepper>
  <step title="Retrieve your credentials">
    You need a valid Elasticsearch API key to authenticate to the Elasticsearch endpoint.
  </step>

  <step title="Create an Elasticsearch API key for central configuration">
    Create an API key with the `config_agent:read` privilege. This API key will be used by EDOT SDKs and validated by the Collector.Use the following API request to generate the key:
    ```json
    POST /_security/api_key
    {
      "name": "apmconfig-opamp-test-sdk",
      "metadata": {
        "application": "apm"
      },
      "role_descriptors": {
        "apm": {
          "cluster": [],
          "indices": [],
          "applications": [
            {
              "application": "apm",
              "privileges": [
                "config_agent:read"
              ],
              "resources": [
                "*"
              ]
            }
          ],
          "run_as": [],
          "metadata": {}
        }
      }
    }
    ```

    <note>
      The EDOT Collector doesn't store or embed the Elasticsearch API key.Each EDOT SDK must send its own API key in the `Authorization` header (for example: `Authorization: ApiKey <Base64(id:key)>`).The `apikeyauth` extension only validates this API key against Elasticsearch, ensuring it includes the `config_agent:read` privilege with `resources: ["*"]`.
    </note>
  </step>

  <dropdown title="Example JSON payload">
    ```json
    POST /_security/api_key
    {
      "name": "apmconfig-opamp-test-sdk",
      "metadata": {
        "application": "apm"
      },
      "role_descriptors": {
        "apm": {
          "cluster": [],
          "indices": [],
          "applications": [
            {
              "application": "apm",
              "privileges": [
                "config_agent:read"
              ],
              "resources": [
                "*"
              ]
            }
          ],
          "run_as": [],
          "metadata": {}
        }
      }
    }
    ```
  </dropdown>

  <step title="Edit the EDOT Collector configuration">
    Edit the [EDOT Collector configuration](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone#central-configuration) to activate the central configuration feature:
    ```yaml
    extensions:
      bearertokenauth:
        scheme: "APIKey"
        token: "<ENCODED_ELASTICSEARCH_APIKEY>"

      apmconfig:
        opamp:
          protocols:
            http:
              # Default is localhost:4320
              # To specify a custom endpoint, uncomment the following line 
              # and set the endpoint to the custom endpoint
              # endpoint: "<CUSTOM_OPAMP_ENDPOINT>"
        source:
          elasticsearch:
            endpoint: "<ELASTICSEARCH_ENDPOINT>"
            auth:
              authenticator: bearertokenauth

    service:
      extensions: [bearertokenauth, apmconfig]
    ```

    <note>
      For comprehensive authentication configuration options, refer to [Authentication methods](https://www.elastic.co/docs/reference/edot-collector/config/authentication-methods).
    </note>
    Restart the Elastic Agent to also restart the Collector and apply the changes.Refer to [Secure connection](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone#secure-connection) if you need to secure the connection between the EDOT Collector and Elastic using TLS or mutual TLS.
  </step>

  <step title="Set the environment variables for the SDKs">
    Activate the central configuration feature in the SDKs by setting the `ELASTIC_OTEL_OPAMP_ENDPOINT` environment variable to the URL endpoint of the `apmconfig` extension that you configured in the previous step. For example:
    ```sh
    export ELASTIC_OTEL_OPAMP_ENDPOINT="http://localhost:4320/v1/opamp"
    ```
    If the OpAMP server in the Collector requires authentication set the `ELASTIC_OTEL_OPAMP_HEADERS` environment variable.
    ```sh
    export ELASTIC_OTEL_OPAMP_HEADERS="Authorization=ApiKey an_api_key"
    ```
    Restart the instrumented application to apply the changes.
    <important>
      Support for the `ELASTIC_OTEL_OPAMP_HEADERS` environment variable depends on each SDK. Refer to the configuration reference of each EDOT SDK for more information.
    </important>
  </step>

  <step title="Check that the EDOT SDK shows up">
    Wait some time for the EDOT SDK to appear in Kibana under Agent Configuration.
    1. Go to **Kibana** → **Observability** → **Applications** and select a service.
    2. Select **Settings** and go to **Agent Configuration**.
    Your application must produce and send telemetry data for the EDOT SDK to appear in Agent Configuration. This is because central configuration requires an application name as the key, which can't be defined until the application name is associated with the EDOT SDK agent after receiveing telemetry.
    <note>
      Central configuration uses the `service.name` and `deployment.environment.name` OpenTelemetry resource attributes to target specific instances with a configuration. If no environment is specified, the central configuration feature will match `All` as the environment.
    </note>
  </step>
</stepper>


## Supported settings

For a list of settings that you can configure through APM Agent Central Configuration, refer to the configuration reference of each EDOT SDK:
- [EDOT Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/configuration#central-configuration)
- [EDOT iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios/configuration#central-configuration-edot)
- [EDOT Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/configuration#central-configuration)
- [EDOT Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration#central-configuration)
- [EDOT PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/configuration#central-configuration)
- [EDOT Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/configuration#central-configuration)


## Advanced configuration

<applies-to>
  - Elastic Stack: Preview since 9.2
</applies-to>

The **Advanced Configuration** feature allows you to define custom configuration options as key-value pairs. Settings are passed directly to your EDOT SDK.
<warning>
  Use this feature with caution. An incorrect or incompatible setting might affect the behavior of the EDOT SDK.
</warning>


## Deactivate central configuration

To deactivate central configuration, remove the `ELASTIC_OTEL_OPAMP_ENDPOINT` environment variable.
Restart the instrumented application to apply the changes.