﻿---
title: Hosts and VMs environments
description: Recommended EDOT architecture for host or virtual machine environments.
url: https://www.elastic.co/docs/reference/opentelemetry/architecture/hosts_vms
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Hosts and VMs environments
On host or virtual machine environments, deploy local, per-host OpenTelemetry Collector instances at these [edge](/docs/reference/opentelemetry/architecture#understanding-edge-deployment) host or VMs where your applications are running.
Collectors deployed on these edge environments have two main purposes:
1. The collection of local logs and infrastructure metrics. Refer to [this sample config file](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone) for recommended Collector receiver configurations for hostmetrics and logs.
2. Enriching application telemetry from OTel SDKs with the corresponding hosts resource attributes.

<note>
  Elastic Observability is technically compatible with edge setups that are fully based on contrib OTel components as long as the ingestion path follows the recommendations outlined in the following sections.
</note>


## Deployment scenarios

The following sections outline the recommended architectures for different Elastic deployment scenarios.
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    Elastic Cloud Serverless provides a [Managed OTLP Endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp) for ingestion of OpenTelemetry data.![VM-Serverless](https://www.elastic.co/docs/reference/opentelemetry/images/host-serverless.png)Users can send data direct from the Collectors or SDKs deployed on the edge environment through OTLP without any additional requirements for managing an ingestion layer.
  </applies-item>

  <applies-item title="ess: preview" applies-to="Elastic Cloud Hosted: Preview">
    <note>
      You need an Elastic Cloud Hosted deployment version 9.2 or later.
    </note>
    Elastic Cloud Hosted provides a [Managed OTLP Endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp) for ingestion of OpenTelemetry data. Users can send data direct from the Collectors or SDKs deployed on the edge environment through OTLP without any additional requirements for managing an ingestion layer.![VM-ech](https://www.elastic.co/docs/reference/opentelemetry/images/host-ech.png)
  </applies-item>

  <applies-item title="{ eck:, ece:, self: }" applies-to="Elastic Cloud on Kubernetes: Generally available, Elastic Cloud Enterprise: Generally available, Self-managed Elastic deployments: Generally available">
    In a self-managed Elastic deployment, we recommend running an EDOT Collector in gateway mode as a unified ingestion layer for OTLP telemetry from OpenTelemetry collectors or SDKs running at the edge. This gateway can receive all signals (logs, metrics and traces), apply processing as needed, and cover the same use cases that previously required components like APM Server or Logstash.Depending on your scalability and durability needs, this can be a single collector that scales horizontally, or a chain of collectors where each tier handles a specific concern. For high availability and stronger durability guarantees, you can insert Kafka between tiers so that ingestion is buffered and resilient to downstream outages.![VM-self-managed](https://www.elastic.co/docs/reference/opentelemetry/images/host-self-managed.png)
    <note>
      Compared to [Elastic's classic ingestion paths](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry) for OTel data, with the EDOT Collector in gateway mode there is no need for APM Server anymore.Refer to [data streams compared to classic APM](https://www.elastic.co/docs/reference/opentelemetry/compatibility/data-streams) for a detailed comparison of data streams, mappings, and storage models.
    </note>
  </applies-item>
</applies-switch>