﻿---
title: Elastic Distributions of OpenTelemetry (EDOT)
description: Reference documentation for the Elastic Distributions of OpenTelemetry (EDOT).
url: https://www.elastic.co/docs/reference/opentelemetry
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distributions of OpenTelemetry (EDOT)
Elastic Distributions of OpenTelemetry (EDOT) is an open-source ecosystem of [OpenTelemetry distributions](https://opentelemetry.io/docs/concepts/distributions/) tailored to Elastic. They include a customized OpenTelemetry Collector and several OpenTelemetry Language SDKs.
![EDOT-Distributions](https://www.elastic.co/docs/reference/opentelemetry/images/EDOT-SDKs-Collector.png)
Each EDOT distribution is assembled with selected OpenTelemetry components and tested to ensure production readiness. This provides a reliable and optimized OpenTelemetry experience, enabling seamless adoption with confidence and expert support.
[OpenTelemetry](https://opentelemetry.io/docs/) is a vendor-neutral observability framework for collecting, processing, and exporting telemetry data. If you are new to OpenTelemetry, refer to OpenTelemetry [concepts](https://opentelemetry.io/docs/concepts/) and [components](https://opentelemetry.io/docs/concepts/components/). Refer to [EDOT compared to contrib Collector](https://www.elastic.co/docs/reference/opentelemetry/compatibility/edot-vs-upstream) for more information on how EDOT differs from the contrib OpenTelemetry Collector.

## Available OpenTelemetry distributions

The following Elastic OpenTelemetry distributions are available:

| Distribution                                                                                                     | Latest version | Current status    |
|------------------------------------------------------------------------------------------------------------------|----------------|-------------------|
| [EDOT Collector](https://www.elastic.co/docs/reference/edot-collector)                                           | 9.3.0          | GA                |
| [EDOT .NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet)                                | 1.3.0          | GA                |
| [EDOT Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java)                                  | 1.9.0          | GA                |
| [EDOT Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node)                               | 1.8.0          | GA                |
| [EDOT PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php)                                    | 1.3.1          | GA                |
| [EDOT Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python)                              | 1.11.0         | GA                |
| [EDOT Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)                            | 1.5.0          | GA                |
| [EDOT iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)                                    | 1.4.0          | GA                |
| [EDOT Cloud Forwarder for AWS](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/aws)     | 1.3.0          | GA                |
| [EDOT Cloud Forwarder for Azure](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/azure) | 1.3.0          | Technical Preview |
| [EDOT Cloud Forwarder for GCP](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/gcp)     | 0.1.1          | Technical Preview |

Each EDOT distribution undergoes production-grade testing before being declared Generally Available (GA). Elastic provides full support for GA releases in accordance with our [support matrix](https://www.elastic.co/support/matrix) and SLAs.
Technical Preview distributions receive best-effort support and are not covered under standard SLAs.

## Get started

Pick the right [Quickstart guide](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart) for your environment or select an observability use case:
- [Monitoring on Kubernetes](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes)
- [LLM Observability](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/llms)


## EDOT Demo environment

A demo environment that showcases EDOT capabilities is available in the [opentelemetry-demo repository](https://github.com/elastic/opentelemetry-demo).
The EDOT demo includes:
- Sample applications instrumented with OpenTelemetry SDKs.
- EDOT Collector configured for various scenarios. For example, Kubernetes and hosts.
- Integration with an Elastic Stack deployment, such as Elasticsearch and Kibana.

Follow the instructions in the demo repository to set up and run the demo.

## Report an issue or provide feedback

To report an issue or provide feedback on EDOT, [submit a GitHub issue](https://github.com/elastic/opentelemetry/issues/new/choose).