﻿---
title: Kubernetes pod metrics
description: To analyze Kubernetes pod metrics, you can select view filters based on the following predefined metrics, or you can add custom metrics. For information...
url: https://www.elastic.co/docs/reference/observability/observability-kubernetes-pod-metrics
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Kubernetes pod metrics
To analyze Kubernetes pod metrics, you can select view filters based on the following predefined metrics, or you can add [custom metrics](/docs/solutions/observability/infra-and-hosts/view-infrastructure-metrics-by-resource-type#custom-metrics).
<note applies-to="Elastic Stack: Generally available since 9.3">
  For Kubernetes pod metrics, the [Infrastructure UI](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) and [inventory rules](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-inventory-rule) only support metric data collected by the [Kubernetes integration](https://www.elastic.co/docs/reference/integrations/kubernetes).
</note>


## Entity definition

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>


|                   |                              |                                   |
|-------------------|------------------------------|-----------------------------------|
| **Filter**        | `event.module: "kubernetes"` | Used to filter relevant data.     |
| **Identifier**    | `kubernetes.pod.uid`         | Used to identify each entity.     |
| **Display value** | `kubernetes.pod.name`        | Used as a display friendly value. |


## Metrics


|                      |                                                                                           |
|----------------------|-------------------------------------------------------------------------------------------|
| **CPU Usage**        | Average of `kubernetes.pod.cpu.usage.node.pct`.                                           |
| **Memory Usage**     | Average of `kubernetes.pod.memory.usage.node.pct`.                                        |
| **Inbound Traffic**  | Derivative of the maximum of `kubernetes.pod.network.rx.bytes` scaled to a 1 second rate. |
| **Outbound Traffic** | Derivative of the maximum of `kubernetes.pod.network.tx.bytes` scaled to a 1 second rate. |

For information about the fields used by the Infrastructure UI to display Kubernetes pod metrics, see the [Infrastructure app fields](https://www.elastic.co/docs/reference/observability/fields-and-object-schemas).