﻿---
title: Container metrics
description: Learn about key container metrics displayed in the Infrastructure UI: Docker, Kubernetes. These are the key metrics displayed for Docker containers. These...
url: https://www.elastic.co/docs/reference/observability/observability-container-metrics
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Container metrics
Learn about key container metrics displayed in the Infrastructure UI:
- [Docker](#key-metrics-docker)
- [Kubernetes](#key-metrics-kubernetes)


## Docker container metrics

These are the key metrics displayed for Docker containers.
<note applies-to="Elastic Stack: Generally available since 9.3">
  For Docker container metrics, the [Infrastructure UI](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) and [inventory rules](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-inventory-rule) only support metric data collected by the [Docker integration](https://www.elastic.co/docs/reference/integrations/docker).
</note>


### Entity definition

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>


|                   |                           |                                   |
|-------------------|---------------------------|-----------------------------------|
| **Filter**        | `event.module : "docker"` | Used to filter relevant data.     |
| **Identifier**    | `container.id`            | Used to identify each entity.     |
| **Display value** | `container.name`          | Used as a display friendly value. |


### CPU usage metrics


| Metric            | Description                                                                          |
|-------------------|--------------------------------------------------------------------------------------|
| **CPU Usage (%)** | Average CPU for the container.**Field Calculation:** `average(docker.cpu.total.pct)` |


### Memory metrics


| Metric               | Description                                                                                      |
|----------------------|--------------------------------------------------------------------------------------------------|
| **Memory Usage (%)** | Average memory usage for the container.**Field Calculation:** `average(docker.memory.usage.pct)` |


### Network metrics


| Metric                    | Description                                                                                                                                                                                                                    |
|---------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Inbound Traffic (RX)**  | Derivative of the maximum of `docker.network.in.bytes` scaled to a 1 second rate.**Field Calculation:** `average(docker.network.inbound.bytes) * 8 / (max(metricset.period, kql='docker.network.inbound.bytes: *') / 1000)`    |
| **Outbound Traffic (TX)** | Derivative of the maximum of `docker.network.out.bytes` scaled to a 1 second rate.**Field Calculation:** `average(docker.network.outbound.bytes) * 8 / (max(metricset.period, kql='docker.network.outbound.bytes: *') / 1000)` |


### Disk metrics


| Metric              | Description                                                                                                                                                         |
|---------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Disk Read IOPS**  | Average count of read operations from the device per second.**Field Calculation:**  `counter_rate(max(docker.diskio.read.ops), kql='docker.diskio.read.ops: *')`    |
| **Disk Write IOPS** | Average count of write operations from the device per second.**Field Calculation:**  `counter_rate(max(docker.diskio.write.ops), kql='docker.diskio.write.ops: *')` |


## Kubernetes container metrics

These are the key metrics displayed for Kubernetes (containerd) containers.
<note applies-to="Elastic Stack: Generally available since 9.3">
  For Kubernetes container metrics, the [Infrastructure UI](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) and [inventory rules](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-inventory-rule) only support metric data collected by the [Kubernetes integration](https://www.elastic.co/docs/reference/integrations/kubernetes).
</note>


### Entity definition

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>


|                   |                               |                                   |
|-------------------|-------------------------------|-----------------------------------|
| **Filter**        | `event.module : "kubernetes"` | Used to filter relevant data.     |
| **Identifier**    | `container.id`                | Used to identify each entity.     |
| **Display value** | `container.name`              | Used as a display friendly value. |


### CPU usage metrics


| Metric            | Description                                                                                              |
|-------------------|----------------------------------------------------------------------------------------------------------|
| **CPU Usage (%)** | Average CPU for the container.**Field Calculation:** `average(kubernetes.container.cpu.usage.limit.pct)` |


### Memory metrics


| Metric               | Description                                                                                                          |
|----------------------|----------------------------------------------------------------------------------------------------------------------|
| **Memory Usage (%)** | Average memory usage for the container.**Field Calculation:** `average(kubernetes.container.memory.usage.limit.pct)` |