﻿---
title: Fields and object schemas for Observability
description: This section lists Elastic Common Schema (ECS) fields the Infrastructure apps use to display data. ECS is an open source specification that defines a...
url: https://www.elastic.co/docs/reference/observability/fields-and-object-schemas
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Fields and object schemas for Observability
This section lists Elastic Common Schema (ECS) fields the Infrastructure apps use to display data.
ECS is an open source specification that defines a standard set of fields to use when storing event data in Elasticsearch, such as logs and metrics.
Beat modules (for example, [Filebeat modules](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-modules)) are ECS-compliant, so manual field mapping is not required, and all data is populated automatically in the Infrastructure app. If you cannot use Beats, map your data to [ECS fields](https://www.elastic.co/docs/reference/ecs/ecs-converting)). You can also try using the experimental [ECS Mapper](https://github.com/elastic/ecs-mapper) tool.
This reference covers Infrastructure app fields.

## Infrastructure app fields

This section lists the required fields the Infrastructure app uses to display data. Some of the fields listed are not [ECS fields](https://www.elastic.co/docs/reference/ecs/#_what_is_ecs).

### Additional field details

The `event.dataset` field is required to display data properly in some views. This field is a combination of `metricset.module`, which is the Metricbeat module name, and `metricset.name`, which is the metricset name.
To determine each metric’s optimal time interval, all charts use `metricset.period`. If `metricset.period` is not available, then it falls back to 1 minute intervals.

### Base fields

The `base` field set contains all fields which are on the top level. These fields are common across all types of events.
<definitions>
  <definition term="@timestamp">
    Date/time when the event originated.
    This is the date/time extracted from the event, typically representing when the source generated the event. If the event source has no original timestamp, this value is typically populated by the first time the pipeline received the event. Required field for all events.
    type: date
    required: True
    ECS field: True
    example: `May 27, 2020 @ 15:22:27.982`
  </definition>
  <definition term="message">
    For log events the message field contains the log message, optimized for viewing in a log viewer.
    For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event.
    If multiple messages exist, they can be combined into one message.
    type: text
    required: True
    ECS field: True
    example: `Hello World`
  </definition>
</definitions>


### Hosts fields

These fields must be mapped to display host data in the Infrastructure app.
<definitions>
  <definition term="host.name">
    Name of the host.
    It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.
    type: keyword
    required: True
    ECS field: True
    example: `MacBook-Elastic.local`
  </definition>
  <definition term="host.ip">
    IP of the host that records the event.
    type: `ip`
    required: True
    ECS field: True
  </definition>
</definitions>


### Docker container fields

These fields must be mapped to display Docker container data in the Infrastructure app.
<definitions>
  <definition term="container.id">
    Unique container id.
    type: keyword
    required: True
    ECS field: True
    example: `data`
  </definition>
  <definition term="container.name">
    Container name.
    type: keyword
    required: True
    ECS field: True
  </definition>
  <definition term="container.ip_address">
    IP of the container.
    type: `ip`
    required: True
    ECS field: False
  </definition>
</definitions>


### Kubernetes pod fields

These fields must be mapped to display Kubernetes pod data in the Infrastructure app.
<definitions>
  <definition term="kubernetes.pod.uid">
    Kubernetes Pod UID.
    type: keyword
    required: True
    ECS field: False
    example: `8454328b-673d-11ea-7d80-21010a840123`
  </definition>
  <definition term="kubernetes.pod.name">
    Kubernetes pod name.
    type: keyword
    required: True
    ECS field: False
    example: `nginx-demo`
  </definition>
  <definition term="kubernetes.pod.ip">
    IP of the Kubernetes pod.
    type: keyword
    required: True
    ECS field: False
  </definition>
</definitions>


### AWS EC2 instance fields

These fields must be mapped to display EC2 instance data in the Infrastructure app.
<definitions>
  <definition term="cloud.instance.id">
    Instance ID of the host machine.
    type: keyword
    required: True
    ECS field: True
    example: `i-1234567890abcdef0`
  </definition>
  <definition term="cloud.instance.name">
    Instance name of the host machine.
    type: keyword
    required: True
    ECS field: True
  </definition>
  <definition term="aws.ec2.instance.public.ip">
    Instance public IP of the host machine.
    type: keyword
    required: True
    ECS field: False
  </definition>
</definitions>


### AWS S3 bucket fields

These fields must be mapped to display S3 bucket data in the Infrastructure app.
<definitions>
  <definition term="aws.s3.bucket.name">
    The name or ID of the AWS S3 bucket.
    type: keyword
    required: True
    ECS field: False
  </definition>
</definitions>


### AWS SQS queue fields

These fields must be mapped to display SQS queue data in the Infrastructure app.
<definitions>
  <definition term="aws.sqs.queue.name">
    The name or ID of the AWS SQS queue.
    type: keyword
    required: True
    ECS field: False
  </definition>
</definitions>


### AWS RDS database fields

These fields must be mapped to display RDS database data in the Infrastructure app.
<definitions>
  <definition term="aws.rds.db_instance.arn">
    Amazon Resource Name (ARN) for each RDS.
    type: keyword
    required: True
    ECS field: False
  </definition>
  <definition term="aws.rds.db_instance.identifier">
    Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
    type: keyword
    required: True
    ECS field: False
  </definition>
</definitions>


### Additional grouping fields

Depending on which entity you select in the **Infrastructure inventory** view, these additional fields can be mapped to group entities by.
<definitions>
  <definition term="cloud.availability_zone">
    Availability zone in which this host is running.
    type: keyword
    required: True
    ECS field: True
    example: `us-east-1c`
  </definition>
  <definition term="cloud.machine.type">
    Machine type of the host machine.
    type: keyword
    required: True
    ECS field: True
    example: `t2.medium`
  </definition>
  <definition term="cloud.region">
    Region in which this host is running.
    type: keyword
    required: True
    ECS field: True
    example: `us-east-1`
  </definition>
  <definition term="cloud.instance.id">
    Instance ID of the host machine.
    type: keyword
    required: True
    ECS field: True
    example: `i-1234567890abcdef0`
  </definition>
  <definition term="cloud.provider">
    Name of the cloud provider. Example values are `aws`, `azure`, `gcp`, or `digitalocean`.
    type: keyword
    required: True
    ECS field: True
    example: `aws`
  </definition>
  <definition term="cloud.instance.name">
    Instance name of the host machine.
    type: keyword
    required: True
    ECS field: True
  </definition>
  <definition term="cloud.project.id">
    Name of the project in Google Cloud.
    type: keyword
    required: True
    ECS field: False
  </definition>
  <definition term="service.type">
    The type of the service data is collected from.
    The type can be used to group and correlate logs and metrics from one service type.
    Example: If metrics are collected from Elasticsearch, service.type would be `elasticsearch`.
    type: keyword
    required: True
    ECS field: False
    example: `elasticsearch`
  </definition>
  <definition term="host.hostname">
    Name of the host.
    It normally contains what the `hostname` command returns on the host machine.
    type: keyword
    required: True, if you want to use the machine learning features.
    ECS field: True
    example: `Elastic.local`
  </definition>
  <definition term="host.os.name">
    Operating system name, without the version.
    Multi-fields:
    - os.name.text (type: text)
    type: keyword
    required: True
    ECS field: True
    example: `Mac OS X`
  </definition>
  <definition term="host.os.kernel">
    Operating system kernel version as a raw string.
    type: keyword
    required: True
    ECS field: True
    example: `4.4.0-112-generic`
  </definition>
</definitions>