﻿---
title: Kibana anomaly detection job wizards
description: Anomaly detection jobs contain the configuration information and metadata necessary to perform an analytics task. Kibana can recognize certain types of...
url: https://www.elastic.co/docs/reference/machine-learning/supplied-anomaly-detection-configurations
products:
  - Elasticsearch
  - Machine Learning
---

# Kibana anomaly detection job wizards
Anomaly detection jobs contain the configuration information and metadata necessary to perform an analytics task. Kibana can recognize certain types of data and provide specialized wizards for that context. This page lists the categories of the anomaly detection jobs that are ready to use via Kibana in **Machine learning**. Refer to [Create anomaly detection jobs](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs) to learn more about creating a job by using supplied configurations. Logs and Metrics supplied configurations are available and can be created via the related solution UI in Kibana.
- [Apache](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-apache)
- [APM](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-apm)
- [Auditbeat](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-auditbeat)
- [Logs](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-logs-ui)
- [Metricbeat](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-metricbeat)
- [Metrics](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-metrics-ui)
- [Nginx](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-nginx)
- [Security](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-siem)
- [Uptime](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-uptime)

<note>
  The configurations are only available if data exists that matches the queries specified in the manifest files. These recognizer queries are linked in the descriptions of the individual configurations.
</note>


## Model memory considerations

By default, these jobs have `model_memory_limit` values that are deemed appropriate for typical user environments and data characteristics. If your environment or your data is atypical and your jobs reach a memory status value of `soft_limit` or `hard_limit`, you might need to update the model memory limits. For more information, see [Working with anomaly detection at scale](/docs/explore-analyze/machine-learning/anomaly-detection/anomaly-detection-scale#set-model-memory-limit).