﻿---
title: Uptime anomaly detection configurations
description: If you have appropriate Heartbeat data in Elasticsearch, you can enable this anomaly detection job in the Uptime app in Kibana. For more usage information,...
url: https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-uptime
products:
  - Elasticsearch
  - Machine Learning
---

# Uptime anomaly detection configurations
If you have appropriate Heartbeat data in Elasticsearch, you can enable this anomaly detection job in the [Uptime app](/docs/solutions/observability/synthetics#monitoring-uptime) in Kibana. For more usage information, refer to [Inspect uptime duration anomalies](https://www.elastic.co/docs/solutions/observability/uptime/inspect-duration-anomalies).

## Uptime: Heartbeat

Detect latency issues in heartbeat monitors.
These configurations are available in Kibana only if data exists that matches the recognizer query specified in the [manifest file](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/uptime_heartbeat/manifest.json).

| Name                | Description                                                       | Job (JSON)                                                                                                                                                                 | Datafeed                                                                                                                                                                            |
|---------------------|-------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| high_latency_by_geo | Identify periods of increased latency across geographical regions | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/uptime_heartbeat/ml/high_latency_by_geo.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/uptime_heartbeat/ml/datafeed_high_latency_by_geo.json) |