﻿---
title: Nginx anomaly detection configurations
description: These anomaly detection job wizards appear in Kibana if you use the Nginx integration in Fleet or you use Filebeat to ship access logs from your Nginx...
url: https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-nginx
products:
  - Elasticsearch
  - Machine Learning
---

# Nginx anomaly detection configurations
These anomaly detection job wizards appear in Kibana if you use the Nginx integration in Fleet or you use Filebeat to ship access logs from your [Nginx](http://nginx.org/) HTTP servers to Elasticsearch. The jobs assume that you use fields and data types from the Elastic Common Schema (ECS).

## Nginx access logs

Find unusual activity in HTTP access logs.
These jobs are available in Kibana only if data exists that matches the query specified in the [manifest file](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json).

| Name                         | Description                                             | Job (JSON)                                                                                                        | Datafeed                                                                                                          |
|------------------------------|---------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|
| low_request_rate_nginx       | Detect low request rates                                | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L215) | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L370) |
| source_ip_request_rate_nginx | Detect unusual source IPs - high request rates          | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L176) | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L349) |
| source_ip_url_count_nginx    | Detect unusual source IPs - high distinct count of URLs | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L136) | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L328) |
| status_code_rate_nginx       | Detect unusual status code rates                        | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L90)  | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L307) |
| visitor_rate_nginx           | Detect unusual visitor rates                            | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L47)  | [code](https://github.com/elastic/integrations/blob/main/packages/nginx/kibana/ml_module/nginx-Logs-ml.json#L260) |


## Nginx access logs (Filebeat)

These legacy anomaly detection jobs find unusual activity in HTTP access logs. For the latest versions, install the Nginx integration in Fleet; see [Nginx access logs](#nginx-access-logs).
These jobs exist in Kibana only if data exists that matches the recognizer query specified in the [manifest file](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/manifest.json).

| Name                       | Description                                                   | Job (JSON)                                                                                                                                                                 | Datafeed                                                                                                                                                                            |
|----------------------------|---------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| low_request_rate_ecs       | Detect low request rates (ECS)                                | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/low_request_rate_ecs.json)       | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/datafeed_low_request_rate_ecs.json)       |
| source_ip_request_rate_ecs | Detect unusual source IPs - high request rates (ECS)          | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/source_ip_request_rate_ecs.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/datafeed_source_ip_request_rate_ecs.json) |
| source_ip_url_count_ecs    | Detect unusual source IPs - high distinct count of URLs (ECS) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/source_ip_url_count_ecs.json)    | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/datafeed_source_ip_url_count_ecs.json)    |
| status_code_rate_ecs       | Detect unusual status code rates (ECS)                        | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/status_code_rate_ecs.json)       | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/datafeed_status_code_rate_ecs.json)       |
| visitor_rate_ecs           | Detect unusual visitor rates (ECS)                            | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/visitor_rate_ecs.json)           | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/nginx_ecs/ml/datafeed_visitor_rate_ecs.json)           |