﻿---
title: Metricbeat anomaly detection configurations
description: These anomaly detection job wizards appear in Kibana if you use the Metricbeat system module to monitor your servers. For more details, see the datafeed...
url: https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-metricbeat
products:
  - Elasticsearch
  - Machine Learning
---

# Metricbeat anomaly detection configurations
These anomaly detection job wizards appear in Kibana if you use the [Metricbeat system module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-system) to monitor your servers. For more details, see the datafeed and job definitions in GitHub.

## Metricbeat system

Detect anomalies in Metricbeat System data (ECS).
These configurations are only available if data exists that matches the recognizer query specified in the [manifest file](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/manifest.json#L8).

| Name                     | Description                                                | Job (JSON)                                                                                                                                                                           | Datafeed                                                                                                                                                                                      |
|--------------------------|------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| high_mean_cpu_iowait_ecs | Detect unusual increases in cpu time spent in iowait (ECS) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/ml/high_mean_cpu_iowait_ecs.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/ml/datafeed_high_mean_cpu_iowait_ecs.json) |
| max_disk_utilization_ecs | Detect unusual increases in disk utilization (ECS)         | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/ml/max_disk_utilization_ecs.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/ml/datafeed_max_disk_utilization_ecs.json) |
| metricbeat_outages_ecs   | Detect unusual decreases in metricbeat documents (ECS)     | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/ml/metricbeat_outages_ecs.json)   | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/metricbeat_system_ecs/ml/datafeed_metricbeat_outages_ecs.json)   |