﻿---
title: Logs anomaly detection configurations
description: These anomaly detection jobs appear by default in the Logs app in Kibana. For more information about their usage, refer to Categorize log entries and...
url: https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-logs-ui
products:
  - Elasticsearch
  - Machine Learning
---

# Logs anomaly detection configurations
These anomaly detection jobs appear by default in the [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs) in Kibana. For more information about their usage, refer to [Categorize log entries](https://www.elastic.co/docs/solutions/observability/logs/categorize-log-entries) and [Inspect log anomalies](https://www.elastic.co/docs/solutions/observability/logs/inspect-log-anomalies).

## Log analysis

Detect anomalies in log entries through the Logs UI.

| Name           | Description                                       | Job (JSON)                                                                                                                                                            | Datafeed                                                                                                                                                                       |
|----------------|---------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| log_entry_rate | Detects anomalies in the log entry ingestion rate | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/logs_ui_analysis/ml/log_entry_rate.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/logs_ui_analysis/ml/datafeed_log_entry_rate.json) |


## Log entry categories

Detect anomalies in count of log entries by category.

| Name                       | Description                                           | Job (JSON)                                                                                                                                                                          | Datafeed                                                                                                                                                                                     |
|----------------------------|-------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| log_entry_categories_count | Detects anomalies in count of log entries by category | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/logs_ui_categories/ml/log_entry_categories_count.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/logs_ui_categories/ml/datafeed_log_entry_categories_count.json) |