﻿---
title: Auditbeat anomaly detection configurations
description: These anomaly detection job wizards appear in Kibana if you use Auditbeat to audit process activity on your systems. For more details, see the datafeed...
url: https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-auditbeat
products:
  - Elasticsearch
  - Machine Learning
---

# Auditbeat anomaly detection configurations
These anomaly detection job wizards appear in Kibana if you use [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat) to audit process activity on your systems. For more details, see the datafeed and job definitions in GitHub.

## Auditbeat docker processes

Detect unusual processes in docker containers from auditd data (ECS).
These configurations are only available if data exists that matches the recognizer query specified in the [manifest file](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/auditbeat_process_docker_ecs/manifest.json#L8).

| Name                                 | Description                                                                    | Job (JSON)                                                                                                                                                                                              | Datafeed                                                                                                                                                                                                         |
|--------------------------------------|--------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| docker_high_count_process_events_ecs | Detect unusual increases in process execution rates in docker containers (ECS) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/auditbeat_process_docker_ecs/ml/docker_high_count_process_events_ecs.json) | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/auditbeat_process_docker_ecs/ml/datafeed_docker_high_count_process_events_ecs.json) |
| docker_rare_process_activity_ecs     | Detect rare process executions in docker containers (ECS)                      | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/auditbeat_process_docker_ecs/ml/docker_rare_process_activity_ecs.json)     | [code](https://github.com/elastic/kibana/blob/master/x-pack/platform/plugins/shared/ml/server/models/data_recognizer/modules/auditbeat_process_docker_ecs/ml/datafeed_docker_rare_process_activity_ecs.json)     |