﻿---
title: Sqs output plugin v7.2.1
description: A component of the aws integration plugin, Integration version: v7.2.1, Released on: 2025-02-13, Changelog. For other versions, see the overview list...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v7-2-1-plugins-outputs-sqs
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Sqs output plugin v7.2.1
- A component of the [aws integration plugin](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-aws-index)
- Integration version: v7.2.1
- Released on: 2025-02-13
- [Changelog](https://github.com/logstash-plugins/logstash-integration-aws/blob/v7.2.1/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-sqs-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-integration-aws). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Push events to an Amazon Web Services (AWS) Simple Queue Service (SQS) queue.
SQS is a simple, scalable queue system that is part of the Amazon Web Services suite of tools. Although SQS is similar to other queuing systems such as Advanced Message Queuing Protocol (AMQP), it uses a custom API and requires that you have an AWS account. See  for more details on how SQS works, what the pricing schedule looks like and how to setup a queue.
The "consumer" identity must have the following permissions on the queue:
- `sqs:GetQueueUrl`
- `sqs:SendMessage`
- `sqs:SendMessageBatch`

Typically, you should setup an IAM policy, create a user and apply the IAM policy to the user. See  for more details on setting up AWS identities. A sample policy is as follows:
```
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "sqs:GetQueueUrl",
        "sqs:SendMessage",
        "sqs:SendMessageBatch"
      ],
      "Resource": "arn:aws:sqs:us-east-1:123456789012:my-sqs-queue"
    }
  ]
}
```


## Batch Publishing

This output publishes messages to SQS in batches in order to optimize event throughput and increase performance. This is done using the [`SendMessageBatch`](http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessageBatch.html) API. When publishing messages to SQS in batches, the following service limits must be respected (see [Limits in Amazon SQS](http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-messages.html)):
- The maximum allowed individual message size is 256KiB.
- The maximum total payload size (i.e. the sum of the sizes of all individual messages within a batch) is also 256KiB.

This plugin will dynamically adjust the size of the batch published to SQS in order to ensure that the total payload size does not exceed 256KiB.
This output cannot currently handle messages larger than 256KiB. Any single message exceeding this size will be dropped.

## Sqs Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v7.2.1-plugins-outputs-sqs-common-options) described later.

| Setting                                                                                | Input type                                                      | Required |
|----------------------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`access_key_id`](#v7.2.1-plugins-outputs-sqs-access_key_id)                           | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`aws_credentials_file`](#v7.2.1-plugins-outputs-sqs-aws_credentials_file)             | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`batch_events`](#v7.2.1-plugins-outputs-sqs-batch_events)                             | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`endpoint`](#v7.2.1-plugins-outputs-sqs-endpoint)                                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`message_max_size`](#v7.2.1-plugins-outputs-sqs-message_max_size)                     | [bytes](/docs/reference/logstash/plugins/value-types#bytes)     | No       |
| [`proxy_uri`](#v7.2.1-plugins-outputs-sqs-proxy_uri)                                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`queue`](#v7.2.1-plugins-outputs-sqs-queue)                                           | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`queue_owner_aws_account_id`](#v7.2.1-plugins-outputs-sqs-queue_owner_aws_account_id) | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`region`](#v7.2.1-plugins-outputs-sqs-region)                                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`role_arn`](#v7.2.1-plugins-outputs-sqs-role_arn)                                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`role_session_name`](#v7.2.1-plugins-outputs-sqs-role_session_name)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`secret_access_key`](#v7.2.1-plugins-outputs-sqs-secret_access_key)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`session_token`](#v7.2.1-plugins-outputs-sqs-session_token)                           | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`use_aws_bundled_ca`](#v7.2.1-plugins-outputs-sqs-use_aws_bundled_ca)                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`web_identity_token_file`](#v7.2.1-plugins-outputs-sqs-web_identity_token_file)       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |

Also see [Common options](#v7.2.1-plugins-outputs-sqs-common-options) for a list of options supported by all output plugins.

### `access_key_id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

This plugin uses the AWS SDK and supports several ways to get credentials, which will be tried in this order:
1. Static configuration, using `access_key_id` and `secret_access_key` params in logstash plugin config
2. External credentials file specified by `aws_credentials_file`
3. Environment variables `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`
4. Environment variables `AMAZON_ACCESS_KEY_ID` and `AMAZON_SECRET_ACCESS_KEY`
5. IAM Instance Profile (available when running inside EC2)


### `aws_credentials_file`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Path to YAML file containing a hash of AWS credentials. This file will only be loaded if `access_key_id` and `secret_access_key` aren’t set. The contents of the file should look like this:
```
    :access_key_id: "12345"
    :secret_access_key: "54321"
```


### `batch_events`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10`

The number of events to be sent in each batch. Set this to `1` to disable the batch sending of messages.

### `endpoint`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The endpoint to connect to. By default it is constructed using the value of `region`. This is useful when connecting to S3 compatible services, but beware that these aren’t guaranteed to work correctly with the AWS SDK.

### `message_max_size`

- Value type is [bytes](/docs/reference/logstash/plugins/value-types#bytes)
- Default value is `"256KiB"`

The maximum number of bytes for any message sent to SQS. Messages exceeding this size will be dropped. See .

### `proxy_uri`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

URI to proxy server if required

### `queue`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The name of the target SQS queue. Note that this is just the name of the queue, not the URL or ARN.

### `queue_owner_aws_account_id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The owning account id of the target SQS queue. IAM permissions need to be configured on both accounts to function.

### `region`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"us-east-1"`

The AWS Region

### `role_arn`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The AWS IAM Role to assume, if any. This is used to generate temporary credentials, typically for cross-account access. See the [AssumeRole API documentation](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html) for more information.

### `role_session_name`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

Session name to use when assuming an IAM role.

### `secret_access_key`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The AWS Secret Access Key

### `session_token`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The AWS Session token for temporary credential

### `use_aws_bundled_ca`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Use bundled CA certificates that ship with AWS SDK to verify SSL peer certificates. For cases where the default certificates are unavailable, e.g. Windows, you can set this to `true`.

### `web_identity_token_file`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)

Absolute path to the file on disk containing OIDC token for [IRSA](https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts.html). Set the path to `"/var/run/secrets/eks.amazonaws.com/serviceaccount/token"` when using Amazon EKS. If specified, [`role_arn`](#v7.2.1-plugins-outputs-sqs-role_arn) must not be empty.
For the details of setting up IAM roles and Kubernetes service accounts, check out [userguide](https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html)

## Common options

These configuration options are supported by all output plugins:

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v7.2.1-plugins-outputs-sqs-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v7.2.1-plugins-outputs-sqs-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v7.2.1-plugins-outputs-sqs-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"json"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 sqs outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  sqs {
    id => "my_plugin_id"
  }
}
```