﻿---
title: Cef codec plugin v6.2.0
description: Plugin version: v6.2.0, Released on: 2021-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v6-2-0-plugins-codecs-cef
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Cef codec plugin v6.2.0
- Plugin version: v6.2.0
- Released on: 2021-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-codec-cef/blob/v6.2.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-cef-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-cef). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Implementation of a Logstash codec for the ArcSight Common Event Format (CEF) Based on Revision 20 of Implementing ArcSight CEF, dated from June 05, 2013 
If this codec receives a payload from an input that is not a valid CEF message, then it will produce an event with the payload as the *message* field and a *_cefparsefailure* tag.

## Compatibility with the Elastic Common Schema (ECS)

This plugin can be used to decode CEF events *into* the Elastic Common Schema, or to encode ECS-compatible events into CEF. It can also be used *without* ECS, encoding and decoding events using only CEF-defined field names and keys.
The ECS Compatibility mode for a specific plugin instance can be controlled by setting [`ecs_compatibility`](#v6.2.0-plugins-codecs-cef-ecs_compatibility) when defining the codec:
```
    input {
      tcp {
        # ...
        codec => cef {
          ecs_compatibility => v1
        }
      }
    }
```

If left unspecified, the value of the `pipeline.ecs_compatibility` setting is used.

### Timestamps and ECS Compatiblity

When running in ECS Compatibility Mode, timestamp-type fields are parsed and normalized to specific points on the timeline.
Because the CEF format allows ambiguous timestamp formats, some reasonable assumptions are made:
- When the timestamp does not include a year, we assume it happened in the recent past (or *very* near future to accommodate out-of-sync clocks and timezone offsets).
- When the timestamp does not include UTC-offset information, we use the event’s timezone (`dtz` or `deviceTimeZone` field), or fall through to this plugin’s [`default_timezone`](#v6.2.0-plugins-codecs-cef-default_timezone).
- Localized timestamps are parsed using the provided [`locale`](#v6.2.0-plugins-codecs-cef-locale).


## Cef Codec Configuration Options


| Setting                                                             | Input type                                                      | Required |
|---------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`default_timezone`](#v6.2.0-plugins-codecs-cef-default_timezone)   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`delimiter`](#v6.2.0-plugins-codecs-cef-delimiter)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`device`](#v6.2.0-plugins-codecs-cef-device)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`ecs_compatibility`](#v6.2.0-plugins-codecs-cef-ecs_compatibility) | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`fields`](#v6.2.0-plugins-codecs-cef-fields)                       | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`locale`](#v6.2.0-plugins-codecs-cef-locale)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`name`](#v6.2.0-plugins-codecs-cef-name)                           | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`product`](#v6.2.0-plugins-codecs-cef-product)                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`reverse_mapping`](#v6.2.0-plugins-codecs-cef-reverse_mapping)     | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`severity`](#v6.2.0-plugins-codecs-cef-severity)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`signature`](#v6.2.0-plugins-codecs-cef-signature)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`vendor`](#v6.2.0-plugins-codecs-cef-vendor)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`version`](#v6.2.0-plugins-codecs-cef-version)                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `default_timezone`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - [Timezone names](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) (such as `Europe/Moscow`, `America/Argentina/Buenos_Aires`)
- UTC Offsets (such as `-08:00`, `+03:00`)
- The default value is your system time zone
- This option has no effect when *encoding*.

When parsing timestamp fields in ECS mode and encountering timestamps that do not contain UTC-offset information, the `deviceTimeZone` (`dtz`) field from the CEF payload is used to interpret the given time. If the event does not include timezone information, this `default_timezone` is used instead.

### `delimiter`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

If your input puts a delimiter between each CEF event, you’ll want to set this to be that delimiter.
For example, with the TCP input, you probably want to put this:
```
input {
  tcp {
    codec => cef { delimiter => "\r\n" }
    # ...
  }
}
```

This setting allows the following character sequences to have special meaning:
- `\r` (backslash "r") - means carriage return (ASCII 0x0D)
- `\n` (backslash "n") - means newline (ASCII 0x0A)


### `device`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `observer`: indicates that device-specific fields represent the device used to *observe* the event.
- `host`: indicates that device-specific fields represent the device on which the event *occurred*.
- The default value for this setting is `observer`.
- Option has no effect when [`ecs_compatibility => disabled`](#v6.2.0-plugins-codecs-cef-ecs_compatibility).
- Option has no effect when *encoding*

Defines a set of device-specific CEF fields as either representing the device on which an event *occurred*, or merely the device from which the event was *observed*. This causes the relevant fields to be routed to either the `host` or the `observer` top-level groupings.
If the codec handles data from a variety of sources, the ECS recommendation is to use `observer`.

### `ecs_compatibility`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `disabled`: uses CEF-defined field names in the event (e.g., `bytesIn`, `sourceAddress`)
- `v1`: supports ECS-compatible event fields (e.g., `[source,shell][bytes]`, `[source,shell][ip]`)
- Default value depends on which version of Logstash is running:
  - When Logstash provides a `pipeline.ecs_compatibility` setting, its value is used as the default
- Otherwise, the default value is `disabled`.

Controls this plugin’s compatibility with the [Elastic Common Schema (ECS)](https://www.elastic.co/guide/en/ecs/current) (ECS)].

### `fields`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, a list of fields can be provided to be included in CEF extensions part as key/value pairs.

### `locale`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - Abbreviated language_COUNTRY format (e.g., `en_GB`, `pt_BR`)
- Valid [IETF BCP 47](https://tools.ietf.org/html/bcp47) language tag (e.g., `zh-cmn-Hans-CN`)
- The default value is your system locale
- Option has no effect when *encoding*

When parsing timestamp fields in ECS mode and encountering timestamps in a localized format, this `locale` is used to interpret locale-specific strings such as month abbreviations.

### `name`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"Logstash"`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, this option can be used to specify the value of the name field in the CEF header. The new value can include `%{foo}` strings to help you build a new value from other parts of the event.

### `product`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"Logstash"`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, this option can be used to specify the value of the device product field in CEF header. The new value can include `%{foo}` strings to help you build a new value from other parts of the event.

### `reverse_mapping`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`
- Option has no effect when *decoding*

Set to true to adhere to the specifications and encode using the CEF key name (short name) for the CEF field names.

### `severity`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"6"`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, this option can be used to specify the value of the severity field in CEF header. The new value can include `%{foo}` strings to help you build a new value from other parts of the event.
Defined as field of type string to allow sprintf. The value will be validated to be an integer in the range from 0 to 10 (including). All invalid values will be mapped to the default of 6.

### `signature`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"Logstash"`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, this option can be used to specify the value of the signature ID field in CEF header. The new value can include `%{foo}` strings to help you build a new value from other parts of the event.

### `vendor`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"Elasticsearch"`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, this option can be used to specify the value of the device vendor field in CEF header. The new value can include `%{foo}` strings to help you build a new value from other parts of the event.

### `version`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"1.0"`
- Option has no effect when *decoding*

When this codec is used in an Output Plugin, this option can be used to specify the value of the device version field in CEF header. The new value can include `%{foo}` strings to help you build a new value from other parts of the event.