﻿---
title: Beats input plugin v5.1.7
description: Plugin version: v5.1.7, Released on: 2018-11-28, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v5-1-7-plugins-inputs-beats
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Beats input plugin v5.1.7
- Plugin version: v5.1.7
- Released on: 2018-11-28
- [Changelog](https://github.com/logstash-plugins/logstash-input-beats/blob/v5.1.7/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-beats-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-beats). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This input plugin enables Logstash to receive events from the [Elastic Beats](https://www.elastic.co/products/beats) framework.
The following example shows how to configure Logstash to listen on port 5044 for incoming Beats connections and to index into Elasticsearch.
```
input {
  beats {
    port => 5044
  }
}

output {
  elasticsearch {
    hosts => "localhost:9200"
    manage_template => false
    index => "%{[@metadata][beat]}-%{[@metadata][version]}-%{+YYYY.MM.dd}" 
    document_type => "%{[@metadata][type]}" 
  }
}
```

If you are shipping events that span multiple lines, you need to use the [configuration options available in Filebeat](https://www.elastic.co/guide/en/beats/filebeat/current/multiline-examples.html) to handle multiline events before sending the event data to Logstash. You cannot use the [Multiline codec plugin](https://www.elastic.co/guide/en/logstash/current/plugins-codecs-multiline.html) to handle multiline events. Doing so will result in the failure to start Logstash.

## Versioned Beats Indices

To minimize the impact of future schema changes on your existing indices and mappings in Elasticsearch, configure the Elasticsearch output to write to versioned indices. The pattern that you specify for the `index` setting controls the index name:
```
index => "%{[@metadata][beat]}-%{[@metadata][version]}-%{+YYYY.MM.dd}"
```

- `%{[@metadata][beat]}`
  Sets the first part of the index name to the value of the `beat` metadata field, for example, `filebeat`.
- `%{[@metadata][version]}`
  Sets the second part of the name to the Beat version, for example, `{logstash_version}`.
- `%{+YYYY.MM.dd}`
  Sets the third part of the name to a date based on the Logstash `@timestamp` field.

This configuration results in daily index names like `filebeat-{logstash_version}-2026-02-04`.

## Beats Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v5.1.7-plugins-inputs-beats-common-options) described later.

| Setting                                                                                   | Input type                                                                                             | Required |
|-------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------|----------|
| [`add_hostname`](#v5.1.7-plugins-inputs-beats-add_hostname)                               | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                                        | No       |
| [`cipher_suites`](#v5.1.7-plugins-inputs-beats-cipher_suites)                             | [array](/docs/reference/logstash/plugins/value-types#array)                                            | No       |
| [`client_inactivity_timeout`](#v5.1.7-plugins-inputs-beats-client_inactivity_timeout)     | [number](/docs/reference/logstash/plugins/value-types#number)                                          | No       |
| [`host`](#v5.1.7-plugins-inputs-beats-host)                                               | [string](/docs/reference/logstash/plugins/value-types#string)                                          | No       |
| [`include_codec_tag`](#v5.1.7-plugins-inputs-beats-include_codec_tag)                     | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                                        | No       |
| [`port`](#v5.1.7-plugins-inputs-beats-port)                                               | [number](/docs/reference/logstash/plugins/value-types#number)                                          | Yes      |
| [`ssl`](#v5.1.7-plugins-inputs-beats-ssl)                                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                                        | No       |
| [`ssl_certificate`](#v5.1.7-plugins-inputs-beats-ssl_certificate)                         | a valid filesystem path                                                                                | No       |
| [`ssl_certificate_authorities`](#v5.1.7-plugins-inputs-beats-ssl_certificate_authorities) | [array](/docs/reference/logstash/plugins/value-types#array)                                            | No       |
| [`ssl_handshake_timeout`](#v5.1.7-plugins-inputs-beats-ssl_handshake_timeout)             | [number](/docs/reference/logstash/plugins/value-types#number)                                          | No       |
| [`ssl_key`](#v5.1.7-plugins-inputs-beats-ssl_key)                                         | a valid filesystem path                                                                                | No       |
| [`ssl_key_passphrase`](#v5.1.7-plugins-inputs-beats-ssl_key_passphrase)                   | [password](/docs/reference/logstash/plugins/value-types#password)                                      | No       |
| [`ssl_verify_mode`](#v5.1.7-plugins-inputs-beats-ssl_verify_mode)                         | [string](/docs/reference/logstash/plugins/value-types#string), one of `["none", "peer", "force_peer"]` | No       |
| [`ssl_peer_metadata`](#v5.1.7-plugins-inputs-beats-ssl_peer_metadata)                     | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                                        | No       |
| [`tls_max_version`](#v5.1.7-plugins-inputs-beats-tls_max_version)                         | [number](/docs/reference/logstash/plugins/value-types#number)                                          | No       |
| [`tls_min_version`](#v5.1.7-plugins-inputs-beats-tls_min_version)                         | [number](/docs/reference/logstash/plugins/value-types#number)                                          | No       |

Also see [Common options](#v5.1.7-plugins-inputs-beats-common-options) for a list of options supported by all input plugins.

### `add_hostname`

Added in 5.1.4.
Field was added to allow users to control whether or not the `host` field is automatically added to events.
Deprecated in 5.1.4.
In future versions of this plugin
- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Flag to determine whether to add `host` field to event using the value supplied by the beat in the `hostname` field.

### `cipher_suites`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `java.lang.String[TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256]@459cfcca`

The list of ciphers suite to use, listed by priorities.

### `client_inactivity_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `60`

Close Idle clients after X seconds of inactivity.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

The IP address to listen on.

### `include_codec_tag`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`


### `port`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

The port to listen on.

### `ssl`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Events are by default sent in plain text. You can enable encryption by setting `ssl` to true and configuring the `ssl_certificate` and `ssl_key` options.

### `ssl_certificate`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL certificate to use.

### `ssl_certificate_authorities`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

Validate client certificates against these authorities. You can define multiple files or paths. All the certificates will be read and added to the trust store. You need to configure the `ssl_verify_mode` to `peer` or `force_peer` to enable the verification.

### `ssl_handshake_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10000`

Time in milliseconds for an incomplete ssl handshake to timeout

### `ssl_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL key to use. NOTE: This key need to be in the PKCS8 format, you can convert it with [OpenSSL](https://www.openssl.org/docs/man1.1.0/apps/pkcs8.html) for more information.

### `ssl_key_passphrase`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

SSL key passphrase to use.

### `ssl_verify_mode`

- Value can be any of: `none`, `peer`, `force_peer`
- Default value is `"none"`

By default the server doesn’t do any client verification.
`peer` will make the server ask the client to provide a certificate. If the client provides a certificate, it will be validated.
`force_peer` will make the server ask the client to provide a certificate. If the client doesn’t provide a certificate, the connection will be closed.
This option needs to be used with `ssl_certificate_authorities` and a defined list of CAs.

### `ssl_peer_metadata`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Enables storing client certificate information in event’s metadata.
This option is only valid when `ssl_verify_mode` is set to `peer` or `force_peer`.

### `tls_max_version`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1.2`

The maximum TLS version allowed for the encrypted connections. The value must be the one of the following: 1.0 for TLS 1.0, 1.1 for TLS 1.1, 1.2 for TLS 1.2

### `tls_min_version`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

The minimum TLS version allowed for the encrypted connections. The value must be one of the following: 1.0 for TLS 1.0, 1.1 for TLS 1.1, 1.2 for TLS 1.2

## Common options

These configuration options are supported by all input plugins:

| Setting                                                       | Input type                                                      | Required |
|---------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v5.1.7-plugins-inputs-beats-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v5.1.7-plugins-inputs-beats-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v5.1.7-plugins-inputs-beats-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v5.1.7-plugins-inputs-beats-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v5.1.7-plugins-inputs-beats-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v5.1.7-plugins-inputs-beats-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 beats inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  beats {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.
The Beats shipper automatically sets the `type` field on the event. You cannot override this setting in the Logstash config. If you specify a setting for the [`type`](#v5.1.7-plugins-inputs-beats-type) config option in Logstash, it is ignored.