﻿---
title: Redis output plugin v5.0.0
description: Plugin version: v5.0.0, Released on: 2019-01-11, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v5-0-0-plugins-outputs-redis
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Redis output plugin v5.0.0
- Plugin version: v5.0.0
- Released on: 2019-01-11
- [Changelog](https://github.com/logstash-plugins/logstash-output-redis/blob/v5.0.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-redis-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-redis). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output will send events to a Redis queue using RPUSH. The RPUSH command is supported in Redis v0.0.7+. Using PUBLISH to a channel requires at least v1.3.8+. While you may be able to make these Redis versions work, the best performance and stability will be found in more recent stable versions. Versions 2.6.0+ are recommended.
For more information, see [the Redis homepage](http://redis.io/)

## Redis Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v5.0.0-plugins-outputs-redis-common-options) described later.

| Setting                                                                      | Input type                                                                                  | Required |
|------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|----------|
| [`batch`](#v5.0.0-plugins-outputs-redis-batch)                               | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                             | No       |
| [`batch_events`](#v5.0.0-plugins-outputs-redis-batch_events)                 | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`batch_timeout`](#v5.0.0-plugins-outputs-redis-batch_timeout)               | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`congestion_interval`](#v5.0.0-plugins-outputs-redis-congestion_interval)   | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`congestion_threshold`](#v5.0.0-plugins-outputs-redis-congestion_threshold) | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`data_type`](#v5.0.0-plugins-outputs-redis-data_type)                       | [string](/docs/reference/logstash/plugins/value-types#string), one of `["list", "channel"]` | No       |
| [`db`](#v5.0.0-plugins-outputs-redis-db)                                     | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`host`](#v5.0.0-plugins-outputs-redis-host)                                 | [array](/docs/reference/logstash/plugins/value-types#array)                                 | No       |
| [`key`](#v5.0.0-plugins-outputs-redis-key)                                   | [string](/docs/reference/logstash/plugins/value-types#string)                               | No       |
| [`password`](#v5.0.0-plugins-outputs-redis-password)                         | [password](/docs/reference/logstash/plugins/value-types#password)                           | No       |
| [`port`](#v5.0.0-plugins-outputs-redis-port)                                 | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`reconnect_interval`](#v5.0.0-plugins-outputs-redis-reconnect_interval)     | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |
| [`shuffle_hosts`](#v5.0.0-plugins-outputs-redis-shuffle_hosts)               | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                             | No       |
| [`timeout`](#v5.0.0-plugins-outputs-redis-timeout)                           | [number](/docs/reference/logstash/plugins/value-types#number)                               | No       |

Also see [Common options](#v5.0.0-plugins-outputs-redis-common-options) for a list of options supported by all output plugins.

### `batch`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Set to true if you want Redis to batch up values and send 1 RPUSH command instead of one command per value to push on the list. Note that this only works with `data_type="list"` mode right now.
If true, we send an RPUSH every "batch_events" events or "batch_timeout" seconds (whichever comes first). Only supported for `data_type` is "list".

### `batch_events`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `50`

If batch is set to true, the number of events we queue up for an RPUSH.

### `batch_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5`

If batch is set to true, the maximum amount of time between RPUSH commands when there are pending events to flush.

### `congestion_interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

How often to check for congestion. Default is one second. Zero means to check on every event.

### `congestion_threshold`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

In case Redis `data_type` is `list` and has more than `@congestion_threshold` items, block until someone consumes them and reduces congestion, otherwise if there are no consumers Redis will run out of memory, unless it was configured with OOM protection. But even with OOM protection, a single Redis list can block all other users of Redis, until Redis CPU consumption reaches the max allowed RAM size. A default value of 0 means that this limit is disabled. Only supported for `list` Redis `data_type`.

### `data_type`

- Value can be any of: `list`, `channel`
- There is no default value for this setting.

Either list or channel. If `data_type` is list, then we will set RPUSH to key. If `data_type` is channel, then we will PUBLISH to `key`.

### `db`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

The Redis database number.

### `host`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["127.0.0.1"]`

The hostname(s) of your Redis server(s). Ports may be specified on any hostname, which will override the global port config. If the hosts list is an array, Logstash will pick one random host to connect to, if that host is disconnected it will then pick another.
For example:
```
    "127.0.0.1"
    ["127.0.0.1", "127.0.0.2"]
    ["127.0.0.1:6380", "127.0.0.1"]
```


### `key`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The name of a Redis list or channel. Dynamic names are valid here, for example `logstash-%{type}`.

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Password to authenticate with. There is no authentication by default.

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `6379`

The default port to connect on. Can be overridden on any hostname.

### `reconnect_interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

Interval for reconnecting to failed Redis connections

### `shuffle_hosts`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Shuffle the host list during Logstash startup.

### `timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5`

Redis initial connection timeout in seconds.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                        | Input type                                                      | Required |
|----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v5.0.0-plugins-outputs-redis-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v5.0.0-plugins-outputs-redis-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v5.0.0-plugins-outputs-redis-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"json"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 redis outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  redis {
    id => "my_plugin_id"
  }
}
```