﻿---
title: Tcp input plugin v4.2.2
description: Plugin version: v4.2.2, Released on: 2017-06-30, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v4-2-2-plugins-inputs-tcp
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Tcp input plugin v4.2.2
- Plugin version: v4.2.2
- Released on: 2017-06-30
- [Changelog](https://github.com/logstash-plugins/logstash-input-tcp/blob/v4.2.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-tcp-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-tcp). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Read events over a TCP socket.
Like stdin and file inputs, each event is assumed to be one line of text.
Can either accept connections from clients or connect to a server, depending on `mode`.

### Accepting log4j2 logs

Log4j2 can send JSON over a socket, and we can use that combined with our tcp input to accept the logs.
First, we need to configure your application to send logs in JSON over a socket. The following log4j2.xml accomplishes this task.
Note, you will want to change the `host` and `port` settings in this configuration to match your needs.
```
<Configuration>
  <Appenders>
     <Socket name="Socket" host="localhost" port="12345">
       <JsonLayout compact="true" eventEol="true" />
    </Socket>
  </Appenders>
  <Loggers>
    <Root level="info">
      <AppenderRef ref="Socket"/>
    </Root>
  </Loggers>
</Configuration>
```

To accept this in Logstash, you will want tcp input and a date filter:
```
input {
  tcp {
    port => 12345
    codec => json
  }
}
```

and add a date filter to take log4j2’s `timeMillis` field and use it as the event timestamp
```
filter {
  date {
    match => [ "timeMillis", "UNIX_MS" ]
  }
}
```


## Tcp Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v4.2.2-plugins-inputs-tcp-common-options) described later.

| Setting                                                                     | Input type                                                                                   | Required |
|-----------------------------------------------------------------------------|----------------------------------------------------------------------------------------------|----------|
| [`host`](#v4.2.2-plugins-inputs-tcp-host)                                   | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |
| [`mode`](#v4.2.2-plugins-inputs-tcp-mode)                                   | [string](/docs/reference/logstash/plugins/value-types#string), one of `["server", "client"]` | No       |
| [`port`](#v4.2.2-plugins-inputs-tcp-port)                                   | [number](/docs/reference/logstash/plugins/value-types#number)                                | Yes      |
| [`proxy_protocol`](#v4.2.2-plugins-inputs-tcp-proxy_protocol)               | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                              | No       |
| [`ssl_cert`](#v4.2.2-plugins-inputs-tcp-ssl_cert)                           | a valid filesystem path                                                                      | No       |
| [`ssl_enable`](#v4.2.2-plugins-inputs-tcp-ssl_enable)                       | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                              | No       |
| [`ssl_extra_chain_certs`](#v4.2.2-plugins-inputs-tcp-ssl_extra_chain_certs) | [array](/docs/reference/logstash/plugins/value-types#array)                                  | No       |
| [`ssl_key`](#v4.2.2-plugins-inputs-tcp-ssl_key)                             | a valid filesystem path                                                                      | No       |
| [`ssl_key_passphrase`](#v4.2.2-plugins-inputs-tcp-ssl_key_passphrase)       | [password](/docs/reference/logstash/plugins/value-types#password)                            | No       |
| [`ssl_verify`](#v4.2.2-plugins-inputs-tcp-ssl_verify)                       | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                              | No       |

Also see [Common options](#v4.2.2-plugins-inputs-tcp-common-options) for a list of options supported by all input plugins.

### `data_timeout` (DEPRECATED)

- DEPRECATED WARNING: This configuration item is deprecated and may not be available in future versions.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `-1`


### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

When mode is `server`, the address to listen on. When mode is `client`, the address to connect to.

### `mode`

- Value can be any of: `server`, `client`
- Default value is `"server"`

Mode to operate in. `server` listens for client connections, `client` connects to a server.

### `port`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

When mode is `server`, the port to listen on. When mode is `client`, the port to connect to.

### `proxy_protocol`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Proxy protocol support, only v1 is supported at this time 

### `ssl_cacert` (DEPRECATED)

- DEPRECATED WARNING: This configuration item is deprecated and may not be available in future versions.
- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The SSL CA certificate, chainfile or CA path. The system CA path is automatically included.

### `ssl_cert`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL certificate path

### `ssl_enable`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Enable SSL (must be set for other `ssl_` options to take effect).

### `ssl_extra_chain_certs`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

An Array of extra X509 certificates to be added to the certificate chain. Useful when the CA chain is not necessary in the system store.

### `ssl_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL key path

### `ssl_key_passphrase`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- Default value is `nil`

SSL key passphrase

### `ssl_verify`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Verify the identity of the other end of the SSL connection against the CA. For input, sets the field `sslsubject` to that of the client certificate.

## Common options

These configuration options are supported by all input plugins:

| Setting                                                     | Input type                                                      | Required |
|-------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v4.2.2-plugins-inputs-tcp-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v4.2.2-plugins-inputs-tcp-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v4.2.2-plugins-inputs-tcp-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v4.2.2-plugins-inputs-tcp-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v4.2.2-plugins-inputs-tcp-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v4.2.2-plugins-inputs-tcp-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 tcp inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  tcp {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.