﻿---
title: Eventlog
description: Plugin version: v4.1.3, Released on: 2018-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v4-1-3-plugins-inputs-eventlog
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Eventlog
- Plugin version: v4.1.3
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-input-eventlog/blob/v4.1.3/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-eventlog-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-eventlog). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This input will pull events from a [Windows Event Log](http://msdn.microsoft.com/en-us/library/windows/desktop/bb309026%28v=vs.85%29.aspx). Note that Windows Event Logs are stored on disk in a binary format and are only accessible from the Win32 API. This means Losgtash needs to be running as an agent on Windows servers where you wish to collect logs from, and will not be accesible across the network.
To collect Events from the System Event Log, use a config like:
```
    input {
      eventlog {
        type  => 'Win32-EventLog'
        logfile  => 'System'
      }
    }
```


## Eventlog Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v4.1.3-plugins-inputs-eventlog-common-options) described later.

| Setting                                                | Input type                                                                                                    | Required |
|--------------------------------------------------------|---------------------------------------------------------------------------------------------------------------|----------|
| [`interval`](#v4.1.3-plugins-inputs-eventlog-interval) | [number](/docs/reference/logstash/plugins/value-types#number)                                                 | No       |
| [`logfile`](#v4.1.3-plugins-inputs-eventlog-logfile)   | [string](/docs/reference/logstash/plugins/value-types#string), one of `["Application", "Security", "System"]` | No       |

Also see [Common options](#v4.1.3-plugins-inputs-eventlog-common-options) for a list of options supported by all input plugins.

### `interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1000`

How frequently should tail check for new event logs in ms (default: 1 second)

### `logfile`

- Value can be any of: `Application`, `Security`, `System`
- Default value is `"Application"`

Event Log Name System and Security may require that privileges are given to the user running logstash. see more at: 

## Common options

These configuration options are supported by all input plugins:

| Setting                                                          | Input type                                                      | Required |
|------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v4.1.3-plugins-inputs-eventlog-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v4.1.3-plugins-inputs-eventlog-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v4.1.3-plugins-inputs-eventlog-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v4.1.3-plugins-inputs-eventlog-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v4.1.3-plugins-inputs-eventlog-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v4.1.3-plugins-inputs-eventlog-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 eventlog inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  eventlog {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.