﻿---
title: Email output plugin v4.1.1
description: Plugin version: v4.1.1, Released on: 2018-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v4-1-1-plugins-outputs-email
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Email output plugin v4.1.1
- Plugin version: v4.1.1
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-output-email/blob/v4.1.1/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-email-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-email). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Sends email when an output is received. Alternatively, you may include or exclude the email output execution using conditionals.

## Usage Example

```
output {
  if "shouldmail" in [tags] {
    email {
      to => 'technical@example.com'
      from => 'monitor@example.com'
      subject => 'Alert - %{title}'
      body => "Tags: %{tags}\\n\\Content:\\n%{message}"
      template_file => "/tmp/email_template.mustache"
      domain => 'mail.example.com'
      port => 25
    }
  }
}
```


## Email Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v4.1.1-plugins-outputs-email-common-options) described later.

| Setting                                                          | Input type                                                      | Required |
|------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`address`](#v4.1.1-plugins-outputs-email-address)               | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`attachments`](#v4.1.1-plugins-outputs-email-attachments)       | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`authentication`](#v4.1.1-plugins-outputs-email-authentication) | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`body`](#v4.1.1-plugins-outputs-email-body)                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`cc`](#v4.1.1-plugins-outputs-email-cc)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`bcc`](#v4.1.1-plugins-outputs-email-bcc)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`contenttype`](#v4.1.1-plugins-outputs-email-contenttype)       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`debug`](#v4.1.1-plugins-outputs-email-debug)                   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`domain`](#v4.1.1-plugins-outputs-email-domain)                 | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`from`](#v4.1.1-plugins-outputs-email-from)                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`htmlbody`](#v4.1.1-plugins-outputs-email-htmlbody)             | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`password`](#v4.1.1-plugins-outputs-email-password)             | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`port`](#v4.1.1-plugins-outputs-email-port)                     | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`replyto`](#v4.1.1-plugins-outputs-email-replyto)               | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`subject`](#v4.1.1-plugins-outputs-email-subject)               | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`to`](#v4.1.1-plugins-outputs-email-to)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |
| [`use_tls`](#v4.1.1-plugins-outputs-email-use_tls)               | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`username`](#v4.1.1-plugins-outputs-email-username)             | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`via`](#v4.1.1-plugins-outputs-email-via)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`template_file`](#v4.1.1-plugins-outputs-email-template_file)   | [path](/docs/reference/logstash/plugins/value-types#path)       | No       |

Also see [Common options](#v4.1.1-plugins-outputs-email-common-options) for a list of options supported by all output plugins.

### `address`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

The address used to connect to the mail server

### `attachments`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

Attachments - specify the name(s) and location(s) of the files.

### `authentication`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Authentication method used when identifying with the server

### `body`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

Body for the email - plain text only.

### `cc`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The fully-qualified email address(es) to include as cc: address(es).
This field also accepts a comma-separated string of addresses, for example: `"me@example.com, you@example.com"`

### `bcc`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The fully-qualified email address(es) to include as bcc: address(es).
This field accepts several addresses like cc.

### `contenttype`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"text/html; charset=UTF-8"`

contenttype : for multipart messages, set the content-type and/or charset of the HTML part. NOTE: this may not be functional (KH)

### `debug`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Run the mail relay in debug mode

### `domain`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

The HELO/EHLO domain name used in the greeting message when connecting to a remote SMTP server. Some servers require this name to match the actual hostname of the connecting client.

### `from`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash.alert@example.com"`

The fully-qualified email address for the From: field in the email.

### `htmlbody`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

HTML Body for the email, which may contain HTML markup.

### `password`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Password to authenticate with the server

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `25`

Port used to communicate with the mail server

### `replyto`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The fully qualified email address for the Reply-To: field.

### `subject`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

Subject: for the email.

### `to`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The fully-qualified email address to send the email to.
This field also accepts a comma-separated string of addresses, for example: `"me@example.com, you@example.com"`
You can also use dynamic fields from the event with the `%{fieldname}` syntax.

### `use_tls`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Enables TLS when communicating with the server

### `username`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Username to authenticate with the server

### `via`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"smtp"`

How Logstash should send the email, either via SMTP or by invoking sendmail.

### `template_file`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

Path of a [Mustache templating](https://mustache.github.io/) file used for email templating. See example in test fixture. Can be used with `body` to send multi-part emails. Takes precedence over `htmlBody`.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                        | Input type                                                      | Required |
|----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v4.1.1-plugins-outputs-email-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v4.1.1-plugins-outputs-email-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v4.1.1-plugins-outputs-email-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 email outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  email {
    id => "my_plugin_id"
  }
}
```