﻿---
title: Elasticsearch filter plugin v4.1.0
description: Plugin version: v4.1.0, Released on: 2025-01-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v4-1-0-plugins-filters-elasticsearch
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch filter plugin v4.1.0
- Plugin version: v4.1.0
- Released on: 2025-01-23
- [Changelog](https://github.com/logstash-plugins/logstash-filter-elasticsearch/blob/v4.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/filter-elasticsearch-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-filter-elasticsearch). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Search Elasticsearch for a previous log event and copy some fields from it into the current event. Below are two complete examples of how this filter might be used.
The first example uses the legacy *query* parameter where the user is limited to an Elasticsearch query_string. Whenever logstash receives an "end" event, it uses this elasticsearch filter to find the matching "start" event based on some operation identifier. Then it copies the `@timestamp` field from the "start" event into a new field on the "end" event. Finally, using a combination of the "date" filter and the "ruby" filter, we calculate the time duration in hours between the two events.
```
if [type] == "end" {
   elasticsearch {
      hosts => ["es-server"]
      query => "type:start AND operation:%{[opid]}"
      fields => { "@timestamp" => "started" }
   }

   date {
      match => ["[started]", "ISO8601"]
      target => "[started]"
   }

   ruby {
      code => "event.set('duration_hrs', (event.get('@timestamp') - event.get('started')) / 3600)"
   }
}
```

The example below reproduces the above example but utilises the query_template. This query_template represents a full Elasticsearch query DSL and supports the standard Logstash field substitution syntax. The example below issues the same query as the first example but uses the template shown.
```
if [type] == "end" {
      elasticsearch {
         hosts => ["es-server"]
         query_template => "template.json"
         fields => { "@timestamp" => "started" }
      }

      date {
         match => ["[started]", "ISO8601"]
         target => "[started]"
      }

      ruby {
         code => "event.set('duration_hrs', (event.get('@timestamp') - event.get('started')) / 3600)"
      }
}
```

template.json:
```
{
  "size": 1,
  "sort" : [ { "@timestamp" : "desc" } ],
  "query": {
    "query_string": {
      "query": "type:start AND operation:%{[opid]}"
    }
  },
  "_source": ["@timestamp"]
}
```

As illustrated above, through the use of *opid*, fields from the Logstash events can be referenced within the template. The template will be populated per event prior to being used to query Elasticsearch.
Notice also that when you use `query_template`, the Logstash attributes `result_size` and `sort` will be ignored. They should be specified directly in the JSON template, as shown in the example above.

## Authentication

Authentication to a secure Elasticsearch cluster is possible using *one* of the following options:
- [`user`](#v4.1.0-plugins-filters-elasticsearch-user) AND [`password`](#v4.1.0-plugins-filters-elasticsearch-password)
- [`cloud_auth`](#v4.1.0-plugins-filters-elasticsearch-cloud_auth)
- [`api_key`](#v4.1.0-plugins-filters-elasticsearch-api_key)
- [`ssl_keystore_path`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_path) and/or [`ssl_keystore_password`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_password)


## Authorization

Authorization to a secure Elasticsearch cluster requires `read` permission at index level and `monitoring` permissions at cluster level. The `monitoring` permission at cluster level is necessary to perform periodic connectivity checks.

## Elasticsearch Filter Configuration Options

This plugin supports the following configuration options plus the [Common options](#v4.1.0-plugins-filters-elasticsearch-common-options) described later.
As of version `4.0.0` of this plugin, a number of previously deprecated settings related to SSL have been removed. Please see the [Elasticsearch Filter Obsolete Configuration Options](#v4.1.0-plugins-filters-elasticsearch-obsolete-options) for more details.

| Setting                                                                                            | Input type                                                                               | Required |
|----------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|----------|
| [`aggregation_fields`](#v4.1.0-plugins-filters-elasticsearch-aggregation_fields)                   | [hash](/docs/reference/logstash/plugins/value-types#hash)                                | No       |
| [`api_key`](#v4.1.0-plugins-filters-elasticsearch-api_key)                                         | [password](/docs/reference/logstash/plugins/value-types#password)                        | No       |
| [`ca_trusted_fingerprint`](#v4.1.0-plugins-filters-elasticsearch-ca_trusted_fingerprint)           | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`cloud_auth`](#v4.1.0-plugins-filters-elasticsearch-cloud_auth)                                   | [password](/docs/reference/logstash/plugins/value-types#password)                        | No       |
| [`cloud_id`](#v4.1.0-plugins-filters-elasticsearch-cloud_id)                                       | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`custom_headers`](#v4.1.0-plugins-filters-elasticsearch-custom_headers)                           | [hash](/docs/reference/logstash/plugins/value-types#hash)                                | No       |
| [`docinfo_fields`](#v4.1.0-plugins-filters-elasticsearch-docinfo_fields)                           | [hash](/docs/reference/logstash/plugins/value-types#hash)                                | No       |
| [`enable_sort`](#v4.1.0-plugins-filters-elasticsearch-enable_sort)                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                          | No       |
| [`fields`](#v4.1.0-plugins-filters-elasticsearch-fields)                                           | [array](/docs/reference/logstash/plugins/value-types#array)                              | No       |
| [`hosts`](#v4.1.0-plugins-filters-elasticsearch-hosts)                                             | [array](/docs/reference/logstash/plugins/value-types#array)                              | No       |
| [`index`](#v4.1.0-plugins-filters-elasticsearch-index)                                             | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`password`](#v4.1.0-plugins-filters-elasticsearch-password)                                       | [password](/docs/reference/logstash/plugins/value-types#password)                        | No       |
| [`proxy`](#v4.1.0-plugins-filters-elasticsearch-proxy)                                             | [uri](/docs/reference/logstash/plugins/value-types#uri)                                  | No       |
| [`query`](#v4.1.0-plugins-filters-elasticsearch-query)                                             | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`query_template`](#v4.1.0-plugins-filters-elasticsearch-query_template)                           | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`result_size`](#v4.1.0-plugins-filters-elasticsearch-result_size)                                 | [number](/docs/reference/logstash/plugins/value-types#number)                            | No       |
| [`retry_on_failure`](#v4.1.0-plugins-filters-elasticsearch-retry_on_failure)                       | [number](/docs/reference/logstash/plugins/value-types#number)                            | No       |
| [`retry_on_status`](#v4.1.0-plugins-filters-elasticsearch-retry_on_status)                         | [array](/docs/reference/logstash/plugins/value-types#array)                              | No       |
| [`sort`](#v4.1.0-plugins-filters-elasticsearch-sort)                                               | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`ssl_certificate`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate)                         | [path](/docs/reference/logstash/plugins/value-types#path)                                | No       |
| [`ssl_certificate_authorities`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate_authorities) | list of [path](/docs/reference/logstash/plugins/value-types#path)                        | No       |
| [`ssl_cipher_suites`](#v4.1.0-plugins-filters-elasticsearch-ssl_cipher_suites)                     | list of [string](/docs/reference/logstash/plugins/value-types#string)                    | No       |
| [`ssl_enabled`](#v4.1.0-plugins-filters-elasticsearch-ssl_enabled)                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                          | No       |
| [`ssl_key`](#v4.1.0-plugins-filters-elasticsearch-ssl_key)                                         | [path](/docs/reference/logstash/plugins/value-types#path)                                | No       |
| [`ssl_keystore_password`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_password)             | [password](/docs/reference/logstash/plugins/value-types#password)                        | No       |
| [`ssl_keystore_path`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_path)                     | [path](/docs/reference/logstash/plugins/value-types#path)                                | No       |
| [`ssl_keystore_type`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_type)                     | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`ssl_supported_protocols`](#v4.1.0-plugins-filters-elasticsearch-ssl_supported_protocols)         | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`ssl_truststore_password`](#v4.1.0-plugins-filters-elasticsearch-ssl_truststore_password)         | [password](/docs/reference/logstash/plugins/value-types#password)                        | No       |
| [`ssl_truststore_path`](#v4.1.0-plugins-filters-elasticsearch-ssl_truststore_path)                 | [path](/docs/reference/logstash/plugins/value-types#path)                                | No       |
| [`ssl_truststore_type`](#v4.1.0-plugins-filters-elasticsearch-ssl_truststore_type)                 | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`ssl_verification_mode`](#v4.1.0-plugins-filters-elasticsearch-ssl_verification_mode)             | [string](/docs/reference/logstash/plugins/value-types#string), one of `["full", "none"]` | No       |
| [`tag_on_failure`](#v4.1.0-plugins-filters-elasticsearch-tag_on_failure)                           | [array](/docs/reference/logstash/plugins/value-types#array)                              | No       |
| [`user`](#v4.1.0-plugins-filters-elasticsearch-user)                                               | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |

Also see [Common options](#v4.1.0-plugins-filters-elasticsearch-common-options) for a list of options supported by all filter plugins.

### `aggregation_fields`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Hash of aggregation names to copy from elasticsearch response into Logstash event fields
Example:
```
    filter {
      elasticsearch {
        aggregation_fields => {
          "my_agg_name" => "my_ls_field"
        }
      }
    }
```


### `api_key`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Authenticate using Elasticsearch API key. Note that this option also requires enabling the [`ssl_enabled`](#v4.1.0-plugins-filters-elasticsearch-ssl_enabled) option.
Format is `id:api_key` where `id` and `api_key` are as returned by the Elasticsearch [Create API key API](https://www.elastic.co/guide/en/elasticsearch/reference/current/security-api-create-api-key.html).

### `ca_trusted_fingerprint`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string), and must contain exactly 64 hexadecimal characters.
- There is no default value for this setting.
- Use of this option *requires* Logstash 8.3+

The SHA-256 fingerprint of an SSL Certificate Authority to trust, such as the autogenerated self-signed CA for an Elasticsearch cluster.

### `cloud_auth`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Cloud authentication string ("<username>:<password>" format) is an alternative for the `user`/`password` pair.
For more info, check out the [Logstash-to-Cloud documentation](https://www.elastic.co/guide/en/logstash/current/connecting-to-cloud.html).

### `cloud_id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Cloud ID, from the Elastic Cloud web console. If set `hosts` should not be used.
For more info, check out the [Logstash-to-Cloud documentation](https://www.elastic.co/guide/en/logstash/current/connecting-to-cloud.html).

### `custom_headers`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is empty

Pass a set of key value pairs as the headers sent in each request to Elasticsearch. These custom headers will override any headers previously set by the plugin such as the User Agent or Authorization headers.

### `docinfo_fields`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Hash of docinfo fields to copy from old event (found via elasticsearch) into new event
Example:
```
    filter {
      elasticsearch {
        docinfo_fields => {
          "_id" => "document_id"
          "_index" => "document_index"
        }
      }
    }
```


### `enable_sort`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Whether results should be sorted or not

### `fields`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `{}`

An array of fields to copy from the old event (found via elasticsearch) into the new event, currently being processed.
In the following example, the values of `@timestamp` and `event_id` on the event found via elasticsearch are copied to the current event’s `started` and `start_id` fields, respectively:
```
fields => {
  "@timestamp" => "started"
  "event_id" => "start_id"
}
```


### `hosts`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["localhost:9200"]`

List of elasticsearch hosts to use for querying.

### `index`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

Comma-delimited list of index names to search; use `_all` or empty string to perform the operation on all indices. Field substitution (e.g. `index-name-%{date_field}`) is available

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Basic Auth - password

### `proxy`

- Value type is [uri](/docs/reference/logstash/plugins/value-types#uri)
- There is no default value for this setting.

Set the address of a forward HTTP proxy. An empty string is treated as if proxy was not set, and is useful when using environment variables e.g. `proxy => '${LS_PROXY:}'`.

### `query`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Elasticsearch query string. More information is available in the [Elasticsearch query string documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-query-string-query.html#query-string-syntax). Use either `query` or `query_template`.

### `query_template`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

File path to elasticsearch query in DSL format. More information is available in the [Elasticsearch query documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html). Use either `query` or `query_template`.

### `result_size`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

How many results to return

### `retry_on_failure`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0` (retries disabled)

How many times to retry an individual failed request.
When enabled, retry requests that result in connection errors or an HTTP status code included in [`retry_on_status`](#v4.1.0-plugins-filters-elasticsearch-retry_on_status)

### `retry_on_status`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is an empty list `[]`

Which HTTP Status codes to consider for retries (in addition to connection errors) when using [`retry_on_failure`](#v4.1.0-plugins-filters-elasticsearch-retry_on_failure),

### `sort`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"@timestamp:desc"`

Comma-delimited list of `<field>:<direction>` pairs that define the sort order

### `ssl_certificate`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL certificate to use to authenticate the client. This certificate should be an OpenSSL-style X.509 certificate file.
This setting can be used only if [`ssl_key`](#v4.1.0-plugins-filters-elasticsearch-ssl_key) is set.

### `ssl_certificate_authorities`

- Value type is a list of [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting

The .cer or .pem files to validate the server’s certificate.
You cannot use this setting and [`ssl_truststore_path`](#v4.1.0-plugins-filters-elasticsearch-ssl_truststore_path) at the same time.

### `ssl_cipher_suites`

- Value type is a list of [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting

The list of cipher suites to use, listed by priorities. Supported cipher suites vary depending on the Java and protocol versions.

### `ssl_enabled`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- There is no default value for this setting.

Enable SSL/TLS secured communication to Elasticsearch cluster. Leaving this unspecified will use whatever scheme is specified in the URLs listed in [`hosts`](#v4.1.0-plugins-filters-elasticsearch-hosts) or extracted from the [`cloud_id`](#v4.1.0-plugins-filters-elasticsearch-cloud_id). If no explicit protocol is specified plain HTTP will be used.

### `ssl_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

OpenSSL-style RSA private key that corresponds to the [`ssl_certificate`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate).
This setting can be used only if [`ssl_certificate`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate) is set.

### `ssl_keystore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Set the keystore password

### `ssl_keystore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The keystore used to present a certificate to the server. It can be either `.jks` or `.p12`
You cannot use this setting and [`ssl_certificate`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate) at the same time.

### `ssl_keystore_type`

- Value can be any of: `jks`, `pkcs12`
- If not provided, the value will be inferred from the keystore filename.

The format of the keystore file. It must be either `jks` or `pkcs12`.

### `ssl_supported_protocols`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Allowed values are: `'TLSv1.1'`, `'TLSv1.2'`, `'TLSv1.3'`
- Default depends on the JDK being used. With up-to-date Logstash, the default is `['TLSv1.2', 'TLSv1.3']`. `'TLSv1.1'` is not considered secure and is only provided for legacy applications.

List of allowed SSL/TLS versions to use when establishing a connection to the Elasticsearch cluster.
For Java 8 `'TLSv1.3'` is supported only since **8u262** (AdoptOpenJDK), but requires that you set the `LS_JAVA_OPTS="-Djdk.tls.client.protocols=TLSv1.3"` system property in Logstash.
If you configure the plugin to use `'TLSv1.1'` on any recent JVM, such as the one packaged with Logstash, the protocol is disabled by default and needs to be enabled manually by changing `jdk.tls.disabledAlgorithms` in the **$JDK_HOME/conf/security/java.security** configuration file. That is, `TLSv1.1` needs to be removed from the list.

### `ssl_truststore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Set the truststore password

### `ssl_truststore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The truststore to validate the server’s certificate. It can be either `.jks` or `.p12`.
You cannot use this setting and [`ssl_certificate_authorities`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate_authorities) at the same time.

### `ssl_truststore_type`

- Value can be any of: `jks`, `pkcs12`
- If not provided, the value will be inferred from the truststore filename.

The format of the truststore file. It must be either `jks` or `pkcs12`.

### `ssl_verification_mode`

- Value can be any of: `full`, `none`
- Default value is `full`

Defines how to verify the certificates presented by another party in the TLS connection:
`full` validates that the server certificate has an issue date that’s within the not_before and not_after dates; chains to a trusted Certificate Authority (CA), and has a hostname or IP address that matches the names within the certificate.
`none` performs no certificate validation.
Setting certificate verification to `none` disables many security benefits of SSL/TLS, which is very dangerous. For more information on disabling certificate verification please read 

### `tag_on_failure`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["_elasticsearch_lookup_failure"]`

Tags the event on failure to look up previous log event information. This can be used in later analysis.

### `user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Basic Auth - username

## Elasticsearch Filter Obsolete Configuration Options

As of version `4.0.0` of this plugin, some configuration options have been replaced. The plugin will fail to start if it contains any of these obsolete options.

| Setting                                                                                            | Replaced by                                                                            | ca_file                                                                        |
|----------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------|--------------------------------------------------------------------------------|
| [`ssl_certificate_authorities`](#v4.1.0-plugins-filters-elasticsearch-ssl_certificate_authorities) | keystore                                                                               | [`ssl_keystore_path`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_path) |
| keystore_password                                                                                  | [`ssl_keystore_password`](#v4.1.0-plugins-filters-elasticsearch-ssl_keystore_password) | ssl                                                                            |


## Common options

These configuration options are supported by all filter plugins:

| Setting                                                                  | Input type                                                      | Required |
|--------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v4.1.0-plugins-filters-elasticsearch-add_field)           | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`add_tag`](#v4.1.0-plugins-filters-elasticsearch-add_tag)               | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`enable_metric`](#v4.1.0-plugins-filters-elasticsearch-enable_metric)   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v4.1.0-plugins-filters-elasticsearch-id)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`periodic_flush`](#v4.1.0-plugins-filters-elasticsearch-periodic_flush) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`remove_field`](#v4.1.0-plugins-filters-elasticsearch-remove_field)     | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`remove_tag`](#v4.1.0-plugins-filters-elasticsearch-remove_tag)         | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

If this filter is successful, add any arbitrary fields to this event. Field names can be dynamic and include parts of the event using the `%{field}`.
Example:
```
    filter {
      elasticsearch {
        add_field => { "foo_%{somefield}" => "Hello world, from %{host}" }
      }
    }
```

```
    # You can also add multiple fields at once:
    filter {
      elasticsearch {
        add_field => {
          "foo_%{somefield}" => "Hello world, from %{host}"
          "new_field" => "new_static_value"
        }
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add field `foo_hello` if it is present, with the value above and the `%{host}` piece replaced with that value from the event. The second example would also add a hardcoded field.

### `add_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, add arbitrary tags to the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      elasticsearch {
        add_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also add multiple tags at once:
    filter {
      elasticsearch {
        add_tag => [ "foo_%{somefield}", "taggedy_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add a tag `foo_hello` (and the second example would of course add a `taggedy_tag` tag).

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 elasticsearch filters. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
    filter {
      elasticsearch {
        id => "ABC"
      }
    }
```


### `periodic_flush`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Call the filter flush method at regular interval. Optional.

### `remove_field`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary fields from this event. Fields names can be dynamic and include parts of the event using the %{field} Example:
```
    filter {
      elasticsearch {
        remove_field => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple fields at once:
    filter {
      elasticsearch {
        remove_field => [ "foo_%{somefield}", "my_extraneous_field" ]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the field with name `foo_hello` if it is present. The second example would remove an additional, non-dynamic field.

### `remove_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary tags from the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      elasticsearch {
        remove_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple tags at once:
    filter {
      elasticsearch {
        remove_tag => [ "foo_%{somefield}", "sad_unwanted_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the tag `foo_hello` if it is present. The second example would remove a sad, unwanted tag as well.