﻿---
title: Hipchat output plugin v4.0.5
description: Plugin version: v4.0.5, Released on: 2018-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v4-0-5-plugins-outputs-hipchat
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Hipchat output plugin v4.0.5
- Plugin version: v4.0.5
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-output-hipchat/blob/v4.0.5/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-hipchat-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-hipchat). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output allows you to write events to [HipChat](https://www.hipchat.com/).
Make sure your API token have the appropriate permissions and support sending messages.

## Hipchat Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v4.0.5-plugins-outputs-hipchat-common-options) described later.

| Setting                                                            | Input type                                                                               | Required |
|--------------------------------------------------------------------|------------------------------------------------------------------------------------------|----------|
| [`color`](#v4.0.5-plugins-outputs-hipchat-color)                   | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`format`](#v4.0.5-plugins-outputs-hipchat-format)                 | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`from`](#v4.0.5-plugins-outputs-hipchat-from)                     | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`host`](#v4.0.5-plugins-outputs-hipchat-host)                     | [string](/docs/reference/logstash/plugins/value-types#string)                            | No       |
| [`message_format`](#v4.0.5-plugins-outputs-hipchat-message_format) | [string](/docs/reference/logstash/plugins/value-types#string), one of `["html", "text"]` | No       |
| [`room_id`](#v4.0.5-plugins-outputs-hipchat-room_id)               | [string](/docs/reference/logstash/plugins/value-types#string)                            | Yes      |
| [`token`](#v4.0.5-plugins-outputs-hipchat-token)                   | [string](/docs/reference/logstash/plugins/value-types#string)                            | Yes      |
| [`trigger_notify`](#v4.0.5-plugins-outputs-hipchat-trigger_notify) | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                          | No       |

Also see [Common options](#v4.0.5-plugins-outputs-hipchat-common-options) for a list of options supported by all output plugins.

### `color`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"yellow"`

Background color for message. HipChat currently supports one of "yellow", "red", "green", "purple", "gray", or "random". (default: yellow), support fieldref

### `format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"%{message}"`

Message format to send, event tokens are usable here.

### `from`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"logstash"`

The name the message will appear be sent from, you can use fieldref

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

HipChat host to use

### `message_format`

- Value can be any of: `html`, `text`
- Default value is `"html"`

Specify `Message Format`

### `room_id`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The ID or name of the room, support fieldref

### `token`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The HipChat authentication token.

### `trigger_notify`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Whether or not this message should trigger a notification for people in the room.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                          | Input type                                                      | Required |
|------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v4.0.5-plugins-outputs-hipchat-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v4.0.5-plugins-outputs-hipchat-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v4.0.5-plugins-outputs-hipchat-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 hipchat outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  hipchat {
    id => "my_plugin_id"
  }
}
```