﻿---
title: File output plugin v4.0.2
description: Plugin version: v4.0.2, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v4-0-2-plugins-outputs-file
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# File output plugin v4.0.2
- Plugin version: v4.0.2
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-output-file/blob/v4.0.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-file-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-file). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output writes events to files on disk. You can use fields from the event as parts of the filename and/or path.
By default, this output writes one event per line in **json** format. You can customise the line format using the `line` codec like
```
output {
 file {
   path => ...
   codec => line { format => "custom format: %{message}"}
 }
}
```


## File Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v4.0.2-plugins-outputs-file-common-options) described later.

| Setting                                                               | Input type                                                      | Required |
|-----------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`create_if_deleted`](#v4.0.2-plugins-outputs-file-create_if_deleted) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`dir_mode`](#v4.0.2-plugins-outputs-file-dir_mode)                   | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`file_mode`](#v4.0.2-plugins-outputs-file-file_mode)                 | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`filename_failure`](#v4.0.2-plugins-outputs-file-filename_failure)   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`flush_interval`](#v4.0.2-plugins-outputs-file-flush_interval)       | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`gzip`](#v4.0.2-plugins-outputs-file-gzip)                           | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`path`](#v4.0.2-plugins-outputs-file-path)                           | [string](/docs/reference/logstash/plugins/value-types#string)   | Yes      |

Also see [Common options](#v4.0.2-plugins-outputs-file-common-options) for a list of options supported by all output plugins.

### `create_if_deleted`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

If the configured file is deleted, but an event is handled by the plugin, the plugin will recreate the file. Default ⇒ true

### `dir_mode`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `-1`

Dir access mode to use. Note that due to the bug in jruby system umask is ignored on linux:  Setting it to -1 uses default OS value. Example: `"dir_mode" => 0750`

### `file_mode`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `-1`

File access mode to use. Note that due to the bug in jruby system umask is ignored on linux:  Setting it to -1 uses default OS value. Example: `"file_mode" => 0640`

### `filename_failure`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"_filepath_failures"`

If the generated path is invalid, the events will be saved into this file and inside the defined path.

### `flush_interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `2`

Flush interval (in seconds) for flushing writes to log files. 0 will flush on every message.

### `gzip`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Gzip the output stream before writing to disk.

### `path`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The path to the file to write. Event fields can be used here, like `/var/log/logstash/%{host}/%{application}` One may also utilize the path option for date-based log rotation via the joda time format. This will use the event timestamp. E.g.: `path => "./test-%{+YYYY-MM-dd}.txt"` to create `./test-2013-05-29.txt`
If you use an absolute path you cannot start with a dynamic string. E.g: `/%{myfield}/`, `/test-%{myfield}/` are not valid paths

## Common options

These configuration options are supported by all output plugins:

| Setting                                                       | Input type                                                      | Required |
|---------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v4.0.2-plugins-outputs-file-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v4.0.2-plugins-outputs-file-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v4.0.2-plugins-outputs-file-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 file outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  file {
    id => "my_plugin_id"
  }
}
```