﻿---
title: Avro codec plugin v3.5.0
description: Plugin version: v3.5.0, Released on: 2025-11-26, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-5-0-plugins-codecs-avro
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Avro codec plugin v3.5.0
- Plugin version: v3.5.0
- Released on: 2025-11-26
- [Changelog](https://github.com/logstash-plugins/logstash-codec-avro/blob/v3.5.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-avro-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-avro). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Read serialized Avro records as Logstash events
This plugin is used to serialize Logstash events as Avro datums, as well as deserializing Avro datums into Logstash events.

## Event Metadata and the Elastic Common Schema (ECS)

The plugin behaves the same regardless of ECS compatibility, except adding the original message to `[event][original]`.

## Encoding

This codec is for serializing individual Logstash events as Avro datums that are Avro binary blobs. It does not encode Logstash events into an Avro file.

## Decoding

This codec is for deserializing individual Avro records. It is not for reading Avro files. Avro files have a unique format that must be handled upon input.
Partial deserialization
Avro format is known to support partial deserialization of arbitrary fields, providing a schema containing a subset of the schema which was used to serialize the data. This codec **doesn’t support partial deserialization of arbitrary fields**. Partial deserialization *might* work only when providing a schema which contains the first `N` fields of the schema used to serialize the data (and in the same order).

## Usage

Example usage with Kafka input.
```
input {
  kafka {
    codec => avro {
        schema_uri => "/tmp/schema.avsc"
    }
  }
}
filter {
  ...
}
output {
  ...
}
```


## Avro Codec Configuration Options


| Setting                                                                                  | Input type                                                                                   | Required |
|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------|----------|
| [`ecs_compatibility`](#v3.5.0-plugins-codecs-avro-ecs_compatibility)                     | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |
| [`encoding`](#v3.5.0-plugins-codecs-avro-encoding)                                       | [string](/docs/reference/logstash/plugins/value-types#string), one of `["binary", "base64"]` | No       |
| [`password`](#v3.5.0-plugins-codecs-avro-password)                                       | [password](/docs/reference/logstash/plugins/value-types#password)                            | No       |
| [`proxy`](#v3.5.0-plugins-codecs-avro-proxy)                                             | [uri](/docs/reference/logstash/plugins/value-types#uri)                                      | No       |
| [`schema_uri`](#v3.5.0-plugins-codecs-avro-schema_uri)                                   | [string](/docs/reference/logstash/plugins/value-types#string)                                | Yes      |
| [`ssl_certificate`](#v3.5.0-plugins-codecs-avro-ssl_certificate)                         | [path](/docs/reference/logstash/plugins/value-types#path)                                    | No       |
| [`ssl_certificate_authorities`](#v3.5.0-plugins-codecs-avro-ssl_certificate_authorities) | list of [path](/docs/reference/logstash/plugins/value-types#path)                            | No       |
| [`ssl_cipher_suites`](#v3.5.0-plugins-codecs-avro-ssl_cipher_suites)                     | [array](/docs/reference/logstash/plugins/value-types#array)                                  | No       |
| [`ssl_enabled`](#v3.5.0-plugins-codecs-avro-ssl_enabled)                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                              | No       |
| [`ssl_key`](#v3.5.0-plugins-codecs-avro-ssl_key)                                         | [path](/docs/reference/logstash/plugins/value-types#path)                                    | No       |
| [`ssl_keystore_password`](#v3.5.0-plugins-codecs-avro-ssl_keystore_password)             | [password](/docs/reference/logstash/plugins/value-types#password)                            | No       |
| [`ssl_keystore_path`](#v3.5.0-plugins-codecs-avro-ssl_keystore_path)                     | [path](/docs/reference/logstash/plugins/value-types#path)                                    | No       |
| [`ssl_keystore_type`](#v3.5.0-plugins-codecs-avro-ssl_keystore_type)                     | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |
| [`ssl_supported_protocols`](#v3.5.0-plugins-codecs-avro-ssl_supported_protocols)         | [array](/docs/reference/logstash/plugins/value-types#array)                                  | No       |
| [`ssl_truststore_password`](#v3.5.0-plugins-codecs-avro-ssl_truststore_password)         | [password](/docs/reference/logstash/plugins/value-types#password)                            | No       |
| [`ssl_truststore_path`](#v3.5.0-plugins-codecs-avro-ssl_truststore_path)                 | [path](/docs/reference/logstash/plugins/value-types#path)                                    | No       |
| [`ssl_truststore_type`](#v3.5.0-plugins-codecs-avro-ssl_truststore_type)                 | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |
| [`ssl_verification_mode`](#v3.5.0-plugins-codecs-avro-ssl_verification_mode)             | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |
| [`tag_on_failure`](#v3.5.0-plugins-codecs-avro-tag_on_failure)                           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                              | No       |
| [`target`](#v3.5.0-plugins-codecs-avro-target)                                           | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |
| [`username`](#v3.5.0-plugins-codecs-avro-username)                                       | [string](/docs/reference/logstash/plugins/value-types#string)                                | No       |


### `ecs_compatibility`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `disabled`: Avro data added at root level
- `v1`,`v8`: Elastic Common Schema compliant behavior (`[event][original]` is also added)

Controls this plugin’s compatibility with the [Elastic Common Schema (ECS)](https://www.elastic.co/guide/en/ecs/current).

### `encoding`

- Value can be any of: `binary`, `base64`
- Default value is `base64`

Set encoding for Avro’s payload. Use `base64` (default) to indicate that this codec sends or expects to receive base64-encoded bytes.
Set this option to `binary` to indicate that this codec sends or expects to receive binary Avro data.

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Password for HTTP basic authentication when fetching remote schemas. Used together with `username`.

### `proxy`

- Value type is [uri](/docs/reference/logstash/plugins/value-types#uri)
- There is no default value for this setting.

The address of a forward HTTP proxy to use when contacting a remote schema registry.

### `schema_uri`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

schema path to fetch the schema from. This can be a *http* or *file* scheme URI example:
- http - `http://example.com/schema.avsc`
- file - `/path/to/schema.avsc`


### `tag_on_failure`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

tag events with `_avroparsefailure` when decode fails

### `ssl_certificate`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

Path to PEM encoded certificate file for client authentication (mutual TLS). You may use this setting or [`ssl_keystore_path`](#v3.5.0-plugins-codecs-avro-ssl_keystore_path), but not both simultaneously.
**Example**
```
ssl_certificate => "/path/to/client.crt"
```


### `ssl_certificate_authorities`

- Value type is a list of [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

Path to PEM encoded CA certificate file(s) for server verification. This is an alternative to using [`ssl_truststore_path`](#v3.5.0-plugins-codecs-avro-ssl_truststore_path). You may use this setting or [`ssl_truststore_path`](#v3.5.0-plugins-codecs-avro-ssl_truststore_path), but not both simultaneously.
**Example**
```
ssl_certificate_authorities => ["/path/to/ca.crt"]
```


### `ssl_cipher_suites`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

The list of cipher suites to use, listed by priorities. Supported cipher suites vary depending on which version of Java is used.

### `ssl_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

Path to PEM encoded private key file for client authentication. Must be used together with [`ssl_certificate`](#v3.5.0-plugins-codecs-avro-ssl_certificate). The private key must be unencrypted (passphrase-protected keys are not supported).
**Example**
```
ssl_key => "/path/to/client.key"
```


### `ssl_enabled`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- There is no default value for this setting.

Enable SSL/TLS secured communication to remote schema registry. When using HTTPS schema URIs, SSL is automatically enabled.

### `ssl_keystore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The path to the JKS or PKCS12 keystore file for client certificate authentication. Use this when the schema registry requires mutual TLS (mTLS) authentication.

### `ssl_keystore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

The password for the keystore file specified in [`ssl_keystore_path`](#v3.5.0-plugins-codecs-avro-ssl_keystore_path).

### `ssl_keystore_type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The format of the keystore file. It must be either `jks` or `pkcs12`.

### `ssl_supported_protocols`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]` (uses Java defaults)
- Valid values are: `TLSv1.1`, `TLSv1.2`, `TLSv1.3`

List of allowed SSL/TLS protocol versions. When not specified, the JVM defaults are used.

### `ssl_truststore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The path to the JKS or PKCS12 truststore file containing certificates to verify the schema registry server’s certificate.
**Example**
```
input {
  kafka {
    codec => avro {
        schema_uri => "https://schema-registry.example.com:8081/schemas/ids/1"
        ssl_truststore_path => "/path/to/truststore.jks"
        ssl_truststore_password => "${TRUSTSTORE_PASSWORD}"
    }
  }
}
```


### `ssl_truststore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

The password for the truststore file specified in [`ssl_truststore_path`](#v3.5.0-plugins-codecs-avro-ssl_truststore_path).

### `ssl_truststore_type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The format of the truststore file. It must be either `jks` or `pkcs12`.

### `ssl_verification_mode`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"full"`
- Valid options are: `full`, `none`

Options to verify the server’s certificate:
- `full`: Validates that the provided certificate has an issue date that’s within the not_before and not_after dates; chains to a trusted Certificate Authority (CA); has a hostname or IP address that matches the names within the certificate. (recommended)
- `none`: Performs no certificate validation. **Warning:** Disabling this severely compromises security ()

**Example**
```
input {
  kafka {
    codec => avro {
        schema_uri => "https://schema-registry.example.com:8081/schemas/ids/1"
        ssl_certificate_authorities => ["/path/to/ca.crt"]
        ssl_verification_mode => "full"
    }
  }
}
```


### `target`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.
- This is only relevant when decode data into an event

Define the target field for placing the values. If this setting is not set, the Avro data will be stored at the root (top level) of the event.
**Example**
```
input {
  kafka {
    codec => avro {
        schema_uri => "/tmp/schema.avsc"
        target => "[document]"
    }
  }
}
```


### `username`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Username for HTTP basic authentication when fetching remote schemas. Used together with `password`.
**Example**
```
input {
  kafka {
    codec => avro {
        schema_uri => "https://schema-registry.example.com:8081/schemas/ids/1"
        username => "registry_user"
        password => "${REGISTRY_PASSWORD}"
    }
  }
}
```