﻿---
title: Exec input plugin v3.4.0
description: Plugin version: v3.4.0, Released on: 2021-11-16, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-4-0-plugins-inputs-exec
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Exec input plugin v3.4.0
- Plugin version: v3.4.0
- Released on: 2021-11-16
- [Changelog](https://github.com/logstash-plugins/logstash-input-exec/blob/v3.4.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-exec-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-exec). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Periodically run a shell command and capture the whole output as an event.
- The `command` field of this event will be the command run.
- The `message` field of this event will be the entire stdout of the command.

The exec input ultimately uses `fork` to spawn a child process. Using fork duplicates the parent process address space (in our case, **logstash and the JVM**); this is mitigated with OS copy-on-write but ultimately you can end up allocating lots of memory just for a "simple" executable. If the exec input fails with errors like `ENOMEM: Cannot allocate memory` it is an indication that there is not enough non-JVM-heap physical memory to perform the fork.
Example:
```
input {
  exec {
    command => "echo 'hi!'"
    interval => 30
  }
}
```

This will execute `echo` command every 30 seconds.

## Compatibility with the Elastic Common Schema (ECS)

This plugin adds metadata about the event’s source, and can be configured to do so in an [ECS-compatible](https://www.elastic.co/guide/en/ecs/current) way with [`ecs_compatibility`](#v3.4.0-plugins-inputs-exec-ecs_compatibility). This metadata is added after the event has been decoded by the appropriate codec, and will not overwrite existing values.

| ECS Disabled               | ECS v1 , v8                                       | Description                                                         |
|----------------------------|---------------------------------------------------|---------------------------------------------------------------------|
| `host`                     | `[host][name]`                                    | The name of the Logstash host that processed the event              |
| `command`                  | `[process][command_line]`                         | The command run by the plugin                                       |
| `[@metadata][exit_status]` | `[process][exit_code]`                            | The exit code of the process                                        |
| —                          | `[@metadata][input][exec][process][elapsed_time]` | The elapsed time the command took to run in nanoseconds             |
| `[@metadata][duration]`    | —                                                 | Command duration in seconds as a floating point number (deprecated) |


## Exec Input configuration options

This plugin supports the following configuration options plus the [Common options](#v3.4.0-plugins-inputs-exec-common-options) described later.

| Setting                                                              | Input type                                                    | Required |
|----------------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`command`](#v3.4.0-plugins-inputs-exec-command)                     | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`ecs_compatibility`](#v3.4.0-plugins-inputs-exec-ecs_compatibility) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`interval`](#v3.4.0-plugins-inputs-exec-interval)                   | [number](/docs/reference/logstash/plugins/value-types#number) | No       |
| [`schedule`](#v3.4.0-plugins-inputs-exec-schedule)                   | [string](/docs/reference/logstash/plugins/value-types#string) | No       |

Also see [Common options](#v3.4.0-plugins-inputs-exec-common-options) for a list of options supported by all input plugins.

### `command`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Command to run. For example, `uptime`

### `ecs_compatibility`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `disabled`: uses backwards compatible field names, such as `[host]`
- `v1`, `v8`: uses fields that are compatible with ECS, such as `[host][name]`

Controls this plugin’s compatibility with the [Elastic Common Schema (ECS)](https://www.elastic.co/guide/en/ecs/current). See [Compatibility with the Elastic Common Schema (ECS)](#v3.4.0-plugins-inputs-exec-ecs) for detailed information.
**Sample output: ECS enabled**
```
{
    "message" => "hi!\n",
    "process" => {
        "command_line" => "echo 'hi!'",
        "exit_code" => 0
    },
    "host" => {
        "name" => "deus-ex-machina"
    },

    "@metadata" => {
        "input" => {
            "exec" => {
                "process" => {
                    "elapsed_time"=>3042
                }
            }
        }
    }
}
```

**Sample output: ECS disabled**
```
{
    "message" => "hi!\n",
    "command" => "echo 'hi!'",
    "host" => "deus-ex-machina",

    "@metadata" => {
        "exit_status" => 0,
        "duration" => 0.004388
    }
}
```


### `interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

Interval to run the command. Value is in seconds.
Either `interval` or `schedule` option must be defined.

### `schedule`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Schedule of when to periodically run command.
This scheduling syntax is powered by [rufus-scheduler](https://github.com/jmettraux/rufus-scheduler). The syntax is cron-like with some extensions specific to Rufus (e.g. timezone support).
Examples:

|                             |                                                                      |
|-----------------------------|----------------------------------------------------------------------|
| `* 5 * 1-3 *`               | will execute every minute of 5am every day of January through March. |
| `0 * * * *`                 | will execute on the 0th minute of every hour every day.              |
| `0 6 * * * America/Chicago` | will execute at 6:00am (UTC/GMT -5) every day.                       |

Further documentation describing this syntax can be found [here](https://github.com/jmettraux/rufus-scheduler#parsing-cronlines-and-time-strings).
Either `interval` or `schedule` option must be defined.

## Common options

These configuration options are supported by all input plugins:

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.4.0-plugins-inputs-exec-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.4.0-plugins-inputs-exec-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.4.0-plugins-inputs-exec-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.4.0-plugins-inputs-exec-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.4.0-plugins-inputs-exec-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.4.0-plugins-inputs-exec-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 exec inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  exec {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.