﻿---
title: Gelf input plugin v3.3.1
description: Plugin version: v3.3.1, Released on: 2021-12-21, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-3-1-plugins-inputs-gelf
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Gelf input plugin v3.3.1
- Plugin version: v3.3.1
- Released on: 2021-12-21
- [Changelog](https://github.com/logstash-plugins/logstash-input-gelf/blob/v3.3.1/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-gelf-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-gelf). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This input will read GELF messages as events over the network, making it a good choice if you already use Graylog2 today.
The main use case for this input is to leverage existing GELF logging libraries such as the GELF log4j appender.

## Gelf Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.3.1-plugins-inputs-gelf-common-options) described later.

| Setting                                                                            | Input type                                                      | Required |
|------------------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`host`](#v3.3.1-plugins-inputs-gelf-host)                                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`use_udp`](#v3.3.1-plugins-inputs-gelf-use_udp)                                   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`use_tcp`](#v3.3.1-plugins-inputs-gelf-use_tcp)                                   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`port`](#v3.3.1-plugins-inputs-gelf-port)                                         | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`port_tcp`](#v3.3.1-plugins-inputs-gelf-port_tcp)                                 | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`port_udp`](#v3.3.1-plugins-inputs-gelf-port_udp)                                 | [number](/docs/reference/logstash/plugins/value-types#number)   | No       |
| [`remap`](#v3.3.1-plugins-inputs-gelf-remap)                                       | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`strip_leading_underscore`](#v3.3.1-plugins-inputs-gelf-strip_leading_underscore) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |

Also see [Common options](#v3.3.1-plugins-inputs-gelf-common-options) for a list of options supported by all input plugins.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

The IP address or hostname to listen on.

### `use_udp`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Whether to listen for gelf messages sent over udp

### `use_tcp`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Whether to listen for gelf messages sent over tcp

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `12201`

The port to listen on. Remember that ports less than 1024 (privileged ports) may require root to use. port_tcp and port_udp can be used to set a specific port for each protocol.

### `port_tcp`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

Tcp port to listen on. Use port instead of this setting unless you need a different port for udp than tcp

### `port_udp`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

Udp port to listen on. Use port instead of this setting unless you need a different port for udp than tcp

### `remap`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Whether or not to remap the GELF message fields to Logstash event fields or leave them intact.
Remapping converts the following GELF fields to Logstash equivalents:
- `full_message` becomes `event.get("message")`.
- if there is no `full_message`, `short_message` becomes `event.get("message")`.


### `strip_leading_underscore`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Whether or not to remove the leading `_` in GELF fields or leave them in place. (Logstash < 1.2 did not remove them by default.). Note that GELF version 1.1 format now requires all non-standard fields to be added as an "additional" field, beginning with an underscore.
e.g. `_foo` becomes `foo`

## Common options

These configuration options are supported by all input plugins:

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.3.1-plugins-inputs-gelf-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.3.1-plugins-inputs-gelf-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.3.1-plugins-inputs-gelf-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.3.1-plugins-inputs-gelf-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.3.1-plugins-inputs-gelf-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.3.1-plugins-inputs-gelf-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 gelf inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  gelf {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.