﻿---
title: Elasticsearch filter plugin v3.3.1
description: Plugin version: v3.3.1, Released on: 2018-05-08, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-3-1-plugins-filters-elasticsearch
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch filter plugin v3.3.1
- Plugin version: v3.3.1
- Released on: 2018-05-08
- [Changelog](https://github.com/logstash-plugins/logstash-filter-elasticsearch/blob/v3.3.1/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/filter-elasticsearch-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-filter-elasticsearch). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Compatibility Note
Starting with Elasticsearch 5.3, there’s an [HTTP setting](https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-http.html) called `http.content_type.required`. If this option is set to `true`, and you are using Logstash 2.4 through 5.2, you need to update the Elasticsearch filter plugin to version 3.1.1 or higher.
Search Elasticsearch for a previous log event and copy some fields from it into the current event. Below are two complete examples of how this filter might be used.
The first example uses the legacy *query* parameter where the user is limited to an Elasticsearch query_string. Whenever logstash receives an "end" event, it uses this elasticsearch filter to find the matching "start" event based on some operation identifier. Then it copies the `@timestamp` field from the "start" event into a new field on the "end" event. Finally, using a combination of the "date" filter and the "ruby" filter, we calculate the time duration in hours between the two events.
```
if [type] == "end" {
   elasticsearch {
      hosts => ["es-server"]
      query => "type:start AND operation:%{[opid]}"
      fields => { "@timestamp" => "started" }
   }

   date {
      match => ["[started]", "ISO8601"]
      target => "[started]"
   }

   ruby {
      code => "event.set('duration_hrs', (event.get('@timestamp') - event.get('started')) / 3600)"
   }
}
```

The example below reproduces the above example but utilises the query_template. This query_template represents a full Elasticsearch query DSL and supports the standard Logstash field substitution syntax. The example below issues the same query as the first example but uses the template shown.
```
if [type] == "end" {
      elasticsearch {
         hosts => ["es-server"]
         query_template => "template.json"
         fields => { "@timestamp" => "started" }
      }

      date {
         match => ["[started]", "ISO8601"]
         target => "[started]"
      }

      ruby {
         code => "event.set('duration_hrs', (event.get('@timestamp') - event.get('started')) / 3600)"
      }
}
```

template.json:
```
 {
    "query": {
      "query_string": {
       "query": "type:start AND operation:%{[opid]}"
      }
    },
   "_source": ["@timestamp"]
 }
```

As illustrated above, through the use of *opid*, fields from the Logstash events can be referenced within the template. The template will be populated per event prior to being used to query Elasticsearch.
Note that when you use `query_template`, the Logstash attributes `result_size` and `sort` will be ignored. They should be specified directly in the JSON template. Example:
```
{
  "size": 1,
  "sort" : [ { "@timestamp" : "desc" } ],
  "query": {
    "query_string": {
      "query": "type:start AND operation:%{[opid]}"
    }
  },
  "_source": ["@timestamp"]
}
```


## Elasticsearch Filter Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.3.1-plugins-filters-elasticsearch-common-options) described later.

| Setting                                                                          | Input type                                                        | Required |
|----------------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`aggregation_fields`](#v3.3.1-plugins-filters-elasticsearch-aggregation_fields) | [hash](/docs/reference/logstash/plugins/value-types#hash)         | No       |
| [`ca_file`](#v3.3.1-plugins-filters-elasticsearch-ca_file)                       | a valid filesystem path                                           | No       |
| [`docinfo_fields`](#v3.3.1-plugins-filters-elasticsearch-docinfo_fields)         | [hash](/docs/reference/logstash/plugins/value-types#hash)         | No       |
| [`enable_sort`](#v3.3.1-plugins-filters-elasticsearch-enable_sort)               | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`fields`](#v3.3.1-plugins-filters-elasticsearch-fields)                         | [array](/docs/reference/logstash/plugins/value-types#array)       | No       |
| [`hosts`](#v3.3.1-plugins-filters-elasticsearch-hosts)                           | [array](/docs/reference/logstash/plugins/value-types#array)       | No       |
| [`index`](#v3.3.1-plugins-filters-elasticsearch-index)                           | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`password`](#v3.3.1-plugins-filters-elasticsearch-password)                     | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`query`](#v3.3.1-plugins-filters-elasticsearch-query)                           | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`query_template`](#v3.3.1-plugins-filters-elasticsearch-query_template)         | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`result_size`](#v3.3.1-plugins-filters-elasticsearch-result_size)               | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`sort`](#v3.3.1-plugins-filters-elasticsearch-sort)                             | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`ssl`](#v3.3.1-plugins-filters-elasticsearch-ssl)                               | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`tag_on_failure`](#v3.3.1-plugins-filters-elasticsearch-tag_on_failure)         | [array](/docs/reference/logstash/plugins/value-types#array)       | No       |
| [`user`](#v3.3.1-plugins-filters-elasticsearch-user)                             | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |

Also see [Common options](#v3.3.1-plugins-filters-elasticsearch-common-options) for a list of options supported by all filter plugins.

### `aggregation_fields`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Hash of aggregation names to copy from elasticsearch response into Logstash event fields
Example:
```
    filter {
      elasticsearch {
        aggregation_fields => {
          "my_agg_name" => "my_ls_field"
        }
      }
    }
```


### `ca_file`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL Certificate Authority file

### `docinfo_fields`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Hash of docinfo fields to copy from old event (found via elasticsearch) into new event
Example:
```
    filter {
      elasticsearch {
        docinfo_fields => {
          "_id" => "document_id"
          "_index" => "document_index"
        }
      }
    }
```


### `enable_sort`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Whether results should be sorted or not

### `fields`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `{}`

Array of fields to copy from old event (found via elasticsearch) into new event

### `hosts`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["localhost:9200"]`

List of elasticsearch hosts to use for querying.

### `index`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

Comma-delimited list of index names to search; use `_all` or empty string to perform the operation on all indices. Field substitution (e.g. `index-name-%{date_field}`) is available

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Basic Auth - password

### `query`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Elasticsearch query string. Read the Elasticsearch query string documentation. for more info at: 

### `query_template`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

File path to elasticsearch query in DSL format. Read the Elasticsearch query documentation for more info at: 

### `result_size`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`

How many results to return

### `sort`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"@timestamp:desc"`

Comma-delimited list of `<field>:<direction>` pairs that define the sort order

### `ssl`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

SSL

### `tag_on_failure`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["_elasticsearch_lookup_failure"]`

Tags the event on failure to look up previous log event information. This can be used in later analysis.

### `user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Basic Auth - username

## Common options

These configuration options are supported by all filter plugins:

| Setting                                                                  | Input type                                                      | Required |
|--------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.3.1-plugins-filters-elasticsearch-add_field)           | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`add_tag`](#v3.3.1-plugins-filters-elasticsearch-add_tag)               | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`enable_metric`](#v3.3.1-plugins-filters-elasticsearch-enable_metric)   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.3.1-plugins-filters-elasticsearch-id)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`periodic_flush`](#v3.3.1-plugins-filters-elasticsearch-periodic_flush) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`remove_field`](#v3.3.1-plugins-filters-elasticsearch-remove_field)     | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`remove_tag`](#v3.3.1-plugins-filters-elasticsearch-remove_tag)         | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

If this filter is successful, add any arbitrary fields to this event. Field names can be dynamic and include parts of the event using the `%{field}`.
Example:
```
    filter {
      elasticsearch {
        add_field => { "foo_%{somefield}" => "Hello world, from %{host}" }
      }
    }
```

```
    # You can also add multiple fields at once:
    filter {
      elasticsearch {
        add_field => {
          "foo_%{somefield}" => "Hello world, from %{host}"
          "new_field" => "new_static_value"
        }
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add field `foo_hello` if it is present, with the value above and the `%{host}` piece replaced with that value from the event. The second example would also add a hardcoded field.

### `add_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, add arbitrary tags to the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      elasticsearch {
        add_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also add multiple tags at once:
    filter {
      elasticsearch {
        add_tag => [ "foo_%{somefield}", "taggedy_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add a tag `foo_hello` (and the second example would of course add a `taggedy_tag` tag).

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 elasticsearch filters. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
    filter {
      elasticsearch {
        id => "ABC"
      }
    }
```


### `periodic_flush`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Call the filter flush method at regular interval. Optional.

### `remove_field`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary fields from this event. Fields names can be dynamic and include parts of the event using the %{field} Example:
```
    filter {
      elasticsearch {
        remove_field => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple fields at once:
    filter {
      elasticsearch {
        remove_field => [ "foo_%{somefield}", "my_extraneous_field" ]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the field with name `foo_hello` if it is present. The second example would remove an additional, non-dynamic field.

### `remove_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary tags from the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      elasticsearch {
        remove_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple tags at once:
    filter {
      elasticsearch {
        remove_tag => [ "foo_%{somefield}", "sad_unwanted_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the tag `foo_hello` if it is present. The second example would remove a sad, unwanted tag as well.