﻿---
title: Http input plugin v3.10.3
description: Plugin version: v3.10.3, Released on: 2025-09-04, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-10-3-plugins-inputs-http
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Http input plugin v3.10.3
- Plugin version: v3.10.3
- Released on: 2025-09-04
- [Changelog](https://github.com/logstash-plugins/logstash-input-http/blob/v3.10.3/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-http-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-http). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Using this input you can receive single or multiline events over http(s). Applications can send an HTTP request to the endpoint started by this input and Logstash will convert it into an event for subsequent processing. Users can pass plain text, JSON, or any formatted data and use a corresponding codec with this input. For Content-Type `application/json` the `json` codec is used, but for all other data formats, `plain` codec is used.
This input can also be used to receive webhook requests to integrate with other services and applications. By taking advantage of the vast plugin ecosystem available in Logstash you can trigger actionable events right from your application.

## Event Metadata and the Elastic Common Schema (ECS)

In addition to decoding the events, this input will add HTTP headers containing connection information to each event. When ECS compatibility is disabled, the headers are stored in the `headers` field, which has the potential to create confusion and schema conflicts downstream. When ECS is enabled, we can ensure a pipeline maintains access to this metadata throughout the event’s lifecycle without polluting the top-level namespace.
Here’s how ECS compatibility mode affects output.

| ECS `disabled`            | ECS `v1`,`v8`                             | Availability | Description              |
|---------------------------|-------------------------------------------|--------------|--------------------------|
| [host]                    | host][ip]                                 | *Always*     | *Host IP address*        |
| [headers]                 | [@metadata][input][http]request][headers] | *Always*     | *Complete HTTP headers*  |
| headers][http_version]    | http][version]                            | *Always*     | *HTTP version*           |
| headers][http_user_agent] | user_agent][original]                     | *Always*     | *client user agent*      |
| headers][http_host]       | url][domain] and url][port]               | *Always*     | *host domain and port*   |
| headers][request_method]  | http][method]                             | *Always*     | *HTTP method*            |
| headers][request_path]    | url][path]                                | *Always*     | *Query path*             |
| headers][content_length]  | [http][request]body][bytes]               | *Always*     | *Request content length* |
| headers][content_type]    | [http]request][mime_type]                 | *Always*     | *Request mime type*      |


## Blocking Behavior

The HTTP protocol doesn’t deal well with long running requests. This plugin will either return a 429 (busy) error when Logstash is backlogged, or it will time out the request.
If a 429 error is encountered clients should sleep, backing off exponentially with some random jitter, then retry their request.
This plugin will block if the Logstash queue is blocked and there are available HTTP input threads. This will cause most HTTP clients to time out. Sent events will still be processed in this case. This behavior is not optimal and will be changed in a future release. In the future, this plugin will always return a 429 if the queue is busy, and will not time out in the event of a busy queue.

## Security

This plugin supports standard HTTP basic authentication headers to identify the requester. You can pass in a username, password combination while sending data to this input
You can also setup SSL and send data securely over https, with multiple options such as validating the client’s certificate.

## Codec settings

This plugin has two configuration options for codecs: `codec` and `additional_codecs`.
Values in `additional_codecs` are prioritized over those specified in the `codec` option. That is, the default `codec` is applied only if no codec for the request’s content-type is found in the `additional_codecs` setting.

## Http Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.10.3-plugins-inputs-http-common-options) described later.

| Setting                                                                                   | Input type                                                                                               | Required     |
|-------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------|--------------|
| [`additional_codecs`](#v3.10.3-plugins-inputs-http-additional_codecs)                     | [hash](/docs/reference/logstash/plugins/value-types#hash)                                                | No           |
| [`cipher_suites`](#v3.10.3-plugins-inputs-http-cipher_suites)                             | [array](/docs/reference/logstash/plugins/value-types#array)                                              | *Deprecated* |
| [`ecs_compatibility`](#v3.10.3-plugins-inputs-http-ecs_compatibility)                     | [string](/docs/reference/logstash/plugins/value-types#string)                                            | No           |
| [`host`](#v3.10.3-plugins-inputs-http-host)                                               | [string](/docs/reference/logstash/plugins/value-types#string)                                            | No           |
| [`keystore`](#v3.10.3-plugins-inputs-http-keystore)                                       | [path](/docs/reference/logstash/plugins/value-types#path)                                                | *Deprecated* |
| [`keystore_password`](#v3.10.3-plugins-inputs-http-keystore_password)                     | [password](/docs/reference/logstash/plugins/value-types#password)                                        | *Deprecated* |
| [`password`](#v3.10.3-plugins-inputs-http-password)                                       | [password](/docs/reference/logstash/plugins/value-types#password)                                        | No           |
| [`port`](#v3.10.3-plugins-inputs-http-port)                                               | [number](/docs/reference/logstash/plugins/value-types#number)                                            | No           |
| [`max_pending_requests`](#v3.10.3-plugins-inputs-http-max_pending_requests)               | [number](/docs/reference/logstash/plugins/value-types#number)                                            | No           |
| [`response_headers`](#v3.10.3-plugins-inputs-http-response_headers)                       | [hash](/docs/reference/logstash/plugins/value-types#hash)                                                | No           |
| [`response_code`](#v3.10.3-plugins-inputs-http-response_code)                             | [number](/docs/reference/logstash/plugins/value-types#number), one of `[200, 201, 202, 204]`             | No           |
| [`ssl`](#v3.10.3-plugins-inputs-http-ssl)                                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                                          | *Deprecated* |
| [`ssl_certificate`](#v3.10.3-plugins-inputs-http-ssl_certificate)                         | a valid filesystem path                                                                                  | No           |
| [`ssl_certificate_authorities`](#v3.10.3-plugins-inputs-http-ssl_certificate_authorities) | [array](/docs/reference/logstash/plugins/value-types#array)                                              | No           |
| [`ssl_cipher_suites`](#v3.10.3-plugins-inputs-http-ssl_cipher_suites)                     | [array](/docs/reference/logstash/plugins/value-types#array)                                              | No           |
| [`ssl_client_authentication`](#v3.10.3-plugins-inputs-http-ssl_client_authentication)     | [string](/docs/reference/logstash/plugins/value-types#string), one of `["none", "optional", "required"]` | No           |
| [`ssl_enabled`](#v3.10.3-plugins-inputs-http-ssl_enabled)                                 | [boolean](/docs/reference/logstash/plugins/value-types#boolean)                                          | No           |
| [`ssl_handshake_timeout`](#v3.10.3-plugins-inputs-http-ssl_handshake_timeout)             | [number](/docs/reference/logstash/plugins/value-types#number)                                            | No           |
| [`ssl_key`](#v3.10.3-plugins-inputs-http-ssl_key)                                         | a valid filesystem path                                                                                  | No           |
| [`ssl_key_passphrase`](#v3.10.3-plugins-inputs-http-ssl_key_passphrase)                   | [password](/docs/reference/logstash/plugins/value-types#password)                                        | No           |
| [`ssl_keystore_password`](#v3.10.3-plugins-inputs-http-ssl_keystore_password)             | [password](/docs/reference/logstash/plugins/value-types#password)                                        | No           |
| [`ssl_keystore_path`](#v3.10.3-plugins-inputs-http-ssl_keystore_path)                     | [path](/docs/reference/logstash/plugins/value-types#path)                                                | No           |
| [`ssl_keystore_type`](#v3.10.3-plugins-inputs-http-ssl_keystore_type)                     | [string](/docs/reference/logstash/plugins/value-types#string)                                            | No           |
| [`ssl_supported_protocols`](#v3.10.3-plugins-inputs-http-ssl_supported_protocols)         | [array](/docs/reference/logstash/plugins/value-types#array)                                              | No           |
| [`ssl_truststore_password`](#v3.10.3-plugins-inputs-http-ssl_truststore_password)         | [password](/docs/reference/logstash/plugins/value-types#password)                                        | No           |
| [`ssl_truststore_path`](#v3.10.3-plugins-inputs-http-ssl_truststore_path)                 | [path](/docs/reference/logstash/plugins/value-types#path)                                                | No           |
| [`ssl_truststore_type`](#v3.10.3-plugins-inputs-http-ssl_truststore_type)                 | [string](/docs/reference/logstash/plugins/value-types#string)                                            | No           |
| [`ssl_verify_mode`](#v3.10.3-plugins-inputs-http-ssl_verify_mode)                         | [string](/docs/reference/logstash/plugins/value-types#string), one of `["none", "peer", "force_peer"]`   | *Deprecated* |
| [`threads`](#v3.10.3-plugins-inputs-http-threads)                                         | [number](/docs/reference/logstash/plugins/value-types#number)                                            | No           |
| [`tls_max_version`](#v3.10.3-plugins-inputs-http-tls_max_version)                         | [number](/docs/reference/logstash/plugins/value-types#number)                                            | *Deprecated* |
| [`tls_min_version`](#v3.10.3-plugins-inputs-http-tls_min_version)                         | [number](/docs/reference/logstash/plugins/value-types#number)                                            | *Deprecated* |
| [`user`](#v3.10.3-plugins-inputs-http-user)                                               | [string](/docs/reference/logstash/plugins/value-types#string)                                            | No           |
| [`verify_mode`](#v3.10.3-plugins-inputs-http-verify_mode)                                 | [string](/docs/reference/logstash/plugins/value-types#string), one of `["none", "peer", "force_peer"]`   | *Deprecated* |

Also see [Common options](#v3.10.3-plugins-inputs-http-common-options) for a list of options supported by all input plugins.

### `additional_codecs`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{"application/json"=>"json"}`

Apply specific codecs for specific content types. The default codec will be applied only after this list is checked and no codec for the request’s content-type is found

### `cipher_suites`

Deprecated in 3.6.0.
Replaced by [`ssl_cipher_suites`](#v3.10.3-plugins-inputs-http-ssl_cipher_suites)
- Value type is [array](/docs/reference/logstash/plugins/value-types#array)

The list of cipher suites to use, listed by priorities.

### `ecs_compatibility`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `disabled`: unstructured connection metadata added at root level
- `v1`,`v8`: headers added under `[@metadata][http][header]`. Some are copied to structured ECS fields `http`, `url`, `user_agent` and `host`

Controls this plugin’s compatibility with the [Elastic Common Schema (ECS)](https://www.elastic.co/guide/en/ecs/current). See [Event Metadata and the Elastic Common Schema (ECS)](#v3.10.3-plugins-inputs-http-ecs_metadata) for detailed information.
**Sample output: ECS disabled**
```
{
    "@version" => "1",
    "headers" => {
           "request_path" => "/twitter/tweet/1",
            "http_accept" => "*/*",
           "http_version" => "HTTP/1.1",
         "request_method" => "PUT",
              "http_host" => "localhost:8080",
        "http_user_agent" => "curl/7.64.1",
         "content_length" => "5",
           "content_type" => "application/x-www-form-urlencoded"
    },
    "@timestamp" => 2021-05-28T19:27:28.609Z,
    "host" => "127.0.0.1",
    "message" => "hello"
}
```

**Sample output: ECS enabled**
```
{
    "@version" => "1",
    "user_agent" => {
        "original" => "curl/7.64.1"
    },
    "http" => {
        "method" => "PUT",
        "request" => {
            "mime_type" => "application/x-www-form-urlencoded",
            "body" => {
                "bytes" => "5"
            }
        },
        "version" => "HTTP/1.1"
    },
    "url" => {
          "port" => "8080",
        "domain" => "snmp1",
          "path" => "/twitter/tweet/1"
    },
    "@timestamp" => 2021-05-28T23:32:38.222Z,
    "host" => {
        "ip" => "127.0.0.1"
    },
    "message" => "hello",
}
```


### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

The host or ip to bind

### `keystore`

Deprecated in 3.7.0.
Use [`ssl_keystore_path`](#v3.10.3-plugins-inputs-http-ssl_keystore_path) instead
- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The JKS keystore to validate the client’s certificates

### `keystore_password`

Deprecated in 3.7.0.
Use [`ssl_keystore_password`](#v3.10.3-plugins-inputs-http-ssl_keystore_password) instead
- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Set the keystore password

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Password for basic authorization

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `8080`

The TCP port to bind to

### `max_content_length`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is 104857600

The max content of an HTTP request in bytes. It defaults to 100mb.

### `max_pending_requests`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is 200

Maximum number of incoming requests to store in a temporary queue before being processed by worker threads. If a request arrives and the queue is full a 429 response will be returned immediately. This queue exists to deal with micro bursts of events and to improve overall throughput, so it should be changed very carefully as it can lead to memory pressure and impact performance. If you need to deal both periodic or unforeseen spikes in incoming requests consider enabling the Persistent Queue for the logstash pipeline.

### `response_code`

- Value can be any of: 200, 201, 202, 204
- Default value is `200`

The HTTP return code if the request is processed successfully.
Other return codes may happen in the case of an error condition, such as invalid credentials (401), internal errors (503) or backpressure (429).
If 204 (No Content) is set, the response body will not be sent in the response.

### `response_headers`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{"Content-Type"=>"text/plain"}`

specify a custom set of response headers

### `remote_host_target_field`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"host"` when ECS is disabled
- Default value is `[host][ip]` when ECS is enabled

specify a target field for the client host of the http request

### `request_headers_target_field`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"headers"` when ECS is disabled
- Default value is `[@metadata][http][header]` when ECS is enabled

specify target field for the client host of the http request

### `ssl`

Deprecated in 3.7.0.
Replaced by [`ssl_enabled`](#v3.10.3-plugins-inputs-http-ssl_enabled)
- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Events are, by default, sent in plain text. You can enable encryption by setting `ssl` to true and configuring the `ssl_certificate` and `ssl_key` options.

### `ssl_certificate`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL certificate to use.

### `ssl_certificate_authorities`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

Validate client certificates against these authorities. You can define multiple files or paths. All the certificates will be read and added to the trust store. You need to configure the [`ssl_client_authentication`](#v3.10.3-plugins-inputs-http-ssl_client_authentication) to `optional` or `required` to enable the verification.

### `ssl_cipher_suites`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `['TLS_AES_256_GCM_SHA384', 'TLS_AES_128_GCM_SHA256', 'TLS_CHACHA20_POLY1305_SHA256', 'TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384', 'TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384', 'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256', 'TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256', 'TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256', 'TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256', 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384', 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384', 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256', 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256']`

The list of cipher suites to use, listed by priorities. This default list applies for OpenJDK 11.0.14 and higher. For older JDK versions, the default list includes only suites supported by that version. For example, the ChaCha20 family of ciphers is not supported in older versions.

### `ssl_client_authentication`

- Value can be any of: `none`, `optional`, `required`
- Default value is `"none"`

Controls the server’s behavior in regard to requesting a certificate from client connections: `required` forces a client to present a certificate, while `optional` requests a client certificate but the client is not required to present one. Defaults to `none`, which disables the client authentication.
This setting can be used only if [`ssl_certificate_authorities`](#v3.10.3-plugins-inputs-http-ssl_certificate_authorities) is set.

### `ssl_enabled`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Events are, by default, sent in plain text. You can enable encryption by setting `ssl_enabled` to true and configuring the [`ssl_certificate`](#v3.10.3-plugins-inputs-http-ssl_certificate) and [`ssl_key`](#v3.10.3-plugins-inputs-http-ssl_key) options.

### `ssl_handshake_timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10000`

Time in milliseconds for an incomplete ssl handshake to timeout

### `ssl_key`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

SSL key to use. NOTE: This key need to be in the PKCS8 format, you can convert it with [OpenSSL](https://www.openssl.org/docs/man1.1.1/man1/openssl-pkcs8.html) for more information.

### `ssl_key_passphrase`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

SSL key passphrase to use.

### `ssl_keystore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The path for the keystore file that contains a private key and certificate. It must be either a Java keystore (jks) or a PKCS#12 file.
You cannot use this setting and [`ssl_certificate`](#v3.10.3-plugins-inputs-http-ssl_certificate) at the same time.

### `ssl_keystore_type`

- Value can be any of: `jks`, `pkcs12`
- If not provided, the value will be inferred from the keystore filename.

The format of the keystore file. It must be either `jks` or `pkcs12`.

### `ssl_keystore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Set the JKS keystore password

### `ssl_supported_protocols`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Allowed values are: `'TLSv1.1'`, `'TLSv1.2'`, `'TLSv1.3'`
- Default depends on the JDK being used. With up-to-date Logstash, the default is `['TLSv1.2', 'TLSv1.3']`. `'TLSv1.1'` is not considered secure and is only provided for legacy applications.

List of allowed SSL/TLS versions to use when establishing a connection to the HTTP endpoint.
For Java 8 `'TLSv1.3'` is supported only since **8u262** (AdoptOpenJDK), but requires that you set the `LS_JAVA_OPTS="-Djdk.tls.client.protocols=TLSv1.3"` system property in Logstash.
If you configure the plugin to use `'TLSv1.1'` on any recent JVM, such as the one packaged with Logstash, the protocol is disabled by default and needs to be enabled manually by changing `jdk.tls.disabledAlgorithms` in the **$JDK_HOME/conf/security/java.security** configuration file. That is, `TLSv1.1` needs to be removed from the list.

### `ssl_truststore_password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Set the truststore password

### `ssl_truststore_path`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

The path for the keystore that contains the certificates to trust. It must be either a Java keystore (jks) or a PKCS#12 file.
You cannot use this setting and [`ssl_certificate_authorities`](#v3.10.3-plugins-inputs-http-ssl_certificate_authorities) at the same time.

### `ssl_truststore_type`

- Value can be any of: `jks`, `pkcs12`
- If not provided, the value will be inferred from the truststore filename.

The format of the truststore file. It must be either `jks` or `pkcs12`.

### `ssl_verify_mode`

Deprecated in 3.7.0.
Replaced by [`ssl_client_authentication`](#v3.10.3-plugins-inputs-http-ssl_client_authentication)
- Value can be any of: `none`, `peer`, `force_peer`
- Default value is `"none"`

By default the server doesn’t do any client verification.
`peer` will make the server ask the client to provide a certificate. If the client provides a certificate, it will be validated.
`force_peer` will make the server ask the client to provide a certificate. If the client doesn’t provide a certificate, the connection will be closed.
This option needs to be used with [`ssl_certificate_authorities`](#v3.10.3-plugins-inputs-http-ssl_certificate_authorities) and a defined list of CAs.

### `threads`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is number of processors

Number of threads to use for both accepting connections and handling requests

### `tls_max_version`

Deprecated in 3.6.0.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)

The maximum TLS version allowed for the encrypted connections. The value must be the one of the following: 1.1 for TLS 1.1, 1.2 for TLS 1.2, 1.3 for TLSv1.3

### `tls_min_version`

Deprecated in 3.6.0.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)

The minimum TLS version allowed for the encrypted connections. The value must be one of the following: 1.1 for TLS 1.1, 1.2 for TLS 1.2, 1.3 for TLSv1.3

### `user`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Username for basic authorization

### `verify_mode`

Deprecated in 3.6.0.
Replaced by [`ssl_verify_mode`](#v3.10.3-plugins-inputs-http-ssl_verify_mode)
- Value can be any of: `none`, `peer`, `force_peer`
- Default value is `"none"`

Set the client certificate verification method. Valid methods: none, peer, force_peer

## Common options

These configuration options are supported by all input plugins:

| Setting                                                       | Input type                                                      | Required |
|---------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.10.3-plugins-inputs-http-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.10.3-plugins-inputs-http-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.10.3-plugins-inputs-http-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.10.3-plugins-inputs-http-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.10.3-plugins-inputs-http-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.10.3-plugins-inputs-http-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 http inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  http {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.