﻿---
title: Opentsdb output plugin v3.1.4
description: Plugin version: v3.1.4, Released on: 2017-11-13, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-4-plugins-outputs-opentsdb
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Opentsdb output plugin v3.1.4
- Plugin version: v3.1.4
- Released on: 2017-11-13
- [Changelog](https://github.com/logstash-plugins/logstash-output-opentsdb/blob/v3.1.4/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-opentsdb-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-opentsdb). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output allows you to pull metrics from your logs and ship them to opentsdb. Opentsdb is an open source tool for storing and graphing metrics.

## Opentsdb Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.1.4-plugins-outputs-opentsdb-common-options) described later.

| Setting                                               | Input type                                                    | Required |
|-------------------------------------------------------|---------------------------------------------------------------|----------|
| [`host`](#v3.1.4-plugins-outputs-opentsdb-host)       | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`metrics`](#v3.1.4-plugins-outputs-opentsdb-metrics) | [array](/docs/reference/logstash/plugins/value-types#array)   | Yes      |
| [`port`](#v3.1.4-plugins-outputs-opentsdb-port)       | [number](/docs/reference/logstash/plugins/value-types#number) | No       |

Also see [Common options](#v3.1.4-plugins-outputs-opentsdb-common-options) for a list of options supported by all output plugins.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

The address of the opentsdb server.

### `metrics`

- This is a required setting.
- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

The metric(s) to use. This supports dynamic strings like %{source_host} for metric names and also for values. This is an array field with key of the metric name, value of the metric value, and multiple tag,values . Example:
```
    [
      "%{host}/uptime",
      %{uptime_1m} " ,
      "hostname" ,
      "%{host}
      "anotherhostname" ,
      "%{host}
    ]
```

The value will be coerced to a floating point value. Values which cannot be coerced will zero (0)

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `4242`

The port to connect on your graphite server.

## Common options

These configuration options are supported by all output plugins:

| Setting                                                           | Input type                                                      | Required |
|-------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.1.4-plugins-outputs-opentsdb-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.1.4-plugins-outputs-opentsdb-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.1.4-plugins-outputs-opentsdb-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 opentsdb outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  opentsdb {
    id => "my_plugin_id"
  }
}
```