﻿---
title: Redis input plugin v3.1.4
description: Plugin version: v3.1.4, Released on: 2017-08-16, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-4-plugins-inputs-redis
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Redis input plugin v3.1.4
- Plugin version: v3.1.4
- Released on: 2017-08-16
- [Changelog](https://github.com/logstash-plugins/logstash-input-redis/blob/v3.1.4/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-redis-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-redis). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This input will read events from a Redis instance; it supports both Redis channels and lists. The list command (BLPOP) used by Logstash is supported in Redis v1.3.1+, and the channel commands used by Logstash are found in Redis v1.3.8+. While you may be able to make these Redis versions work, the best performance and stability will be found in more recent stable versions. Versions 2.6.0+ are recommended.
For more information about Redis, see 
`batch_count` note: If you use the `batch_count` setting, you **must** use a Redis version 2.6.0 or newer. Anything older does not support the operations used by batching.

## Redis Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.1.4-plugins-inputs-redis-common-options) described later.

| Setting                                                   | Input type                                                                                                     | Required |
|-----------------------------------------------------------|----------------------------------------------------------------------------------------------------------------|----------|
| [`batch_count`](#v3.1.4-plugins-inputs-redis-batch_count) | [number](/docs/reference/logstash/plugins/value-types#number)                                                  | No       |
| [`data_type`](#v3.1.4-plugins-inputs-redis-data_type)     | [string](/docs/reference/logstash/plugins/value-types#string), one of `["list", "channel", "pattern_channel"]` | Yes      |
| [`db`](#v3.1.4-plugins-inputs-redis-db)                   | [number](/docs/reference/logstash/plugins/value-types#number)                                                  | No       |
| [`host`](#v3.1.4-plugins-inputs-redis-host)               | [string](/docs/reference/logstash/plugins/value-types#string)                                                  | No       |
| [`key`](#v3.1.4-plugins-inputs-redis-key)                 | [string](/docs/reference/logstash/plugins/value-types#string)                                                  | Yes      |
| [`password`](#v3.1.4-plugins-inputs-redis-password)       | [password](/docs/reference/logstash/plugins/value-types#password)                                              | No       |
| [`port`](#v3.1.4-plugins-inputs-redis-port)               | [number](/docs/reference/logstash/plugins/value-types#number)                                                  | No       |
| [`threads`](#v3.1.4-plugins-inputs-redis-threads)         | [number](/docs/reference/logstash/plugins/value-types#number)                                                  | No       |
| [`timeout`](#v3.1.4-plugins-inputs-redis-timeout)         | [number](/docs/reference/logstash/plugins/value-types#number)                                                  | No       |

Also see [Common options](#v3.1.4-plugins-inputs-redis-common-options) for a list of options supported by all input plugins.

### `batch_count`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `125`

The number of events to return from Redis using EVAL.

### `data_type`

- This is a required setting.
- Value can be any of: `list`, `channel`, `pattern_channel`
- There is no default value for this setting.

Specify either list or channel. If `redis_type` is `list`, then we will BLPOP the key. If `redis_type` is `channel`, then we will SUBSCRIBE to the key. If `redis_type` is `pattern_channel`, then we will PSUBSCRIBE to the key.

### `db`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `0`

The Redis database number.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"127.0.0.1"`

The hostname of your Redis server.

### `key`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The name of a Redis list or channel.

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

Password to authenticate with. There is no authentication by default.

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `6379`

The port to connect on.

### `threads`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1`


### `timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5`

Initial connection timeout in seconds.

## Common options

These configuration options are supported by all input plugins:

| Setting                                                       | Input type                                                      | Required |
|---------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.1.4-plugins-inputs-redis-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.1.4-plugins-inputs-redis-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.1.4-plugins-inputs-redis-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.1.4-plugins-inputs-redis-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.1.4-plugins-inputs-redis-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.1.4-plugins-inputs-redis-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 redis inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  redis {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.