﻿---
title: Zeromq output plugin v3.1.2
description: Plugin version: v3.1.2, Released on: 2017-11-13, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-2-plugins-outputs-zeromq
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Zeromq output plugin v3.1.2
- Plugin version: v3.1.2
- Released on: 2017-11-13
- [Changelog](https://github.com/logstash-plugins/logstash-output-zeromq/blob/v3.1.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-zeromq-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-zeromq). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Write events to a 0MQ PUB socket.
You need to have the 0mq 2.1.x library installed to be able to use this output plugin.
The default settings will create a publisher connecting to a subscriber bound to tcp://127.0.0.1:2120

## Zeromq Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.1.2-plugins-outputs-zeromq-common-options) described later.

| Setting                                               | Input type                                                                                             | Required |
|-------------------------------------------------------|--------------------------------------------------------------------------------------------------------|----------|
| [`address`](#v3.1.2-plugins-outputs-zeromq-address)   | [array](/docs/reference/logstash/plugins/value-types#array)                                            | No       |
| [`mode`](#v3.1.2-plugins-outputs-zeromq-mode)         | [string](/docs/reference/logstash/plugins/value-types#string), one of `["server", "client"]`           | No       |
| [`sockopt`](#v3.1.2-plugins-outputs-zeromq-sockopt)   | [hash](/docs/reference/logstash/plugins/value-types#hash)                                              | No       |
| [`topic`](#v3.1.2-plugins-outputs-zeromq-topic)       | [string](/docs/reference/logstash/plugins/value-types#string)                                          | No       |
| [`topology`](#v3.1.2-plugins-outputs-zeromq-topology) | [string](/docs/reference/logstash/plugins/value-types#string), one of `["pushpull", "pubsub", "pair"]` | Yes      |

Also see [Common options](#v3.1.2-plugins-outputs-zeromq-common-options) for a list of options supported by all output plugins.

### `address`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `["tcp://127.0.0.1:2120"]`

This will be a performance bottleneck. Someone needs to upgrade this to concurrency :shared and make sure there is no breakage 0mq socket address to connect or bind. Please note that `inproc://` will not work with logstashi. For each we use a context per thread. By default, inputs bind/listen and outputs connect.

### `mode`

- Value can be any of: `server`, `client`
- Default value is `"client"`

Server mode binds/listens. Client mode connects.

### `sockopt`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- There is no default value for this setting.

This exposes zmq_setsockopt for advanced tuning. See  for details.
This is where you would set values like:
- ZMQ::HWM - high water mark
- ZMQ::IDENTITY - named queues
- ZMQ::SWAP_SIZE - space for disk overflow

Example:
```
    sockopt => {
       "ZMQ::HWM" => 50
       "ZMQ::IDENTITY"  => "my_named_queue"
    }
```


### `topic`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

This is used for the *pubsub* topology only. On inputs, this allows you to filter messages by topic. On outputs, this allows you to tag a message for routing. NOTE: ZeroMQ does subscriber-side filtering NOTE: Topic is evaluated with `event.sprintf` so macros are valid here.

### `topology`

- This is a required setting.
- Value can be any of: `pushpull`, `pubsub`, `pair`
- There is no default value for this setting.

The default logstash topologies work as follows:
- pushpull - inputs are pull, outputs are push
- pubsub - inputs are subscribers, outputs are publishers
- pair - inputs are clients, outputs are servers

If the predefined topology flows don’t work for you, you can change the *mode* setting

## Common options

These configuration options are supported by all output plugins:

| Setting                                                         | Input type                                                      | Required |
|-----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.1.2-plugins-outputs-zeromq-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.1.2-plugins-outputs-zeromq-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.1.2-plugins-outputs-zeromq-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 zeromq outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  zeromq {
    id => "my_plugin_id"
  }
}
```