﻿---
title: Couchdb_changes input plugin v3.1.2
description: Plugin version: v3.1.2, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-2-plugins-inputs-couchdb_changes
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Couchdb_changes input plugin v3.1.2
- Plugin version: v3.1.2
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-input-couchdb_changes/blob/v3.1.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-couchdb_changes-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-couchdb_changes). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This CouchDB input allows you to automatically stream events from the CouchDB [_changes](http://guide.couchdb.org/draft/notifications.html) URI. Moreover, any "future" changes will automatically be streamed as well making it easy to synchronize your CouchDB data with any target destination

### Upsert and delete

You can use event metadata to allow for document deletion. All non-delete operations are treated as upserts

### Starting at a Specific Sequence

The CouchDB input stores the last sequence number value in location defined by `sequence_path`. You can use this fact to start or resume the stream at a particular sequence.

## Couchdb_changes Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.1.2-plugins-inputs-couchdb_changes-common-options) described later.

| Setting                                                                           | Input type                                                        | Required |
|-----------------------------------------------------------------------------------|-------------------------------------------------------------------|----------|
| [`always_reconnect`](#v3.1.2-plugins-inputs-couchdb_changes-always_reconnect)     | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`ca_file`](#v3.1.2-plugins-inputs-couchdb_changes-ca_file)                       | a valid filesystem path                                           | No       |
| [`db`](#v3.1.2-plugins-inputs-couchdb_changes-db)                                 | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`heartbeat`](#v3.1.2-plugins-inputs-couchdb_changes-heartbeat)                   | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`host`](#v3.1.2-plugins-inputs-couchdb_changes-host)                             | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`ignore_attachments`](#v3.1.2-plugins-inputs-couchdb_changes-ignore_attachments) | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`initial_sequence`](#v3.1.2-plugins-inputs-couchdb_changes-initial_sequence)     | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`keep_id`](#v3.1.2-plugins-inputs-couchdb_changes-keep_id)                       | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`keep_revision`](#v3.1.2-plugins-inputs-couchdb_changes-keep_revision)           | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`password`](#v3.1.2-plugins-inputs-couchdb_changes-password)                     | [password](/docs/reference/logstash/plugins/value-types#password) | No       |
| [`port`](#v3.1.2-plugins-inputs-couchdb_changes-port)                             | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`reconnect_delay`](#v3.1.2-plugins-inputs-couchdb_changes-reconnect_delay)       | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`secure`](#v3.1.2-plugins-inputs-couchdb_changes-secure)                         | [boolean](/docs/reference/logstash/plugins/value-types#boolean)   | No       |
| [`sequence_path`](#v3.1.2-plugins-inputs-couchdb_changes-sequence_path)           | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`timeout`](#v3.1.2-plugins-inputs-couchdb_changes-timeout)                       | [number](/docs/reference/logstash/plugins/value-types#number)     | No       |
| [`username`](#v3.1.2-plugins-inputs-couchdb_changes-username)                     | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |

Also see [Common options](#v3.1.2-plugins-inputs-couchdb_changes-common-options) for a list of options supported by all input plugins.

### `always_reconnect`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Reconnect flag. When true, always try to reconnect after a failure

### `ca_file`

- Value type is [path](/docs/reference/logstash/plugins/value-types#path)
- There is no default value for this setting.

Path to a CA certificate file, used to validate certificates

### `db`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The CouchDB db to connect to. Required parameter.

### `heartbeat`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `1000`

Logstash connects to CouchDB’s _changes with feed=continuous The heartbeat is how often (in milliseconds) Logstash will ping CouchDB to ensure the connection is maintained. Changing this setting is not recommended unless you know what you are doing.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

IP or hostname of your CouchDB instance

### `ignore_attachments`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Future feature! Until implemented, changing this from the default will not do anything.
Ignore attachments associated with CouchDB documents.

### `initial_sequence`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

If unspecified, Logstash will attempt to read the last sequence number from the `sequence_path` file. If that is empty or non-existent, it will begin with 0 (the beginning).
If you specify this value, it is anticipated that you will only be doing so for an initial read under special circumstances and that you will unset this value afterwards.

### `keep_id`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Preserve the CouchDB document id "_id" value in the output.

### `keep_revision`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Preserve the CouchDB document revision "_rev" value in the output.

### `password`

- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- Default value is `nil`

Password, if authentication is needed to connect to CouchDB

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `5984`

Port of your CouchDB instance.

### `reconnect_delay`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `10`

Reconnect delay: time between reconnect attempts, in seconds.

### `secure`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Connect to CouchDB’s _changes feed securely (via https) Default: false (via http)

### `sequence_path`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

File path where the last sequence number in the _changes stream is stored. If unset it will write to `$HOME/.couchdb_seq`

### `timeout`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

Timeout: Number of milliseconds to wait for new data before terminating the connection. If a timeout is set it will disable the heartbeat configuration option.

### `username`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `nil`

Username, if authentication is needed to connect to CouchDB

## Common options

These configuration options are supported by all input plugins:

| Setting                                                                 | Input type                                                      | Required |
|-------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.1.2-plugins-inputs-couchdb_changes-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.1.2-plugins-inputs-couchdb_changes-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.1.2-plugins-inputs-couchdb_changes-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.1.2-plugins-inputs-couchdb_changes-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.1.2-plugins-inputs-couchdb_changes-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.1.2-plugins-inputs-couchdb_changes-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 couchdb_changes inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  couchdb_changes {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.