﻿---
title: Fluent codec plugin v3.1.2
description: Plugin version: v3.1.2, Released on: 2017-06-23, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-2-plugins-codecs-fluent
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Fluent codec plugin v3.1.2
- Plugin version: v3.1.2
- Released on: 2017-06-23
- [Changelog](https://github.com/logstash-plugins/logstash-codec-fluent/blob/v3.1.2/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-fluent-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-fluent). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This codec handles fluentd’s msgpack schema.
For example, you can receive logs from `fluent-logger-ruby` with:
```
    input {
      tcp {
        codec => fluent
        port => 4000
      }
    }
```

And from your ruby code in your own application:
```
    logger = Fluent::Logger::FluentLogger.new(nil, :host => "example.log", :port => 4000)
    logger.post("some_tag", { "your" => "data", "here" => "yay!" })
```

Notes:
- the fluent uses a second-precision time for events, so you will never see subsecond precision on events processed by this codec.