﻿---
title: Websocket output plugin v3.1.0
description: Plugin version: v3.1.0, Released on: 2024-01-11, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-0-plugins-outputs-websocket
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Websocket output plugin v3.1.0
- Plugin version: v3.1.0
- Released on: 2024-01-11
- [Changelog](https://github.com/logstash-plugins/logstash-output-websocket/blob/v3.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-websocket-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-websocket). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output runs a websocket server and publishes any messages to all connected websocket clients.
You can connect to it with ws://<host\>:<port\>/
If no clients are connected, any messages received are ignored.

## Websocket Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.1.0-plugins-outputs-websocket-common-options) described later.

| Setting                                          | Input type                                                    | Required |
|--------------------------------------------------|---------------------------------------------------------------|----------|
| [`host`](#v3.1.0-plugins-outputs-websocket-host) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`port`](#v3.1.0-plugins-outputs-websocket-port) | [number](/docs/reference/logstash/plugins/value-types#number) | No       |

Also see [Common options](#v3.1.0-plugins-outputs-websocket-common-options) for a list of options supported by all output plugins.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

The address to serve websocket data from

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `3232`

The port to serve websocket data from

## Common options

These configuration options are supported by all output plugins:

| Setting                                                            | Input type                                                      | Required |
|--------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.1.0-plugins-outputs-websocket-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.1.0-plugins-outputs-websocket-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.1.0-plugins-outputs-websocket-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 websocket outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  websocket {
    id => "my_plugin_id"
  }
}
```