﻿---
title: Pipe input plugin v3.1.0
description: Plugin version: v3.1.0, Released on: 2021-11-18, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-0-plugins-inputs-pipe
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Pipe input plugin v3.1.0
- Plugin version: v3.1.0
- Released on: 2021-11-18
- [Changelog](https://github.com/logstash-plugins/logstash-input-pipe/blob/v3.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-pipe-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-pipe). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Stream events from a long running command pipe.
By default, each event is assumed to be one line. If you want to join lines, you’ll want to use the multiline codec.

## Compatibility with the Elastic Common Schema (ECS)

This plugin adds extra fields about the event’s source. Configure the [`ecs_compatibility`](#v3.1.0-plugins-inputs-pipe-ecs_compatibility) option if you want to ensure that these fields are compatible with [ECS](https://www.elastic.co/guide/en/ecs/current).
These fields are added after the event has been decoded by the appropriate codec, and will not overwrite existing values.

| ECS Disabled | ECS v1 , v8               | Description                                            |
|--------------|---------------------------|--------------------------------------------------------|
| `host`       | `[host][name]`            | The name of the Logstash host that processed the event |
| `command`    | `[process][command_line]` | The command run by the plugin                          |


## Pipe Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.1.0-plugins-inputs-pipe-common-options) described later.

| Setting                                                              | Input type                                                    | Required |
|----------------------------------------------------------------------|---------------------------------------------------------------|----------|
| [`command`](#v3.1.0-plugins-inputs-pipe-command)                     | [string](/docs/reference/logstash/plugins/value-types#string) | Yes      |
| [`ecs_compatibility`](#v3.1.0-plugins-inputs-pipe-ecs_compatibility) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |

Also see [Common options](#v3.1.0-plugins-inputs-pipe-common-options) for a list of options supported by all input plugins.

### `command`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Command to run and read events from, one line at a time.
Example:
```
input {
  pipe {
    command => "echo ¡Hola!"
  }
}
```


### `ecs_compatibility`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Supported values are:
  - `disabled`: uses backwards compatible field names, such as `[host]`
- `v1`, `v8`: uses fields that are compatible with ECS, such as `[host][name]`

Controls this plugin’s compatibility with the [Elastic Common Schema (ECS)](https://www.elastic.co/guide/en/ecs/current). See [Compatibility with the Elastic Common Schema (ECS)](#v3.1.0-plugins-inputs-pipe-ecs) for detailed information.
**Sample output: ECS enabled**
```
{
    "@timestamp"=>2021-11-16T09:18:45.306Z,
    "message" => "¡Hola!",
    "process" => {
        "command_line" => "echo '¡Hola!'"
    },
    "host" => {
        "name" => "deus-ex-machina"
    }
}
```

**Sample output: ECS disabled**
```
{
    "@timestamp"=>2021-11-16T09:18:45.306Z,
    "message" => "¡Hola!",
    "command" => "echo '¡Hola!'",
    "host" => "deus-ex-machina"
}
```


## Common options

These configuration options are supported by all input plugins:

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.1.0-plugins-inputs-pipe-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.1.0-plugins-inputs-pipe-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.1.0-plugins-inputs-pipe-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.1.0-plugins-inputs-pipe-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.1.0-plugins-inputs-pipe-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.1.0-plugins-inputs-pipe-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 pipe inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  pipe {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.