﻿---
title: Msgpack codec plugin v3.1.0
description: Plugin version: v3.1.0, Released on: 2021-08-09, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-1-0-plugins-codecs-msgpack
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Msgpack codec plugin v3.1.0
- Plugin version: v3.1.0
- Released on: 2021-08-09
- [Changelog](https://github.com/logstash-plugins/logstash-codec-msgpack/blob/v3.1.0/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/codec-msgpack-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-codec-msgpack). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This codec reads and produces MessagePack encoded content.

## Msgpack Codec configuration options


| Setting                                           | Input type                                                    | Required |
|---------------------------------------------------|---------------------------------------------------------------|----------|
| [`format`](#v3.1.0-plugins-codecs-msgpack-format) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |
| [`target`](#v3.1.0-plugins-codecs-msgpack-target) | [string](/docs/reference/logstash/plugins/value-types#string) | No       |


### `format`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.


### `target`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Define the target field for placing the decoded values. If this setting is not set, data will be stored at the root (top level) of the event.
For example, if you want data to be put under the `document` field:
```
    input {
      tcp {
        port => 4242
        codec => msgpack {
          target => "[document]"
        }
      }
    }
```