﻿---
title: Github input plugin v3.0.8
description: Plugin version: v3.0.8, Released on: 2019-07-18, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-8-plugins-inputs-github
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Github input plugin v3.0.8
- Plugin version: v3.0.8
- Released on: 2019-07-18
- [Changelog](https://github.com/logstash-plugins/logstash-input-github/blob/v3.0.8/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/input-github-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-input-github). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

Read events from github webhooks

## Github Input Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.8-plugins-inputs-github-common-options) described later.

| Setting                                                      | Input type                                                      | Required |
|--------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`drop_invalid`](#v3.0.8-plugins-inputs-github-drop_invalid) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`ip`](#v3.0.8-plugins-inputs-github-ip)                     | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`port`](#v3.0.8-plugins-inputs-github-port)                 | [number](/docs/reference/logstash/plugins/value-types#number)   | Yes      |
| [`secret_token`](#v3.0.8-plugins-inputs-github-secret_token) | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |

Also see [Common options](#v3.0.8-plugins-inputs-github-common-options) for a list of options supported by all input plugins.

### `drop_invalid`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

If Secret is defined, we drop the events that don’t match. Otherwise, we’ll just add an invalid tag

### `ip`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"0.0.0.0"`

The ip to listen on

### `port`

- This is a required setting.
- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- There is no default value for this setting.

The port to listen on

### `secret_token`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Your GitHub Secret Token for the webhook

## Common options

These configuration options are supported by all input plugins:

| Setting                                                        | Input type                                                      | Required |
|----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.0.8-plugins-inputs-github-add_field)         | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`codec`](#v3.0.8-plugins-inputs-github-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.8-plugins-inputs-github-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.8-plugins-inputs-github-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`tags`](#v3.0.8-plugins-inputs-github-tags)                   | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`type`](#v3.0.8-plugins-inputs-github-type)                   | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Add a field to an event

### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for input data. Input codecs are a convenient method for decoding your data before it enters the input, without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 github inputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
input {
  github {
    id => "my_plugin_id"
  }
}
```


### `tags`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

Add any number of arbitrary tags to your event.
This can help with processing later.

### `type`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a `type` field to all events handled by this input.
Types are used mainly for filter activation.
The type is stored as part of the event itself, so you can also use the type to search for it in Kibana.
If you try to set a type on an event that already has one (for example when you send an event from a shipper to an indexer) then a new input will not override the existing type. A type set at the shipper stays with that event for its life even when sent to another Logstash server.