﻿---
title: Csv filter plugin v3.0.8
description: Plugin version: v3.0.8, Released on: 2018-01-12, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-8-plugins-filters-csv
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Csv filter plugin v3.0.8
- Plugin version: v3.0.8
- Released on: 2018-01-12
- [Changelog](https://github.com/logstash-plugins/logstash-filter-csv/blob/v3.0.8/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/filter-csv-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-filter-csv). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

The CSV filter takes an event field containing CSV data, parses it, and stores it as individual fields (can optionally specify the names). This filter can also parse data with any separator, not just commas.

## Csv Filter Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.8-plugins-filters-csv-common-options) described later.

| Setting                                                                              | Input type                                                      | Required |
|--------------------------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`autodetect_column_names`](#v3.0.8-plugins-filters-csv-autodetect_column_names)     | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`autogenerate_column_names`](#v3.0.8-plugins-filters-csv-autogenerate_column_names) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`columns`](#v3.0.8-plugins-filters-csv-columns)                                     | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`convert`](#v3.0.8-plugins-filters-csv-convert)                                     | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`quote_char`](#v3.0.8-plugins-filters-csv-quote_char)                               | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`separator`](#v3.0.8-plugins-filters-csv-separator)                                 | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`skip_empty_columns`](#v3.0.8-plugins-filters-csv-skip_empty_columns)               | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`skip_empty_rows`](#v3.0.8-plugins-filters-csv-skip_empty_rows)                     | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`skip_header`](#v3.0.8-plugins-filters-csv-skip_header)                             | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`source`](#v3.0.8-plugins-filters-csv-source)                                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`target`](#v3.0.8-plugins-filters-csv-target)                                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |

Also see [Common options](#v3.0.8-plugins-filters-csv-common-options) for a list of options supported by all filter plugins.

### `autodetect_column_names`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Define whether column names should be auto-detected from the header column or not. Defaults to false.

### `autogenerate_column_names`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Define whether column names should autogenerated or not. Defaults to true. If set to false, columns not having a header specified will not be parsed.

### `columns`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

Define a list of column names (in the order they appear in the CSV, as if it were a header line). If `columns` is not configured, or there are not enough columns specified, the default column names are "column1", "column2", etc. In the case that there are more columns in the data than specified in this column list, extra columns will be auto-numbered: (e.g. "user_defined_1", "user_defined_2", "column3", "column4", etc.)

### `convert`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

Define a set of datatype conversions to be applied to columns. Possible conversions are integer, float, date, date_time, boolean
Example:
```
    filter {
      csv {
        convert => {
          "column1" => "integer"
          "column2" => "boolean"
        }
      }
    }
```


### `quote_char`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"\""`

Define the character used to quote CSV fields. If this is not specified the default is a double quote `"`. Optional.

### `separator`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `","`

Define the column separator value. If this is not specified, the default is a comma `,`. If you want to define a tabulation as a separator, you need to set the value to the actual tab character and not `\t`. Optional.

### `skip_empty_columns`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Define whether empty columns should be skipped. Defaults to false. If set to true, columns containing no value will not get set.

### `skip_empty_rows`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Define whether empty rows could potentially be skipped. Defaults to false. If set to true, rows containing no value will be tagged with "_csvskippedemptyfield". This tag can referenced by users if they wish to cancel events using an *if* conditional statement.

### `skip_header`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Define whether the header should be skipped. Defaults to false. If set to true, the header will be skipped. Assumes that header is not repeated within further rows as such rows will also be skipped. If skip_header is set without autodetect_column_names being set then columns should be set which will result in the skipping of any row that exactly matches the specified column values. If skip_header and autodetect_column_names are specified then columns should not be specified, in this case autodetect_column_names will fill the columns setting in the background, from the first event seen, and any subsequent values that match what was autodetected will be skipped.

### `source`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"message"`

The CSV data in the value of the `source` field will be expanded into a data structure.

### `target`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Define target field for placing the data. Defaults to writing to the root of the event.

## Common options

These configuration options are supported by all filter plugins:

| Setting                                                        | Input type                                                      | Required |
|----------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`add_field`](#v3.0.8-plugins-filters-csv-add_field)           | [hash](/docs/reference/logstash/plugins/value-types#hash)       | No       |
| [`add_tag`](#v3.0.8-plugins-filters-csv-add_tag)               | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`enable_metric`](#v3.0.8-plugins-filters-csv-enable_metric)   | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.8-plugins-filters-csv-id)                         | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |
| [`periodic_flush`](#v3.0.8-plugins-filters-csv-periodic_flush) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`remove_field`](#v3.0.8-plugins-filters-csv-remove_field)     | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |
| [`remove_tag`](#v3.0.8-plugins-filters-csv-remove_tag)         | [array](/docs/reference/logstash/plugins/value-types#array)     | No       |


### `add_field`

- Value type is [hash](/docs/reference/logstash/plugins/value-types#hash)
- Default value is `{}`

If this filter is successful, add any arbitrary fields to this event. Field names can be dynamic and include parts of the event using the `%{field}`.
Example:
```
    filter {
      csv {
        add_field => { "foo_%{somefield}" => "Hello world, from %{host}" }
      }
    }
```

```
    # You can also add multiple fields at once:
    filter {
      csv {
        add_field => {
          "foo_%{somefield}" => "Hello world, from %{host}"
          "new_field" => "new_static_value"
        }
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add field `foo_hello` if it is present, with the value above and the `%{host}` piece replaced with that value from the event. The second example would also add a hardcoded field.

### `add_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, add arbitrary tags to the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      csv {
        add_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also add multiple tags at once:
    filter {
      csv {
        add_tag => [ "foo_%{somefield}", "taggedy_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would add a tag `foo_hello` (and the second example would of course add a `taggedy_tag` tag).

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance by default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type, for example, if you have 2 csv filters. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
    filter {
      csv {
        id => "ABC"
      }
    }
```


### `periodic_flush`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `false`

Call the filter flush method at regular interval. Optional.

### `remove_field`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary fields from this event. Fields names can be dynamic and include parts of the event using the %{field} Example:
```
    filter {
      csv {
        remove_field => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple fields at once:
    filter {
      csv {
        remove_field => [ "foo_%{somefield}", "my_extraneous_field" ]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the field with name `foo_hello` if it is present. The second example would remove an additional, non-dynamic field.

### `remove_tag`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- Default value is `[]`

If this filter is successful, remove arbitrary tags from the event. Tags can be dynamic and include parts of the event using the `%{field}` syntax.
Example:
```
    filter {
      csv {
        remove_tag => [ "foo_%{somefield}" ]
      }
    }
```

```
    # You can also remove multiple tags at once:
    filter {
      csv {
        remove_tag => [ "foo_%{somefield}", "sad_unwanted_tag"]
      }
    }
```

If the event has field `"somefield" == "hello"` this filter, on success, would remove the tag `foo_hello` if it is present. The second example would remove a sad, unwanted tag as well.