﻿---
title: Xmpp output plugin v3.0.6
description: Plugin version: v3.0.6, Released on: 2017-08-16, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-6-plugins-outputs-xmpp
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Xmpp output plugin v3.0.6
- Plugin version: v3.0.6
- Released on: 2017-08-16
- [Changelog](https://github.com/logstash-plugins/logstash-output-xmpp/blob/v3.0.6/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-xmpp-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-xmpp). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output allows you ship events over XMPP/Jabber.
This plugin can be used for posting events to humans over XMPP, or you can use it for PubSub or general message passing for logstash to logstash.

## Xmpp Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.6-plugins-outputs-xmpp-common-options) described later.

| Setting                                             | Input type                                                        | Required |
|-----------------------------------------------------|-------------------------------------------------------------------|----------|
| [`host`](#v3.0.6-plugins-outputs-xmpp-host)         | [string](/docs/reference/logstash/plugins/value-types#string)     | No       |
| [`message`](#v3.0.6-plugins-outputs-xmpp-message)   | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`password`](#v3.0.6-plugins-outputs-xmpp-password) | [password](/docs/reference/logstash/plugins/value-types#password) | Yes      |
| [`rooms`](#v3.0.6-plugins-outputs-xmpp-rooms)       | [array](/docs/reference/logstash/plugins/value-types#array)       | No       |
| [`user`](#v3.0.6-plugins-outputs-xmpp-user)         | [string](/docs/reference/logstash/plugins/value-types#string)     | Yes      |
| [`users`](#v3.0.6-plugins-outputs-xmpp-users)       | [array](/docs/reference/logstash/plugins/value-types#array)       | No       |

Also see [Common options](#v3.0.6-plugins-outputs-xmpp-common-options) for a list of options supported by all output plugins.

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The xmpp server to connect to. This is optional. If you omit this setting, the host on the user/identity is used. (example.com for )

### `message`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The message to send. This supports dynamic strings like `%{host}`

### `password`

- This is a required setting.
- Value type is [password](/docs/reference/logstash/plugins/value-types#password)
- There is no default value for this setting.

The xmpp password for the user/identity.

### `rooms`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

if muc/multi-user-chat required, give the name of the room that you want to join: room@conference.domain/nick

### `user`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The user or resource ID, like .

### `users`

- Value type is [array](/docs/reference/logstash/plugins/value-types#array)
- There is no default value for this setting.

The users to send messages to

## Common options

These configuration options are supported by all output plugins:

| Setting                                                       | Input type                                                      | Required |
|---------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.6-plugins-outputs-xmpp-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.6-plugins-outputs-xmpp-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.6-plugins-outputs-xmpp-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 xmpp outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  xmpp {
    id => "my_plugin_id"
  }
}
```