﻿---
title: Ganglia output plugin v3.0.6
description: Plugin version: v3.0.6, Released on: 2018-04-06, Changelog. For other versions, see the overview list. To learn more about Logstash, see the Logstash...
url: https://www.elastic.co/docs/reference/logstash/versioned-plugins/v3-0-6-plugins-outputs-ganglia
products:
  - Logstash
applies_to:
  - Elastic Stack: Generally available
---

# Ganglia output plugin v3.0.6
- Plugin version: v3.0.6
- Released on: 2018-04-06
- [Changelog](https://github.com/logstash-plugins/logstash-output-ganglia/blob/v3.0.6/CHANGELOG.md)

For other versions, see the [overview list](https://www.elastic.co/docs/reference/logstash/versioned-plugins/output-ganglia-index).
To learn more about Logstash, see the [Logstash Reference](https://www.elastic.co/guide/en/logstash/current/index.html).

## Getting help

For questions about the plugin, open a topic in the [Discuss](http://discuss.elastic.co) forums. For bugs or feature requests, open an issue in [Github](https://github.com/logstash-plugins/logstash-output-ganglia). For the list of Elastic supported plugins, please consult the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_logstash_plugins).

## Description

This output allows you to pull metrics from your logs and ship them to ganglia’s gmond. This is heavily based on the graphite output.

## Ganglia Output Configuration Options

This plugin supports the following configuration options plus the [Common options](#v3.0.6-plugins-outputs-ganglia-common-options) described later.

| Setting                                                        | Input type                                                                                                                                                   | Required |
|----------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [`group`](#v3.0.6-plugins-outputs-ganglia-group)               | [string](/docs/reference/logstash/plugins/value-types#string)                                                                                                | No       |
| [`host`](#v3.0.6-plugins-outputs-ganglia-host)                 | [string](/docs/reference/logstash/plugins/value-types#string)                                                                                                | No       |
| [`lifetime`](#v3.0.6-plugins-outputs-ganglia-lifetime)         | [number](/docs/reference/logstash/plugins/value-types#number)                                                                                                | No       |
| [`max_interval`](#v3.0.6-plugins-outputs-ganglia-max_interval) | [number](/docs/reference/logstash/plugins/value-types#number)                                                                                                | No       |
| [`metric`](#v3.0.6-plugins-outputs-ganglia-metric)             | [string](/docs/reference/logstash/plugins/value-types#string)                                                                                                | Yes      |
| [`metric_type`](#v3.0.6-plugins-outputs-ganglia-metric_type)   | [string](/docs/reference/logstash/plugins/value-types#string), one of `["string", "int8", "uint8", "int16", "uint16", "int32", "uint32", "float", "double"]` | No       |
| [`port`](#v3.0.6-plugins-outputs-ganglia-port)                 | [number](/docs/reference/logstash/plugins/value-types#number)                                                                                                | No       |
| [`slope`](#v3.0.6-plugins-outputs-ganglia-slope)               | [string](/docs/reference/logstash/plugins/value-types#string), one of `["zero", "positive", "negative", "both", "unspecified"]`                              | No       |
| [`units`](#v3.0.6-plugins-outputs-ganglia-units)               | [string](/docs/reference/logstash/plugins/value-types#string)                                                                                                | No       |
| [`value`](#v3.0.6-plugins-outputs-ganglia-value)               | [string](/docs/reference/logstash/plugins/value-types#string)                                                                                                | Yes      |

Also see [Common options](#v3.0.6-plugins-outputs-ganglia-common-options) for a list of options supported by all output plugins.

### `group`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

Metric group

### `host`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `"localhost"`

The address of the ganglia server.

### `lifetime`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `300`

Lifetime in seconds of this metric

### `max_interval`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `60`

Maximum time in seconds between gmetric calls for this metric.

### `metric`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The metric to use. This supports dynamic strings like `%{host}`

### `metric_type`

- Value can be any of: `string`, `int8`, `uint8`, `int16`, `uint16`, `int32`, `uint32`, `float`, `double`
- Default value is `"uint8"`

The type of value for this metric.

### `port`

- Value type is [number](/docs/reference/logstash/plugins/value-types#number)
- Default value is `8649`

The port to connect on your ganglia server.

### `slope`

- Value can be any of: `zero`, `positive`, `negative`, `both`, `unspecified`
- Default value is `"both"`

Metric slope, represents metric behavior

### `units`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- Default value is `""`

Gmetric units for metric, such as "kb/sec" or "ms" or whatever unit this metric uses.

### `value`

- This is a required setting.
- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

The value to use. This supports dynamic strings like `%{bytes}` It will be coerced to a floating point value. Values which cannot be coerced will zero (0)

## Common options

These configuration options are supported by all output plugins:

| Setting                                                          | Input type                                                      | Required |
|------------------------------------------------------------------|-----------------------------------------------------------------|----------|
| [`codec`](#v3.0.6-plugins-outputs-ganglia-codec)                 | [codec](/docs/reference/logstash/plugins/value-types#codec)     | No       |
| [`enable_metric`](#v3.0.6-plugins-outputs-ganglia-enable_metric) | [boolean](/docs/reference/logstash/plugins/value-types#boolean) | No       |
| [`id`](#v3.0.6-plugins-outputs-ganglia-id)                       | [string](/docs/reference/logstash/plugins/value-types#string)   | No       |


### `codec`

- Value type is [codec](/docs/reference/logstash/plugins/value-types#codec)
- Default value is `"plain"`

The codec used for output data. Output codecs are a convenient method for encoding your data before it leaves the output without needing a separate filter in your Logstash pipeline.

### `enable_metric`

- Value type is [boolean](/docs/reference/logstash/plugins/value-types#boolean)
- Default value is `true`

Disable or enable metric logging for this specific plugin instance. By default we record all the metrics we can, but you can disable metrics collection for a specific plugin.

### `id`

- Value type is [string](/docs/reference/logstash/plugins/value-types#string)
- There is no default value for this setting.

Add a unique `ID` to the plugin configuration. If no ID is specified, Logstash will generate one. It is strongly recommended to set this ID in your configuration. This is particularly useful when you have two or more plugins of the same type. For example, if you have 2 ganglia outputs. Adding a named ID in this case will help in monitoring Logstash when using the monitoring APIs.
```
output {
  ganglia {
    id => "my_plugin_id"
  }
}
```